/*
*                     Copyright 2016-2020, NXP
*
*       All rights are reserved. Reproduction in whole or in part is
*      prohibited without the written consent of the copyright owner.
*  NXP reserves the right to make changes without notice at any time.
* NXP makes no warranty, expressed, implied or statutory, including but
* not limited to any implied warranty of merchantability or fitness for any
*particular purpose, or that the use will not infringe any third party patent,
* copyright or trademark. NXP must not be liable for any loss or damage
*                          arising from its use.
*/

/** @file
 *
 * phExCcid.h: phExCcid application Api signatures and other declarations.
 *
 * Project:  PN7462AU
 *
 * $Date: 2015-05-08 12:19:15 +0530 (Fri, 08 May 2015) $
 * $Author: nxp86397 $
 * $Revision: 1150 $ (v07.12.00)
 */

#ifndef PHEXCCID_H
#define PHEXCCID_H

/* *****************************************************************************************************************
 * Includes
 * ***************************************************************************************************************** */
#include "ph_Datatypes.h"
#include "phacDiscLoop.h"
#include "ph_Status.h"
#include "phRtos.h"
#include "phExCcid_Cfg.h"
#include "phhalTimer.h"

#ifdef __CODE_RED
#    include <stdio.h>
#endif

/* *****************************************************************************************************************
 * MACROS/Defines
 * ***************************************************************************************************************** */

/* *****************************************************************************************************************
 * Types/Structure Declarations
 * ***************************************************************************************************************** */

/* *****************************************************************************************************************
 * Extern Variables
 * ***************************************************************************************************************** */
extern phRtos_QueueHandle_t gphExCcid_Clif_SysTask_Queue;
extern phhalTimer_Timers_t *gpphExCcid_PollTimer;
extern uint8_t gphExCcid_Clif_PollLoopLOGCount;

/* *****************************************************************************************************************
 * Function Prototypes
 * ***************************************************************************************************************** */
void phExCcid_SystemTask(void *pvParams);
extern void phExCcid_TimerCallBackFunc(void);

#endif /* PHEXCCID_H */
