/*----------------------------------------------------------------------------*/
/* Copyright 2014-2015,2021 NXP                                               */
/*                                                                            */
/* NXP Confidential. This software is owned or controlled by NXP and may only */
/* be used strictly in accordance with the applicable license terms.          */
/* By expressly accepting such terms or by downloading, installing,           */
/* activating and/or otherwise using the software, you are agreeing that you  */
/* have read, and that you agree to comply with and are bound by, such        */
/* license terms. If you do not agree to be bound by the applicable license   */
/* terms, then you may not retain, install, activate or otherwise use the     */
/* software.                                                                  */
/*----------------------------------------------------------------------------*/

/** @file
 *
 * phExMain_Cfg.h : phExMain application configuration file for specifying EMVCO/NFC compliance, Task and its
 *                  stack etc.
 *
 * Project:  PN7462AU
 *
 * $Date: 2016-09-20 12:38:43 +0530 (Tue, 20 Sep 2016) $
 * $Author: Anish Ahammed (nxp86397) $
 * $Revision: 18667 $ (v07.12.00)
 */

#ifndef PHEXMAIN_CFG_H
#define PHEXMAIN_CFG_H

/* *****************************************************************************************************************
 * Includes
 * ***************************************************************************************************************** */
#include "ph_Datatypes.h"
#include "ph_Log.h"

/* *****************************************************************************************************************
 * MACROS/Defines
 * ***************************************************************************************************************** */

#ifdef PHFL_HALAPI_WITH_RTOS

#define PHFL_SYS_TASK_Q_LEN             2   /* Max System task requests in queue. */

#define PHFL_EVENT_CLIF_Q_LEN           4   /* Max Clif Task requests in Queue. */
#define PHFL_EVENT_CT_Q_LEN             4   /* Max CT Task requests in Queue. */

/* Stack Guard to facilitate minor changes in phExMain example application. */
#define PH_EXMAIN_CFG_RTOS_STACK_GUARD                25
#endif
/* Minimum number of words (4 bytes/word) required to print the status logs on console screen for different tasks. */
#if PHFL_LOG_ENABLE
#    define PH_EXMAIN_CFG_SYSTEM_LOG_STACK               105
#    define PH_EXMAIN_CFG_CLIF_LOG_STACK                 0
#    define PH_EXMAIN_CFG_CT_LOG_STACK                   75
#else
#    define PH_EXMAIN_CFG_SYSTEM_LOG_STACK               0
#    define PH_EXMAIN_CFG_CLIF_LOG_STACK                 0
#    define PH_EXMAIN_CFG_CT_LOG_STACK                   0
#endif /* PHFL_LOG_ENABLE */
#ifdef PHFL_HALAPI_WITH_RTOS
/**
 *  Note actual allocation is x4 bytes
 */

#define PH_EXMAIN_CFG_RTOS_CLIF_TASK_STACK_SIZE    (330+ PH_EXMAIN_CFG_RTOS_STACK_GUARD + PH_EXMAIN_CFG_CLIF_LOG_STACK+20)
#define PH_EXMAIN_CFG_RTOS_CLIF_TASK_PRIORITY      4   /* Medium  */

/**
 *  Note actual allocation is x4 bytes
 */

#define PH_EXMAIN_CFG_RTOS_CT_TASK_STACK_SIZE      (200 + PH_EXMAIN_CFG_RTOS_STACK_GUARD + PH_EXMAIN_CFG_CT_LOG_STACK)
#define PH_EXMAIN_CFG_RTOS_CT_TASK_PRIORITY        5    /* Highest  */

/**
 *  Note actual allocation is x4 bytes
 */

#define PH_EXMAIN_CFG_RTOS_SYS_TASK_STACK_SIZE    (75 + PH_EXMAIN_CFG_RTOS_STACK_GUARD + PH_EXMAIN_CFG_SYSTEM_LOG_STACK)
#define PH_EXMAIN_CFG_RTOS_SYS_TASK_PRIORITY      3  /* Low */
#endif

/** Enable/Assist SWD Based download _WITH_ Standby
 *
 * When the IC goes to standby/sleep mode/low power mode, SWD Connection is lost.
 *
 * If the IC enters standby, say, immediately after boot up, SWD download won't work.
 * under such circumstances, the user is expected to pull high/low (based on the board
 * configuration) a compile time configurable GPIO.
 *
 * During FW boot up, if a compile time configured /ASSERTED/ value is sensed on the
 * the GPIO, FW Boot up is halted, and thus the Connection over SWD Lines is retained.
 *
 * PH_EXMAIN_CFG_SWD_DNLD_PIN is the GPIO Number that is used to sense such work around.
 * #PH_EXMAIN_CFG_SWD_DNLD_PIN_ASSERT_HALT_VALUE is the value expected to halt the boot.
 *
 */
#define PH_EXMAIN_CFG_SWD_DNLD_PIN                    8

/* The value which will /NOT/ let boot up continue. But /HALT/ the system
 * so the SWD based download can run. @see PH_EXMAIN_CFG_SWD_DNLD_PIN
 *
 * Do not define this value if you don't want wait on GPIO before entering
 * standby.
 *
 * Customer board v1.0 => 1
 * Customer board v1.1 => 0
 * Customer board v2.0 => 1
 * Customer board v2.1 => 1
 */
#define PH_EXMAIN_CFG_SWD_DNLD_PIN_ASSERT_HALT_VALUE  1

#define PH_EXMAIN_USETXLDO_EXTERNAL               0x0
#define PH_EXMAIN_TXLDO_MONITOR_ENABLE            0x1
/* *****************************************************************************************************************
 * Types/Structure Declarations
 * ***************************************************************************************************************** */

/* *****************************************************************************************************************
 * Extern Variables
 * ***************************************************************************************************************** */

/* *****************************************************************************************************************
 * Function Prototypes
 * ***************************************************************************************************************** */

#endif /* PHEXMAIN_CFG_H */
