/*----------------------------------------------------------------------------*/
/* Copyright 2016-2023 NXP                                                    */
/*                                                                            */
/* NXP Confidential. This software is owned or controlled by NXP and may only */
/* be used strictly in accordance with the applicable license terms.          */
/* By expressly accepting such terms or by downloading, installing,           */
/* activating and/or otherwise using the software, you are agreeing that you  */
/* have read, and that you agree to comply with and are bound by, such        */
/* license terms. If you do not agree to be bound by the applicable license   */
/* terms, then you may not retain, install, activate or otherwise use the     */
/* software.                                                                  */
/*----------------------------------------------------------------------------*/

/** @file
 *
 * USB Stack specific Compile time Build Configuration
 *
 * Project:  PN7462AU
 *
 * $Date: $
 * $Author: $
 * $Revision: $ (v07.12.00)
 */

#ifndef __APP_USBD_CFG_H
#define __APP_USBD_CFG_H

#include "ph_Datatypes.h"
#include "ph_NxpBuild.h"
#include "mw_usbd.h"

/*
 * MACROS DEFINITIONS
 */

#define PN7462AU_USB_BASE                      0x40028000UL

#define USB_STRING_LEN(UnicodeChars)        (2 + ((UnicodeChars) << 1))
#define LANGUAGE_ID_ENG                     0x0409

#define USB_APP_IF_NUM                      1         /*!< Interface Number used for Application requirement.*/
#define USB_APP_EP_NUM                      3         /*!< End Point Number used for Application requirement.*/

#define USB_MAX_IF_NUM                      3
#define USB_MAX_EP_NUM                      6 //7
#define USB_MAX_PACKET0                     64
#define USB_FS_MAX_BULK_PACKET              64
#define USB_HS_MAX_BULK_PACKET              64

#define FULL_SPEED_ONLY

#endif
