/*----------------------------------------------------------------------------*/
/* Copyright 2016-2023 NXP                                                    */
/*                                                                            */
/* NXP Confidential. This software is owned or controlled by NXP and may only */
/* be used strictly in accordance with the applicable license terms.          */
/* By expressly accepting such terms or by downloading, installing,           */
/* activating and/or otherwise using the software, you are agreeing that you  */
/* have read, and that you agree to comply with and are bound by, such        */
/* license terms. If you do not agree to be bound by the applicable license   */
/* terms, then you may not retain, install, activate or otherwise use the     */
/* software.                                                                  */
/*----------------------------------------------------------------------------*/

/** @file
 *
 * phExNFCCcid_Usb_If.h: USB Interface System specific Initialization
 *
 * Project:  PN7462AU
 *
 * $Date: $
 * $Author: $
 * $Revision: $ (v07.12.00)
 */

#ifndef PHEXNFCCCID_USB_IF_H
#define PHEXNFCCCID_USB_IF_H

/* *****************************************************************************************************************
 * Includes
 * ***************************************************************************************************************** */
#include "ph_Datatypes.h"
#include "PN7462AU/PN7462AU_usb.h"
#include "ph_Status.h"
#include "phhalPcr.h"
#include "app_usbd_cfg.h"

/* *****************************************************************************************************************
 * MACROS/Defines
 * ***************************************************************************************************************** */
#ifdef __ICCARM__
#define _PPTOSTR_(x) #x
#define PRAGMA_WEAK(func,alias)  _Pragma(_PPTOSTR_(weak func=alias))
#define ATTR_WEAK
#define ATTR_ALIAS(Func)
#else
#define PRAGMA_WEAK(func,alias)
#define ATTR_WEAK                   __attribute__ ((weak))
#define ATTR_ALIAS(Func)            __attribute__ ((alias( #Func )))
#endif

#define USBHAL_CORE_MEM_SIZE                0x500
#define USBHAL_CCID_MEM_SIZE                0x100

#define PN7462AU_USB_MAX_PACKET_SIZE        USB_FS_MAX_BULK_PACKET

#define PHHAL_HIF_USB_PLL_DETECTIONWINDOWLEN_TMP (0x0D)
#define PHHAL_HIF_USB_PLL_CLKEDGESNUM_TMP        (0x80)

/* *****************************************************************************************************************
 * Extern Variables
 * ***************************************************************************************************************** */
extern volatile uint8_t gphExNFCCcid_Usb_CORE_Buffer[USBHAL_CORE_MEM_SIZE];
extern volatile uint8_t gphExNFCCcid_Usb_CCID_buffer[USBHAL_CCID_MEM_SIZE];
extern USBD_HANDLE_T UsbHandle;

/* *****************************************************************************************************************
 * Function Prototypes
 * ***************************************************************************************************************** */
phStatus_t phExNFCCcid_Usb_If_Init(void);
phStatus_t phExNFCCcid_Usb_If_TotalInit(void);

void phExNFCCcid_Usbd_CORE_Init (void);
void phExNFCCcid_Usbd_CCID_Init (void);
void phExNFCCcid_Usbd_Connect_Enable(void);

#if (PH_EXNFCCCID_USB_IF_USB_SUSPEND_RESUME_FTR == 1)
phStatus_t phExNFCCcid_Usb_If_Suspend();
void phExNFCCcid_Usb_If_Resume();
void phExNFCCcid_Usbd_Remote_Wakeup();

#endif

#endif /* __HALUSB_H */
