/*----------------------------------------------------------------------------*/
/* Copyright 2014-2016,2022-2023 NXP                                          */
/*                                                                            */
/* NXP Confidential. This software is owned or controlled by NXP and may only */
/* be used strictly in accordance with the applicable license terms.          */
/* By expressly accepting such terms or by downloading, installing,           */
/* activating and/or otherwise using the software, you are agreeing that you  */
/* have read, and that you agree to comply with and are bound by, such        */
/* license terms. If you do not agree to be bound by the applicable license   */
/* terms, then you may not retain, install, activate or otherwise use the     */
/* software.                                                                  */
/*----------------------------------------------------------------------------*/

/** @file
 *
 * phExRf Application specific Compile time Build Configuration that requires CLIF and utility HALS.
 *
 * Project: PN7462AU
 *
 * $Date: $
 * $Author: NXP $
 * $Revision: $ (v07.12.00)
 */

#ifndef APP_NXP_BUILD_H
#define APP_NXP_BUILD_H

/****************************************************************************************
 * HAL COMPONENTS
 ***************************************************************************************/
#define NXPBUILD__PHHAL_CLKGEN
#define NXPBUILD__PHHAL_PCR
#define NXPBUILD__PHHAL_PMU
#define NXPBUILD__PHHAL_RNG
#define NXPBUILD__PHHAL_TIMER
#define NXPBUILD__PHHAL_RF
#define NXPBUILD__PHHAL_LED
#define NXPBUILD__CFG_FROM_EE
#define NXPBUILD__PHHAL_EEPROM

#define NXPBUILD__CLIF_RM

#define NXPBUILD__PHHAL_RF_DPC                 /**< Tx Over Current Protection Feature. */
#define NXPBUILD__PHHAL_RF_PCD_SHAPING         /**< PCD Shaping Feature. */

#define NXPBUILD__PHPAL_PR_ISSUE               /**< PN7462AU PR to ReaderLib Definition */

#ifdef PH_OSAL_NULLOS
    #define PHFL_HALAPI_NO_RTOS
#endif

#define NXPBUILD__PH_OSAL_NULLOS               /* Software OSAL for No Rtos */
#define NXPBUILD__PH_OSAL_STUB

/* #define PHFL_ENABLE_EXTERNAL_TVDD_3V_MON */  /* Enable if TVDD 3V Monitor is selected */
#endif /* APP_NXP_BUILD_H */
