/*
 *                    Copyright (c), NXP Semiconductors
 *
 *                       (C) NXP Semiconductors 2014,2015
 *
 *         All rights are reserved. Reproduction in whole or in part is
 *        prohibited without the written consent of the copyright owner.
 *    NXP reserves the right to make changes without notice at any time.
 *   NXP makes no warranty, expressed, implied or statutory, including but
 *   not limited to any implied warranty of merchantability or fitness for any
 *  particular purpose, or that the use will not infringe any third party patent,
 *   copyright or trademark. NXP must not be liable for any loss or damage
 *                            arising from its use.
 */

/** @file
 *
 * Run Time configuration settings extracted from EEPROM/FLASH.
 *
 * Project:  PN7462AU
 *
 * $Date: 2016-07-04 23:48:03 +0530 (Mon, 04 Jul 2016) $
 * $Author: Purnank G (ing05193) $
 * $Revision: 18541 $ (v04.18.00)
 */

/* ****************************************************************************************************************** */
/* Generated by user_ee.py version 2016.06.29_00 on 2019-11-13
 */

#ifndef PHCFG_EE_H
#define PHCFG_EE_H

/* PRQA S 0639 ++ */
#include "ph_Datatypes.h"

#ifdef NXPBUILD__CFG_ENABLE_EE_DOWNLOAD
    extern const uint8_t phCfg_EE_Build_Values[];
#endif /* NXPBUILD__CFG_ENABLE_EE_DOWNLOAD*/

/* ****************************************************************************************************************** */
/** \name Page: ErrorMem
 * Error Memory written by ROM in case of error
 */

#define PH_CFG_EE_ERR_START_ADDRESS (0x201200)
/** Structure: Err
 * Error information during ROM APIs
 */
typedef PH_PACK_STRUCT_BEGIN struct phCfg_EE_ErrorMem_Err
{
    /**
     * Reserved for MRA2 and MRA3
     */
    uint8_t str_name[36];                                                   /* default value = IntentionallyEmpty(cstring) */
    /**
     * Error information from ROM Boot
     */
    uint32_t dwCauseCode;                                                   /* 00(hex) */
} PH_PACK_STRUCT_END phCfg_EE_ErrorMem_Err_t, * pphCfg_EE_ErrorMem_Err_t;

extern const phCfg_EE_ErrorMem_Err_t * const gpkphCfg_EE_ErrorMem_Err;

/* ****************************************************************************************************************** */
/** \name Page: Ctrl
 * Master Control Block for EEPROM
 */

/** Major Version */
#define PH_CFG_EE_VER_MAJOR   (28)
/** Minor Version */
#define PH_CFG_EE_VER_MINOR   (0)
/** Development Version */
#define PH_CFG_EE_VER_DEVELOPMENT   (0)

#define PH_CFG_EE_VERINFO_START_ADDRESS (0x201240)
/** Structure: VerInfo
 *
 * <pre>
 *     Version Information of the Layout
 * 	Version 28.0.0: artf178091: [CR][FW][TXOCP] Load dependent RX gain control
 * 	Version 27.0.0: artf203315 : The Default TVDD source config to be External. DPC 5V by default.
 * 	Version 27.0.0: Clif EEPROM 1.9.2v Settings.
 * 	Version 26.0.0: artf157683 : Changing the wWaitTime of Tx Ldo Params. [15:14] : Lfo Clock Value and [13:0] : Waiting Time after TxLdo is started.
 * 	Version 25.5.0: artf156243 : Update according to the Analysis Information.
 * 	Version 25.4.0: wWaitTime value for Tx Ldo start ir changed from 250us to 1100us.
 *     Version 25.3.0: dwTidtTimeAdjust field added.
 *     Version 25.2.0: RRDD value changed from 28us to 50us and dwExtRfOnTime values to 302us.
 *     Version 25.1.0: Adding the RRDD and Fdt values for Jewel.
 *     Version 25.0.0: Clif EEPROM 1.9v settings
 *     <hr />
 *     Version 24.0.2: [RC4] CLIF_ANA_NFCLD_REG.CM_RFL_NFC set to 7.  [MRA3] v1.8.3 of EEPROM
 *     Version 24.0.1: Refactored dwFelicaRxRMSigproTime
 *     Version 24.0.0: Removed the Rf On and Off De-bouncing structure.
 *                   : Added Rf Inter-Op timings structure and Rf hal timings
 *                   : for different algos.
 *     Version 23.9.0: CLIF_ANA_NFCLD_REG.CM_RFL_NFC value changed from 7 to 3
 *     Version 23.8.0: [MRA2] v1.8   of EEPROM
 *     Version 23.7.0: [MRA2] v1.7.4 of EEPROM
 *     Version 23.6.0: [MRA2] ClkGenClifClockStart->ClkModeAlmCm set to 0x50
 * </pre>
 *
 */
typedef PH_PACK_STRUCT_BEGIN struct phCfg_EE_Ctrl_VerInfo
{
    /**
     * Major Version
     */
    uint16_t major;                                                         /* 28(int) */
    /**
     * Minor Version
     */
    uint8_t minor;                                                          /* 0(int) */
    /**
     * Development Version
     */
    uint8_t development;                                                    /* 0(int) */
    /**
     * Canonical name to identify the EE Layout
     */
    uint8_t str_name[32];                                                   /* default value = Rf#v1.9(cstring) */
} PH_PACK_STRUCT_END phCfg_EE_Ctrl_VerInfo_t, * pphCfg_EE_Ctrl_VerInfo_t;

extern const phCfg_EE_Ctrl_VerInfo_t * const gpkphCfg_EE_Ctrl_VerInfo;

/* ****************************************************************************************************************** */
/** \name Page: Boot
 * These values are used during during Boot up and applied to HW IPs
 */

#define PH_CFG_EE_RNG_START_ADDRESS (0x201280)
/** Structure: RNG
 * Random Number Generator. \see phhalRng_Init
 */
typedef PH_PACK_STRUCT_BEGIN struct phCfg_EE_Boot_RNG
{
    /**
     * Programmable wait time to release gated clocks feeding the TRNG
     */
    uint8_t bTrngFeedTimeout;                                               /* 26(hex) */
} PH_PACK_STRUCT_END phCfg_EE_Boot_RNG_t, * pphCfg_EE_Boot_RNG_t;

extern const phCfg_EE_Boot_RNG_t * const gpkphCfg_EE_Boot_RNG;

#define PH_CFG_EE_CLKGEN_START_ADDRESS (0x201284)
/** Structure: ClkGen
 * Clock Generator.  \ref phhalClkGen_Init
 */
typedef PH_PACK_STRUCT_BEGIN struct phCfg_EE_Boot_ClkGen
{
    /**
     * dwXtalActivationTimeOut Activation time out value
     */
    uint16_t wXtalActivationTimeOut;                                        /* 2000(int) */
    /**
     * eSource Clock source selection, \see phhalClkGen_Source_t
     */
    uint8_t eSource;                                                        /* 00(hex) */
    /**
     * bKickOnError Kick on error.
     */
    uint8_t bKickOnError;                                                   /* 00(hex) */
} PH_PACK_STRUCT_END phCfg_EE_Boot_ClkGen_t, * pphCfg_EE_Boot_ClkGen_t;

extern const phCfg_EE_Boot_ClkGen_t * const gpkphCfg_EE_Boot_ClkGen;

#define PH_CFG_EE_PCRPWRTEMPCONFIG_START_ADDRESS (0x201288)
/** Structure: PcrPwrTempConfig
 * Power Clock Reset Temperature Configuration related to \see phhalPcr_PwrTempConfig_t
 *
 *                 \warning This structure is tightly linked to \ref phhalPcr_PwrTempConfig_t
 *
 */
typedef PH_PACK_STRUCT_BEGIN struct phCfg_EE_Boot_PcrPwrTempConfig
{
    /**
     * Flag to indicate to use temperature sensor 0 or not
     * - 0 => Disabled
     * - 1 => Enabled
     */
    uint8_t bUseTempSensor0;                                                /* 0(int) */
    /**
     * Flag to indicate to use temperature sensor 1 or not
     * - 0 => Disabled
     * - 1 => Enabled
     */
    uint8_t bUseTempSensor1;                                                /* 0(int) */
    /**
     * - 0 => 135
     * - 1 => 130
     * - 2 => 125
     * - 3 => 120
     */
    uint8_t bLowTempTarget0;                                                /* 3(int) */
    /**
     * - 0 => 135
     * - 1 => 130
     * - 2 => 125
     * - 3 => 120
     */
    uint8_t bLowTempTarget1;                                                /* 3(int) */
    /**
     * - 0 => 135
     * - 1 => 130
     * - 2 => 125
     * - 3 => 120
     */
    uint8_t bHighTempTarget0;                                               /* 0(int) */
    /**
     * - 0 => 135
     * - 1 => 130
     * - 2 => 125
     * - 3 => 120
     */
    uint8_t bHighTempTarget1;                                               /* 0(int) */
} PH_PACK_STRUCT_END phCfg_EE_Boot_PcrPwrTempConfig_t, * pphCfg_EE_Boot_PcrPwrTempConfig_t;

extern const phCfg_EE_Boot_PcrPwrTempConfig_t * const gpkphCfg_EE_Boot_PcrPwrTempConfig;

#define PH_CFG_EE_PCRPWRDOWN_START_ADDRESS (0x201290)
/** Structure: PcrPwrDown
 * See \ref phhalPcr_PwrDown_Setting_t
 *
 * It is a 32 bit value bit-file created by ORing enums of type \ref phhalPcr_PwrDown_Setting_t used to select which settings must be applied to reduce power consumption during Suspend
 */
typedef PH_PACK_STRUCT_BEGIN struct phCfg_EE_Boot_PcrPwrDown
{
    /**
     * 0x7FFFFFFF : E_APPLY_ALL_SETTNGS. i.e.  all power reduction settings will be applied during Suspend
     */
    uint32_t dwPwrDownSettings;                                             /* 7FFFFFFF(hex) */
} PH_PACK_STRUCT_END phCfg_EE_Boot_PcrPwrDown_t, * pphCfg_EE_Boot_PcrPwrDown_t;

extern const phCfg_EE_Boot_PcrPwrDown_t * const gpkphCfg_EE_Boot_PcrPwrDown;

#define PH_CFG_EE_TXANASTANDBYCONFIG_START_ADDRESS (0x201294)
/** Structure: TxAnaStandByConfig
 * TxAna register settings for standby  \see phhalPcr_TxAnaStandByConfig_t
 */
typedef PH_PACK_STRUCT_BEGIN struct phCfg_EE_Boot_TxAnaStandByConfig
{
    /**
     * To hold CLIF standby GSN value selection
     */
    uint32_t dwAnaTxStandByValue;                                           /* 0F(hex) */
    /**
     * To hold the CLIF configuration related to powerdown
     */
    uint32_t dwAnaTxProtStandByValue;                                       /* 03(hex) */
} PH_PACK_STRUCT_END phCfg_EE_Boot_TxAnaStandByConfig_t, * pphCfg_EE_Boot_TxAnaStandByConfig_t;

extern const phCfg_EE_Boot_TxAnaStandByConfig_t * const gpkphCfg_EE_Boot_TxAnaStandByConfig;

#define PH_CFG_EE_EEPROM_START_ADDRESS (0x20129c)
/** Structure: EEPROM
 * EEPROM Access Settings. \see phhalEeprom_Init
 */
typedef PH_PACK_STRUCT_BEGIN struct phCfg_EE_Boot_EEPROM
{
    /**
     * Disable Fast mode for EEPROM access
     * - 0 => Disabled
     * - 1 => Enabled
     */
    uint8_t bEnableFastMode;                                                /* 0(int) */
} PH_PACK_STRUCT_END phCfg_EE_Boot_EEPROM_t, * pphCfg_EE_Boot_EEPROM_t;

extern const phCfg_EE_Boot_EEPROM_t * const gpkphCfg_EE_Boot_EEPROM;

#define PH_CFG_EE_FLASH_START_ADDRESS (0x2012a0)
/** Structure: FLASH
 * Flash Settings. \see phhalFlash_Init
 */
typedef PH_PACK_STRUCT_BEGIN struct phCfg_EE_Boot_FLASH
{
    /**
     * Enable or Disable fast mode for Page Flash access
     * - 0 => Disabled
     * - 1 => Enabled
     */
    uint8_t bEnableFastMode;                                                /* 0(int) */
    /**
     * Setting to decide if program phase will be attempted in the event of an erase phase failure
     * - 0 => Program phase will be attempted even if erase phase failed
     * - 1 => Program phase will be skipped if erase phase failed
     */
    uint8_t bEnableSkipProgramOnEraseFail;                                  /* 1(int) */
} PH_PACK_STRUCT_END phCfg_EE_Boot_FLASH_t, * pphCfg_EE_Boot_FLASH_t;

extern const phCfg_EE_Boot_FLASH_t * const gpkphCfg_EE_Boot_FLASH;

#define PH_CFG_EE_TXLDOPARAMS_START_ADDRESS (0x2012a4)
/** Structure: TxLdoParams
 * Power management unit. \see phhalPmu_TxLdoInit and \see phhalPmu_TxLdoParams_t
 */
typedef PH_PACK_STRUCT_BEGIN struct phCfg_EE_Boot_TxLdoParams
{
    /**
     * Parameter to use internal TxLDO or external TxLDO for TVDD Source
     * - 0 => Use external TxLDO
     * - 1 => Use internal TxLDO
     */
    uint8_t bUseTxLdo;                                                      /* 00(hex) */
    /**
     * TVDD Power Selection for Reader Mode. \see phhalPmu_TvddSel_t
     * - 0 => 3V
     * - 1 => 3.3V
     * - 2 => 3.6v
     * - 3 => 4.5V
     * - 4 => 4.7v
     * - other => Invalid
     */
    uint8_t eFullPowerTvddSel;                                              /* 04(hex) */
    /**
     * Source for the TVDD \see phhalPmu_LowPower_TvddSrc_t
     * - 0 => Source is TVDD In
     * - 1 => Source is VUP
     * - 2 => Source is VBUS
     * - other => Invalid
     */
    uint8_t eLowPowerTvddSrc;                                               /* 00(hex) */
    /**
     * Over Current Interrupt Enable or disable
     * - 0 => Disabled
     * - Others => Enable
     */
    uint8_t bOverCurrentEnable;                                             /* 00(hex) */
    /**
     * [15:14] : Lfo Clock Value and [13:0] : Waiting Time after TxLdo is started. Lfo Clk = 3 and Waiting Time = 1120us.
     */
    uint16_t wWaitTime;                                                     /* 50272(int) */
} PH_PACK_STRUCT_END phCfg_EE_Boot_TxLdoParams_t, * pphCfg_EE_Boot_TxLdoParams_t;

extern const phCfg_EE_Boot_TxLdoParams_t * const gpkphCfg_EE_Boot_TxLdoParams;

#define PH_CFG_EE_CT_START_ADDRESS (0x2012ac)
/** Structure: CT
 * Initial settings for CT Interface. \see phhalCt_InitParam_t
 */
typedef PH_PACK_STRUCT_BEGIN struct phCfg_EE_Boot_CT
{
    /**
     * Pull UP Configuration
     * - 0 => Pull Down
     * - 1 => Pull UP
     * - others => Undefined behaviour
     */
    uint8_t bPullUp;                                                        /* 1(hex) */
    /**
     * Connector Type
     * - 0 => Normally Closed
     * - others => Normally Open
     */
    uint8_t bConnectorType;                                                 /* 1(hex) */
    /**
     * Auto deactivation
     * - 0 => Disabled
     * - others => Enabled
     */
    uint8_t bAutoCTDeactivationEnable;                                      /* 1(hex) */
    /**
     * CLK,IO,VCC slew rate
     * - 0 => CLK,IO,VCC slew rate
     * - others => This value is directly mapped to ct_srr_reg
                    to give enough options
     */
    uint8_t bSlewRate;                                                      /* 38(hex) */
} PH_PACK_STRUCT_END phCfg_EE_Boot_CT_t, * pphCfg_EE_Boot_CT_t;

extern const phCfg_EE_Boot_CT_t * const gpkphCfg_EE_Boot_CT;

#define PH_CFG_EE_GPIO_START_ADDRESS (0x2012b0)
/** Structure: GPIO
 *
 *                     GPIO Bootup Configuration. Each byte represents a Gpio configuration starting from Gpio 1 to 12.
 *
 */
typedef PH_PACK_STRUCT_BEGIN struct phCfg_EE_Boot_GPIO
{
    /**
     * Lower Nibble - Related to output configuration
     *                         Upper Nibble - Related to Pull-up/Pull-down configuration
     * - Bit0=0 => Skip Configuration as output on Boot
     * - Bit0=1 => Configure Gpio as output
     * - Bit1=1 => Enable slew-rate
     * - Bit2=1 => Drive the output high
     * - Bit2=0 => Drive the output low
     * - Bit5=1 => Apply Pull UP
     * - Bit6=1 => Apply Pull Down
     */
    uint8_t OutputPUPD[12];
    /* default value = 00 00 00 00 00 00 03 03 07 03 03 03(hex) */
    /**
     * - ALL=0 => Skip Configuration on Boot
     * - Bit0=0 => Un-Configure as input
     * - Bit0=1 => Configure/SET as Input
     * - Bit1=1 => GPIO is a wakeup source
     * - Bit2=1 => GPIO is an interrupt source
     * - Bit4=1 => Level Sensitive Interrupt
     * - Bit5=1 => Interrupt on Active Low or Falling Edge
     * - Bit6=1 => Interrupt on Both Edges
     */
    uint8_t InputISR[12];
    /* default value = 00 00 00 00 00 00 00 00 00 00 00 00(hex) */
} PH_PACK_STRUCT_END phCfg_EE_Boot_GPIO_t, * pphCfg_EE_Boot_GPIO_t;

extern const phCfg_EE_Boot_GPIO_t * const gpkphCfg_EE_Boot_GPIO;

/* ****************************************************************************************************************** */
/** \name Page: HW
 * Hardware Configurations / Default settings.  These settings are not applied direclty at bootup but eventually during the course of usage of the IPs.
 */

#define PH_CFG_EE_WAKEUPCONFIG_START_ADDRESS (0x201300)
/** Structure: WakeUpConfig
 * Wakeup Sources \see phhalPcr_WakeUpConfig_t
 */
typedef PH_PACK_STRUCT_BEGIN struct phCfg_EE_HW_WakeUpConfig
{
    /**
     * Timer value for the wake up in milliseconds
     */
    uint16_t wWakeUpTimerVal;                                               /* 300(int) */
    /**
     * Flag to know the host interface wake up
     * - 0 => Disabled
     * - 1 => Enabled
     */
    uint8_t bEnableHIFWakeup;                                               /* 0(int) */
    /**
     * I2C address if the wake up is configured for HIF
     */
    uint8_t bI2CAddr;                                                       /* 28(hex) */
    /**
     * Flag to enable the wake up timer as wake up source
     * - 0 => Disabled
     * - 1 => Enabled
     */
    uint8_t bWakeUpTimer;                                                   /* 1(int) */
    /**
     * Flag to enable the RfLdt as wake up source
     * - 0 => Disabled
     * - 1 => Enabled
     */
    uint8_t bWakeUpRfLdt;                                                   /* 0(int) */
    /**
     * Flag to enable Pvdd current limitation as wake up source when it goes below the lower threshold
     * - 0 => Disabled
     * - 1 => Enabled
     */
    uint8_t bWakeUpPvddLim;                                                 /* 1(int) */
    /**
     * Flag to enable CT presence as wake up source when it goes below the lower threshold
     * - 0 => Disabled
     * - 1 => Enabled
     */
    uint8_t bWakeUpCtPr;                                                    /* 1(int) */
    /**
     * Flag to enable PVDD Auxiliary interrupt as wake up source when it goes below the lower threshold
     * - 0 => Disabled
     * - 1 => Enabled
     */
    uint8_t bWakeUpIntAux;                                                  /* 0(int) */
    /**
     * Flag to enable Tvdd Monitoring as wake up source when it goes below the lower threshold
     * - 0 => Disabled
     * - 1 => Enabled
     */
    uint8_t bWakeUpTvddMon;                                                 /* 0(int) */
    /**
     * Flag to enable Gpio as wake up source when it goes below the lower threshold
     * - 0 => Disabled
     * - 1 => Enabled
     */
    uint8_t bWakeUpGpio;                                                    /* 0(int) */
} PH_PACK_STRUCT_END phCfg_EE_HW_WakeUpConfig_t, * pphCfg_EE_HW_WakeUpConfig_t;

extern const phCfg_EE_HW_WakeUpConfig_t * const gpkphCfg_EE_HW_WakeUpConfig;

#define PH_CFG_EE_RFANTENNAE_START_ADDRESS (0x20130c)
/** Structure: RfAntennae
 * Antennae type. ALM or PLM
 */
typedef PH_PACK_STRUCT_BEGIN struct phCfg_EE_HW_RfAntennae
{
    /**
     * - 1 => ALM is used.
     * - 0 => PLM is used.
     */
    uint8_t enableALM;                                                      /* 0(hex) */
} PH_PACK_STRUCT_END phCfg_EE_HW_RfAntennae_t, * pphCfg_EE_HW_RfAntennae_t;

extern const phCfg_EE_HW_RfAntennae_t * const gpkphCfg_EE_HW_RfAntennae;

#define PH_CFG_EE_RFINITUSEREE_START_ADDRESS (0x201310)
/** Structure: RfInitUserEE
 * \see phhalRf_InitUserEE_t
 */
typedef PH_PACK_STRUCT_BEGIN struct phCfg_EE_HW_RfInitUserEE
{
    /**
     * Card mode AGC Config1 value
     */
    uint32_t dwAgcConfig1CMValue;                                           /* 0107FF7(hex) */
    /**
     * Card mode AGC Config0 value
     */
    uint32_t dwAgcConfig0CMValue;                                           /* 44003(hex) */
    /**
     * Reference value of AGC for LPCD
     */
    uint32_t dwLCPDRefValue;                                                /* 000020AC(hex) */
    /**
     * Threshold value for LPCD
     */
    uint32_t dwLCPDThreashold;                                              /* 00000005(hex) */
    /**
     * Duration value for LPCD
     */
    uint32_t dwLCPDDurations;                                               /* 00000028(hex) */
    /**
     * Card Mode most possible sensitive input value
     */
    uint16_t wAgcCMInputValue;                                              /* 00(hex) */
    /**
     * NFC LD Threshold value
     */
    uint8_t bAnaNFCLD;                                                      /* 0C(hex) */
    /**
     * Initial value for Ana Tx Prot Register
     */
    uint8_t bAnaTxProt;                                                     /* 09(hex) */
} PH_PACK_STRUCT_END phCfg_EE_HW_RfInitUserEE_t, * pphCfg_EE_HW_RfInitUserEE_t;

extern const phCfg_EE_HW_RfInitUserEE_t * const gpkphCfg_EE_HW_RfInitUserEE;

#define PH_CFG_EE_RFDPC_START_ADDRESS (0x201328)
/** Structure: RfDPC
 * \see phhalRf_DPCConfig_t
 */
typedef PH_PACK_STRUCT_BEGIN struct phCfg_EE_HW_RfDPC
{
    /**
     * Sets the value for the periodic regulation. Time base is 1/20Mhz. (Example: Value of 20000 is equal to 1ms)
     */
    uint16_t wControlCycle;                                                 /* 4E20(hex) */
    /**
     * Controls AGC FastMode (StepSizeEnabled: 13 + StepSize: 12..11 + DurationEnabled: 10 + Duration: 9..0 )
     */
    uint16_t wAgcFastModeConfig;                                            /* 2540(hex) */
    /**
     * Low threashold for gearshift
     */
    uint16_t wAgcTrshLow;                                                   /* 144(hex) */
    /**
     * Guard time after AGC fast mode has been triggered. This happens in the following scenarios:
     *             - End of Receive
     *             - End of Transmit
     *             - After a gear switch
     *             Time base is 1/20MHz (Example: Value of 2000 is equal to 100us)
     */
    uint16_t wGuardTimeFastMode;                                            /* 88B8(hex) */
    /**
     * Guard time after SoF or SC detection. This is to avoid any DPC regulation between SoF/SC and actual begin of reception. Time base is 1/20MHz (Example: Value of 2000 is equal to 100us)
     */
    uint16_t wGuardTimeSofDetected;                                         /* 61A8(hex) */
    /**
     * Guard time after Gear Switch during FieldOn instruction. Time base is 1/20MHz (Example: Value of 2000 is equal to 100us)
     */
    uint16_t wGuardTimeFieldOn;                                             /* 0190(hex) */
    /**
     * High threasholds for each gear
     */
    uint16_t wAgcTrshHigh[15];
    /* default value = 014A  014B  014A  0148  0146  0143  013D  012E  0170  00AD  00A7  009E  0096  0087  004A(hex) */
    /**
     * Control byte (StartGear: 7..4 bits + GearStep: 3..1 bits + OcProtLoopEnabled: 0 bit )
     */
    uint8_t bOcProtControl;                                                 /* 73(hex) */
    /**
     * Compensation value for the AGC
     */
    uint8_t bAgcXi;                                                         /* 0(hex) */
    /**
     * Enable/Disable debug signals
     */
    uint8_t bDebug;                                                         /* 0(hex) */
    /**
     * Shift value for AGC dynamic low threshold adjustment
     */
    uint8_t bAgcShiftValue;                                                 /* 05(hex) */
    /**
     * Number of fields in the following configuration look up table
     */
    uint8_t bSizeOfLUT;                                                     /* 09(hex) */
    /**
     * Look up table for configuration values
     */
    uint8_t bConfigLUT[15];
    /* default value = F9  F1  F3  F5  F7  F0  F2  F4  F6  96  66  46  36  26  16(hex) */
} PH_PACK_STRUCT_END phCfg_EE_HW_RfDPC_t, * pphCfg_EE_HW_RfDPC_t;

extern const phCfg_EE_HW_RfDPC_t * const gpkphCfg_EE_HW_RfDPC;

#define PH_CFG_EE_RFPCDSHAPING_START_ADDRESS (0x201368)
/** Structure: RfPcdShaping
 * \see phhalRf_PcdShapeConfig_t
 */
typedef PH_PACK_STRUCT_BEGIN struct phCfg_EE_HW_RfPcdShaping
{
    /**
     * The lookup table for the configuration for PCD shaping.
     */
    uint32_t dwConfiguration[20];
    /* default value = 08079991  00089991  17A09991  0040F991  0010B992  00209BA2  0040E9A2  00089A92  0080F992  08479093  080799A7  00089997  17309997  00014681  00104A85  00000000  00000000  00000000  00000000  00000000(hex) */
    /**
     * Number of elements in the following configuration look up table.
     */
    uint8_t bSizeOfLUT;                                                     /* 2D(hex) */
} PH_PACK_STRUCT_END phCfg_EE_HW_RfPcdShaping_t, * pphCfg_EE_HW_RfPcdShaping_t;

extern const phCfg_EE_HW_RfPcdShaping_t * const gpkphCfg_EE_HW_RfPcdShaping;

#define PH_CFG_EE_RFAPC_START_ADDRESS (0x2013bc)
/** Structure: RfAPC
 *  APC Settings
 *
 *
 */
typedef PH_PACK_STRUCT_BEGIN struct phCfg_EE_HW_RfAPC
{
    /**
     * Periodic timer to reapply RSSI while transceiver is in Wait4Data state. Unit is 128/fc (106kHz)
     * if set to 0 it means feature is not used
     * 0423 == ~10ms
     */
    uint16_t bRssiTimer;                                                    /* 423(hex) */
    /**
     * Size of LUT: DO NOT MODIFY this parameter
     */
    uint8_t bRssiLutSize;                                                   /* 10(hex) */
    /**
     * Number of entries in RSSI look up table (it refers to dwRssiEntry0 to dwRssiEntryX).
     * If set to 0 then no RSSI algo is applied
     */
    uint8_t bRssiNbEntries;                                                 /* 00(hex) */
    /**
     * Purpose of each bits:
     *
     * bits 26:24 = TXLDO output voltage: PMU_TXLDO_CONTROL_REG / TXLDO_SELECT
     *
     * bits 23:22 = CLIF_ANA_TX_AMPLITUDE_REG / TX_CW_AMPLITUDE_ALM_CM
     *
     * bits 21:21 = CLIF_TX_CONTROL_REG / TX_ALM_TYPE_SELECT
     *
     * bits 20:16 = CLIF_ANA_TX_AMPLITUDE_REG / TX_RESIDUAL_CARRIER
     *
     * bits 15:00 = CLIF_RSSI_REG / AGC_VALUE[15:6] + ADC_DATA_Q[5:0]
     */
    uint32_t dwRssiEntry[16];
    /* default value = 84000000  009806C0  00C41180  00D81E00  00DA2580  01202F80  00243700  00AA3E80  00000000  00000000  00000000  00000000  00000000  00000000  00000000  00000000(hex) */
    /**
     * Replacement of dwRssiEntry[0] for trigger ReqA/ReqB
     */
    uint32_t dwRssiEntry0overwrite;                                         /* 03000000(hex) */
} PH_PACK_STRUCT_END phCfg_EE_HW_RfAPC_t, * pphCfg_EE_HW_RfAPC_t;

extern const phCfg_EE_HW_RfAPC_t * const gpkphCfg_EE_HW_RfAPC;

#define PH_CFG_EE_RFINTEROPTIMINGS_START_ADDRESS (0x201404)
/** Structure: RfInterOpTimings
 * Rf Timings for the Inter-op issues
 */
typedef PH_PACK_STRUCT_BEGIN struct phCfg_EE_HW_RfInterOpTimings
{
    /**
     * Value of Time(us) for Peer to turn the Rf On
     */
    uint32_t dwExtRfOnTime;                                                 /* 302(int) */
    /**
     * Value of Time(us) for Peer to turn the Rf off after Transmitting data
     */
    uint32_t dwExtRfOffTime;                                                /* 10(int) */
    /**
     * Value of Time(us) for Internal Rf On in active communication
     */
    uint32_t dwIntRfOnTime;                                                 /* 302(int) */
    /**
     * Value of Time(us) for RRDD for Jewel (((28 + (2 * 9.44)) + Tolerence) = 50).
     */
    uint32_t dwRRDDTime;                                                    /* 50(int) */
    /**
     * Value of Time(us) for Tidt adjust to meet the spec timings of Tadt(Tadt > 768/fc(~57)).
     */
    uint32_t dwTidtTimeAdjust;                                              /* 50(int) */
} PH_PACK_STRUCT_END phCfg_EE_HW_RfInterOpTimings_t, * pphCfg_EE_HW_RfInterOpTimings_t;

extern const phCfg_EE_HW_RfInterOpTimings_t * const gpkphCfg_EE_HW_RfInterOpTimings;

#define PH_CFG_EE_RFHALTIMINGS_START_ADDRESS (0x201418)
/** Structure: RfHalTimings
 * Rf Timings different algo.
 */
typedef PH_PACK_STRUCT_BEGIN struct phCfg_EE_HW_RfHalTimings
{
    /**
     * Time(us) for Clock Error Recovery
     */
    uint32_t dwClkErrRecoveryTime;                                          /* 50(int) */
    /**
     * Time(us) for External Rf off De-Bouncing
     */
    uint32_t dwRfOffDeBouncingTime;                                         /* 20(int) */
    /**
     * Time(us) for Pbf Alm Fw Reset Timer
     */
    uint32_t dwPbfAlmFwResetTime;                                           /* 100(int) */
    /**
     * Time(us) for Felica Stuck Timer in Card mode when SIGPRO RM is used
     */
    uint32_t dwFelicaRxRMSigproTime;                                        /* 2000(int) */
} PH_PACK_STRUCT_END phCfg_EE_HW_RfHalTimings_t, * pphCfg_EE_HW_RfHalTimings_t;

extern const phCfg_EE_HW_RfHalTimings_t * const gpkphCfg_EE_HW_RfHalTimings;

#define PH_CFG_EE_DPLLCFG_START_ADDRESS (0x201428)
/** Structure: DPLLCfg
 * DPLL Configurations
 */
typedef PH_PACK_STRUCT_BEGIN struct phCfg_EE_HW_DPLLCfg
{
    /**
     * Dpll Control
     */
    uint32_t DpllControl;                                                   /* 63(hex) */
    /**
     * Dpll Init
     */
    uint32_t DpllInit;                                                      /* 00171433(hex) */
    /**
     * Dpll Gear
     */
    uint32_t DpllGear;                                                      /* 00042A55(hex) */
    /**
     * Dpll Init Freq
     */
    uint32_t DpllInitFreq;                                                  /* 80008591(hex) */
} PH_PACK_STRUCT_END phCfg_EE_HW_DPLLCfg_t, * pphCfg_EE_HW_DPLLCfg_t;

extern const phCfg_EE_HW_DPLLCfg_t * const gpkphCfg_EE_HW_DPLLCfg;

#define PH_CFG_EE_DPLLCLKPHASEADJUSTMENT_START_ADDRESS (0x201438)
/** Structure: DPLLClkPhaseAdjustment
 * DPLL Clock Phase Adjustment Configuration
 */
typedef PH_PACK_STRUCT_BEGIN struct phCfg_EE_HW_DPLLClkPhaseAdjustment
{
    /**
     * Dpll Init value for card emulation A
     */
    uint32_t DpllInitCeA;                                                   /* 00000000(hex) */
    /**
     * Value of Ana Clk Man for card emulation A
     */
    uint32_t AnaClkManCeA;                                                  /* 00000005(hex) */
    /**
     * Dpll Init value for card emulation B
     */
    uint32_t DpllInitCeB;                                                   /* 00000000(hex) */
    /**
     * Value of Ana Clk Man for card emulation B
     */
    uint32_t AnaClkManCeB;                                                  /* 00000005(hex) */
    /**
     * Dpll Init value for card emulation F
     */
    uint32_t DpllInitCeF;                                                   /* 00000000(hex) */
    /**
     * Value of Ana Clk Man for card emulation F
     */
    uint32_t AnaClkManCeF;                                                  /* 00000005(hex) */
} PH_PACK_STRUCT_END phCfg_EE_HW_DPLLClkPhaseAdjustment_t, * pphCfg_EE_HW_DPLLClkPhaseAdjustment_t;

extern const phCfg_EE_HW_DPLLClkPhaseAdjustment_t * const gpkphCfg_EE_HW_DPLLClkPhaseAdjustment;

#define PH_CFG_EE_RFLDTPARAMS_START_ADDRESS (0x201450)
/** Structure: RfLdtParams
 * \see phhalPcr_RfLdtParams_t
 */
typedef PH_PACK_STRUCT_BEGIN struct phCfg_EE_HW_RfLdtParams
{
    /**
     * Higher Reference Value for RF Level Detector
     */
    uint8_t bRfldRefLo;                                                     /* 02(int) */
    /**
     * Lower Reference Value for RF Level Detector
     */
    uint8_t bRfldRefHi;                                                     /* 03(int) */
    /**
     * Should we used advanced RFLD Feature or normal RFLD Feature
     */
    uint8_t bEnableAdvancedRFLD;                                            /* 0(int) */
    /**
     * Structure padding.
     */
    uint8_t bPadding;                                                       /* 0(int) */
} PH_PACK_STRUCT_END phCfg_EE_HW_RfLdtParams_t, * pphCfg_EE_HW_RfLdtParams_t;

extern const phCfg_EE_HW_RfLdtParams_t * const gpkphCfg_EE_HW_RfLdtParams;

#define PH_CFG_EE_RFTESTBUS_START_ADDRESS (0x201454)
/** Structure: RfTestBus
 * Test Bus configuration of RF
 */
typedef PH_PACK_STRUCT_BEGIN struct phCfg_EE_HW_RfTestBus
{
    /**
     * 0x00: No Analog Test Bus Signal Enabled
     */
    uint32_t dwAnaTB;                                                       /* 00000000(hex) */
    /**
     * 0x00 :  No Analog Test Bus Signal Enabled
     */
    uint32_t dwDAC;                                                         /* 00000000(hex) */
    /**
     * 0x02 : Tx Active
     */
    uint8_t bTbDigi1;                                                       /* 02(hex) */
    /**
     * 0x00 : No Digital Test Bus Signal2 Enabled
     */
    uint8_t bTbDigi2;                                                       /* 00(hex) */
} PH_PACK_STRUCT_END phCfg_EE_HW_RfTestBus_t, * pphCfg_EE_HW_RfTestBus_t;

extern const phCfg_EE_HW_RfTestBus_t * const gpkphCfg_EE_HW_RfTestBus;

#define PH_CFG_EE_CLKGENCLIFCLOCKSTART_START_ADDRESS (0x201460)
/** Structure: ClkGenClifClockStart
 * Configuration for ClkGen to start Clif Clock
 */
typedef PH_PACK_STRUCT_BEGIN struct phCfg_EE_HW_ClkGenClifClockStart
{
    /**
     * Value of Ana Clk field for Passive Reader Mode
     */
    uint8_t ClkModePassiveRm;                                               /* 00(hex) */
    /**
     * Value of Ana Clk field for Active Mode
     */
    uint8_t ClkModeActive;                                                  /* 10(hex) */
    /**
     * Value of Ana Clk field for PLM Card Mode
     */
    uint8_t ClkModePlmCm;                                                   /* 50(hex) */
    /**
     * Value of Ana Clk field for Alm Card Mode
     */
    uint8_t ClkModeAlmCm;                                                   /* 50(hex) */
} PH_PACK_STRUCT_END phCfg_EE_HW_ClkGenClifClockStart_t, * pphCfg_EE_HW_ClkGenClifClockStart_t;

extern const phCfg_EE_HW_ClkGenClifClockStart_t * const gpkphCfg_EE_HW_ClkGenClifClockStart;

#define PH_CFG_EE_I2CM_START_ADDRESS (0x201464)
/** Structure: I2CM
 * Default configuration for I2C Master. These values are primarily used for phExHif.
 */
typedef PH_PACK_STRUCT_BEGIN struct phCfg_EE_HW_I2CM
{
    /**
     * I2C Master transaction data rate in Hz.
     */
    uint32_t dwDataRateHz;                                                  /* 100000(int) */
    /**
     * I2C 7-bit slave address.
     */
    uint8_t bSlaveAddr;                                                     /* 28(hex) */
} PH_PACK_STRUCT_END phCfg_EE_HW_I2CM_t, * pphCfg_EE_HW_I2CM_t;

extern const phCfg_EE_HW_I2CM_t * const gpkphCfg_EE_HW_I2CM;

#define PH_CFG_EE_SPIM_START_ADDRESS (0x20146c)
/** Structure: SPIM
 * SPI Master configurations
 */
typedef PH_PACK_STRUCT_BEGIN struct phCfg_EE_HW_SPIM
{
    /**
     * Specifies the SPIM mode (CPOL, CPHA) of operation, \see phhalSPIM_Modes_t.
     */
    uint8_t bModes;                                                         /* 00(hex) */
    /**
     * Specifies the SPIM transaction data rate. \see phhalSPIM_Configure
     * - 0 => 1.0 MHz
     * - 1 => 1.51 MHz
     * - 2 => 2.09 MHz
     * - 3 => 2.47 MHz
     * - 4 => 3.01 MHz
     * - 5 => 4.52 MHz
     * - 6 => 5.42 MHz
     * - 7 => 6.78 MHz
     */
    uint8_t bDataRate;                                                      /* 00(hex) */
} PH_PACK_STRUCT_END phCfg_EE_HW_SPIM_t, * pphCfg_EE_HW_SPIM_t;

extern const phCfg_EE_HW_SPIM_t * const gpkphCfg_EE_HW_SPIM;

#define PH_CFG_EE_HIF_START_ADDRESS (0x201470)
/** Structure: HIF
 * Host interface configurations. These values are primarily used for phExHif.
 */
typedef PH_PACK_STRUCT_BEGIN struct phCfg_EE_HW_HIF
{
    /**
     * Hif interfaces like I2C, SPI, HSU, USB or disabled.
     * - 0 => Disabled
     * - 1 => I2C
     * - 2 => SPI
     * - 3 => HSU
     * - 4 => USB
     */
    uint8_t bInterface;                                                     /* 1(hex) */
    /**
     * Refer phhalHif_Config_t->sI2cConfig in Hif module.
     */
    uint8_t bI2cConfig;                                                     /* 00(hex) */
    /**
     * Refer phhalHif_Config_t->sSpiConfig in Hif module.
     */
    uint8_t bSpiConfig;                                                     /* 00(hex) */
    /**
     * Set the Hsu Wakeup simulation.
     */
    uint8_t bIsHsuBoot;                                                     /* 00(hex) */
    /**
     * Hsu Eof size - Maximum interbyte duration.
     */
    uint8_t bEndOfFrame;                                                    /* 00(hex) */
    /**
     * Number of Hsu stop bits.
     */
    uint8_t bStopBits;                                                      /* 00(hex) */
    /**
     * Number of Dummy bytes, used during standby phase.
     */
    uint8_t bDummyBytes;                                                    /* 00(hex) */
    /**
     * Refer phhalHif_Hsu_BaudRate_t.
     */
    uint8_t bBaudRate;                                                      /* 00(hex) */
    /**
     * Hif interfaces like I2C, SPI, HSU, USB or disabled.
     * - 0 => E_BUFFER_FORMAT_FREE, transparent (generic HW protocol format).
     * - 1 => E_BUFFER_FORMAT_FIXED, Header + Payload + Crc.
     * - 2 => E_BUFFER_FORMAT_NATIVE, transparent with Size at 1st Word.
     */
    uint8_t bBufferType;                                                    /* 0(hex) */
    /**
     * Number of bytes representing ShortFrame.
     */
    uint8_t bShortFrameLen;                                                 /* 00(hex) */
    /**
     * Store error data or discard error data.
     * - 0 => Disabled
     * - 1 => Enabled
     */
    uint8_t bStoreErrData;                                                  /* 00(hex) */
    /**
     * Header Size in Fixed Format.
     */
    uint8_t bHeaderSize;                                                    /* 00(hex) */
    /**
     * Inter character Tx Timeout in steps of 3.6us.
     */
    uint8_t bTimeout;                                                       /* 00(hex) */
    /**
     * If the user board takes more time than expected to detect discharge during self power mode,
     * user can set this bit to discharge faster. There is a possibility of performance improvement
     * of detecting USB disconnected based on PULLDOWN enabled/disabled.
     */
    uint8_t bEnableVBUSPullDown;                                            /* 00(hex) */
} PH_PACK_STRUCT_END phCfg_EE_HW_HIF_t, * pphCfg_EE_HW_HIF_t;

extern const phCfg_EE_HW_HIF_t * const gpkphCfg_EE_HW_HIF;

/* ****************************************************************************************************************** */
/** \name Page: phRFLP
 *
        Values for RF Load Protocol based on:

<pre>

               Name : 65x65_PLM_MRA3
            Antenna : 65x65 PLM
      Last Modified : 2/1/2016
        Last Author : Maniraj Ashirwad G
     Version Number : Comments
               V1.0 : Initial Version. Changes in this excel sheet and user_ee_65x65.xml &  should be logged further. User_ee.xml should be same as user_ee_65x65.xml while generating the eeprom for 65x65 Antenna.
               V1.1 : DYNAMIC_BPSK_TH_ENABLE - Enabled for Felica Reader Mode Passive Initiator 212 and 424
    CLIF_ANA_CLK_MAN_REG - Register Value added for Felica Passive CM transition (For ALM :  GTM and Felica values are different)
               V1.2 : All the test bus signal are disable except TX_ACTIVE on Digital Test Bus 1 (GPIO4) in user_ee_65x65_5V.xml
               V1.3 : For Type A RM 848   in CLIF_ANA_TX_SHAPE_CONTROL_REG register   TX_SET_TAU_MOD_FALLING   TX_SET_TAU_MOD_RISING are changed for RM A-848 fixing ISO OverShoot Failure
    For Type A RM 848 :  in CLIF_ANA_TX_AMPLITUDE_REG register   TX_GSN_MOD_RM is changed to fix ISO Overshoot Failure.
              V1.4  : Integration with the excel sheet PN5180_RF_ConfigurationSnapshot_20151103
              V1.5  : 1. Bug Fix - SC3871
    2. Bit Fields of "CLIF_SIGPRO_ADCBCM_CONFIG_REG" :  are updated with MRA2 Bit Fields
             V1.5.1 : 1. Bug Fix - Type B update for "CLIF_TX_SYMBOL1_DEF_REG"
             V1.5.2 : Bug Fix - SC3897. TX_CW_AMP_REF2TVDD is set to '0' in the boot settings
               V1.6 : Integration with the PN5180 Eeprom Configuration "PN5180 FW RC4 release - V0.143".
                    : Register Changes:
                    : CLIF_ANA_RX_REG -  A212, A424,A848, B424, B848, 1800 - 18.88 SC424 2M, 1800 - 18.88 SC424 4M, 1800 - 18.88 SC848 2M,1800 - 18.88 SC848 4M, 1800 - 9.44 SC424 2M, 1800 - 9.44 SC424 4M, 1800 - 9.44 SC848 2M, 1800 - 9.44 SC848 4M
                    :
                    : CLIF_SIGPRO_RM_CONFIG1_REG - A212, A424, A848, B212, B424, B848,1800 - 18.88 SC424 2M, 1800 - 18.88 SC424 4M, 1800 - 9.44 SC424 2M, 1800 - 9.44 SC424 4M
               V1.7 : No update - Created by Purnank
             V1.7.1 : TXOCP configuration update for 65x65 <4v. Agc Ref = 220
             V1.7.2 : CLIF_SIGPRO_ADCBCM_CONFIG_REG configuration update based for MRA2 Addition bit fields.
    CLIF_SIGPRO_ADCBCM_CONFIG_REG - GTM : CM - A106   A212   A424   A848   F212   F424   AI 212   AI 424
             V1.7.3 : PCD Shaping configuration update for 65x65
             V1.7.4 : Renaming of TxOCP to DPC (eeprom xml files)
               V1.8 : Separate PCD configuration added for <4v and >4v configuration
             V1.8.1 : CLIF_ANA_NFCLD_REG value is updated - Initiator.
    EDGE_DETECT_TAP_SEL updated for Type A 424 :  848 CM - Target
             V1.8.2 : CLIF_ANA_NFCLD_REG set to 0x0C
             V1.8.3 : CLIF_ANA_NFCLD_REG set to 0x07
               V1.9 : 1. CLIF_TEST_CONTROL_REG added to the Initiator Tab
             V1.9.1 : Change for 30x50mm 5V DPC Config (AGC Hi Threshold) no change for 65x65mm
             V1.9.2 : CLIF_ANA_NFCLD_REG set to 0x1C in boot setting
</pre>

    Generated from clifcsv_to_xml.py version 2016.01.21_00 on 2019-11-13
 */

#define PH_CFG_EE_T_TX_VAL_START_ADDRESS (0x201480)
/** Structure: T_Tx_val
 *
 *             Value to be applied to the corresponding CLIF register for CLIF Target Mode - Transmit.
 *
 */
typedef PH_PACK_STRUCT_BEGIN struct phCfg_EE_phRFLP_T_Tx_val
{
    /**
     * Value for Register CLIF_TRANSCEIVE_CONTROL_REG.
     *
     * Note: Configuration: T_TX_GTM starts from here.
     */
    uint32_t u32_T_TX_GTM_00_TRANSCEIVE_CONTROL_REG;                        /* 7200(hex) */
    /**
     * Value for Register CLIF_ANA_PBF_CONTROL_REG.
     */
    uint32_t u32_T_TX_GTM_01_ANA_PBF_CONTROL_REG;                           /* 2c(hex) */
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     */
    uint32_t u32_T_TX_GTM_02_ANA_TX_AMPLITUDE_REG;                          /* ffff4000(hex) */
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    uint32_t u32_T_TX_GTM_03_ANA_TX_CLK_CONTROL_REG;                        /* 1(hex) */
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    uint32_t u32_T_TX_GTM_04_TX_UNDERSHOOT_CONFIG_REG;                      /* 0(hex) */
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    uint32_t u32_T_TX_GTM_05_TX_OVERSHOOT_CONFIG_REG;                       /* 0(hex) */
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    uint32_t u32_T_TX_GTM_06_ANA_TX_SHAPE_CONTROL_REG;                      /* 0(hex) */
    /**
     * Value for Register CLIF_TX_CONTROL_REG.
     */
    uint32_t u32_T_TX_GTM_07_TX_CONTROL_REG;                                /* 0(hex) */
    /**
     * Value for Register CLIF_ANA_CLK_MAN_REG.
     */
    uint32_t u32_T_TX_GTM_08_ANA_CLK_MAN_REG;                               /* 10(hex) */
    /**
     * Value for Register CLIF_TRANSCEIVE_CONTROL_REG.
     *
     * Note: Configuration: T_TX_A_106_P starts from here.
     */
    uint32_t u32_T_TX_A_106_P_00_TRANSCEIVE_CONTROL_REG;                    /* 7202(hex) */
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    uint32_t u32_T_TX_A_106_P_01_TX_UNDERSHOOT_CONFIG_REG;                  /* 0(hex) */
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    uint32_t u32_T_TX_A_106_P_02_TX_OVERSHOOT_CONFIG_REG;                   /* 0(hex) */
    /**
     * Value for Register CLIF_TRANSCEIVE_CONTROL_REG.
     *
     * Note: Configuration: T_TX_A_212 starts from here.
     */
    uint32_t u32_T_TX_A_212_00_TRANSCEIVE_CONTROL_REG;                      /* 7202(hex) */
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    uint32_t u32_T_TX_A_212_01_TX_UNDERSHOOT_CONFIG_REG;                    /* 0(hex) */
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    uint32_t u32_T_TX_A_212_02_TX_OVERSHOOT_CONFIG_REG;                     /* 0(hex) */
    /**
     * Value for Register CLIF_TRANSCEIVE_CONTROL_REG.
     *
     * Note: Configuration: T_TX_A_424 starts from here.
     */
    uint32_t u32_T_TX_A_424_00_TRANSCEIVE_CONTROL_REG;                      /* 7202(hex) */
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    uint32_t u32_T_TX_A_424_01_TX_UNDERSHOOT_CONFIG_REG;                    /* 0(hex) */
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    uint32_t u32_T_TX_A_424_02_TX_OVERSHOOT_CONFIG_REG;                     /* 0(hex) */
    /**
     * Value for Register CLIF_TRANSCEIVE_CONTROL_REG.
     *
     * Note: Configuration: T_TX_A_848 starts from here.
     */
    uint32_t u32_T_TX_A_848_00_TRANSCEIVE_CONTROL_REG;                      /* 7202(hex) */
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    uint32_t u32_T_TX_A_848_01_TX_UNDERSHOOT_CONFIG_REG;                    /* 0(hex) */
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    uint32_t u32_T_TX_A_848_02_TX_OVERSHOOT_CONFIG_REG;                     /* 0(hex) */
    /**
     * Value for Register CLIF_TRANSCEIVE_CONTROL_REG.
     *
     * Note: Configuration: T_TX_F_P starts from here.
     */
    uint32_t u32_T_TX_F_P_00_TRANSCEIVE_CONTROL_REG;                        /* 0(hex) */
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     */
    uint32_t u32_T_TX_F_P_01_ANA_TX_AMPLITUDE_REG;                          /* ffff4000(hex) */
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    uint32_t u32_T_TX_F_P_02_TX_UNDERSHOOT_CONFIG_REG;                      /* 0(hex) */
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    uint32_t u32_T_TX_F_P_03_TX_OVERSHOOT_CONFIG_REG;                       /* 0(hex) */
    /**
     * Value for Register CLIF_ANA_CLK_MAN_REG.
     */
    uint32_t u32_T_TX_F_P_04_ANA_CLK_MAN_REG;                               /* 10(hex) */
    /**
     * Value for Register CLIF_ANA_PBF_CONTROL_REG.
     *
     * Note: Configuration: T_TX_ACT starts from here.
     */
    uint32_t u32_T_TX_ACT_00_ANA_PBF_CONTROL_REG;                           /* a0(hex) */
    /**
     * Value for Register CLIF_TX_CONTROL_REG.
     */
    uint32_t u32_T_TX_ACT_01_TX_CONTROL_REG;                                /* 0(hex) */
    /**
     * Value for Register CLIF_ANA_CLK_MAN_REG.
     */
    uint32_t u32_T_TX_ACT_02_ANA_CLK_MAN_REG;                               /* 10(hex) */
    /**
     * Value for Register CLIF_TRANSCEIVE_CONTROL_REG.
     *
     * Note: Configuration: T_TX_A_106_ACT starts from here.
     */
    uint32_t u32_T_TX_A_106_ACT_00_TRANSCEIVE_CONTROL_REG;                  /* 35002(hex) */
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     */
    uint32_t u32_T_TX_A_106_ACT_01_ANA_TX_AMPLITUDE_REG;                    /* ffff50f4(hex) */
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    uint32_t u32_T_TX_A_106_ACT_02_ANA_TX_CLK_CONTROL_REG;                  /* 783(hex) */
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    uint32_t u32_T_TX_A_106_ACT_03_TX_UNDERSHOOT_CONFIG_REG;                /* 17(hex) */
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    uint32_t u32_T_TX_A_106_ACT_04_TX_OVERSHOOT_CONFIG_REG;                 /* 0(hex) */
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    uint32_t u32_T_TX_A_106_ACT_05_ANA_TX_SHAPE_CONTROL_REG;                /* 1b000f43(hex) */
    /**
     * Value for Register CLIF_TX_DATA_MOD_REG.
     */
    uint32_t u32_T_TX_A_106_ACT_06_TX_DATA_MOD_REG;                         /* 230104(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL23_MOD_REG.
     */
    uint32_t u32_T_TX_A_106_ACT_07_TX_SYMBOL23_MOD_REG;                     /* 260104(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL01_MOD_REG.
     */
    uint32_t u32_T_TX_A_106_ACT_08_TX_SYMBOL01_MOD_REG;                     /* 230104(hex) */
    /**
     * Value for Register CLIF_TRANSCEIVE_CONTROL_REG.
     *
     * Note: Configuration: T_TX_F_212_ACT starts from here.
     */
    uint32_t u32_T_TX_F_212_ACT_00_TRANSCEIVE_CONTROL_REG;                  /* 30000(hex) */
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     */
    uint32_t u32_T_TX_F_212_ACT_01_ANA_TX_AMPLITUDE_REG;                    /* ffff507c(hex) */
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    uint32_t u32_T_TX_F_212_ACT_02_ANA_TX_CLK_CONTROL_REG;                  /* 8f(hex) */
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    uint32_t u32_T_TX_F_212_ACT_03_TX_UNDERSHOOT_CONFIG_REG;                /* 0(hex) */
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    uint32_t u32_T_TX_F_212_ACT_04_TX_OVERSHOOT_CONFIG_REG;                 /* 0(hex) */
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    uint32_t u32_T_TX_F_212_ACT_05_ANA_TX_SHAPE_CONTROL_REG;                /* 7010744(hex) */
    /**
     * Value for Register CLIF_TX_DATA_MOD_REG.
     */
    uint32_t u32_T_TX_F_212_ACT_06_TX_DATA_MOD_REG;                         /* 15(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL01_MOD_REG.
     */
    uint32_t u32_T_TX_F_212_ACT_07_TX_SYMBOL01_MOD_REG;                     /* 15(hex) */
    /**
     * Value for Register CLIF_TRANSCEIVE_CONTROL_REG.
     *
     * Note: Configuration: T_TX_F_424_ACT starts from here.
     */
    uint32_t u32_T_TX_F_424_ACT_00_TRANSCEIVE_CONTROL_REG;                  /* 30000(hex) */
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     */
    uint32_t u32_T_TX_F_424_ACT_01_ANA_TX_AMPLITUDE_REG;                    /* ffff507c(hex) */
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    uint32_t u32_T_TX_F_424_ACT_02_ANA_TX_CLK_CONTROL_REG;                  /* 8f(hex) */
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    uint32_t u32_T_TX_F_424_ACT_03_TX_UNDERSHOOT_CONFIG_REG;                /* 0(hex) */
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    uint32_t u32_T_TX_F_424_ACT_04_TX_OVERSHOOT_CONFIG_REG;                 /* 0(hex) */
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    uint32_t u32_T_TX_F_424_ACT_05_ANA_TX_SHAPE_CONTROL_REG;                /* 7010f33(hex) */
    /**
     * Value for Register CLIF_TX_DATA_MOD_REG.
     */
    uint32_t u32_T_TX_F_424_ACT_06_TX_DATA_MOD_REG;                         /* 16(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL01_MOD_REG.
     */
    uint32_t u32_T_TX_F_424_ACT_07_TX_SYMBOL01_MOD_REG;                     /* 16(hex) */
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     *
     * Note: Configuration: T_TX_B starts from here.
     */
    uint32_t u32_T_TX_B_00_ANA_TX_AMPLITUDE_REG;                            /* ffff0000(hex) */
} PH_PACK_STRUCT_END phCfg_EE_phRFLP_T_Tx_val_t, * pphCfg_EE_phRFLP_T_Tx_val_t;

extern const phCfg_EE_phRFLP_T_Tx_val_t * const gpkphCfg_EE_phRFLP_T_Tx_val;

#define PH_CFG_EE_T_RX_VAL_START_ADDRESS (0x20155c)
/** Structure: T_Rx_val
 *
 *             Value to be applied to the corresponding CLIF register for CLIF Target Mode - Receive.
 *
 */
typedef PH_PACK_STRUCT_BEGIN struct phCfg_EE_phRFLP_T_Rx_val
{
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: T_RX_GTM starts from here.
     */
    uint32_t u32_T_RX_GTM_00_ANA_RX_REG;                                    /* 390a3(hex) */
    /**
     * Value for Register CLIF_ANA_AGC_REG.
     */
    uint32_t u32_T_RX_GTM_01_ANA_AGC_REG;                                   /* 2(hex) */
    /**
     * Value for Register CLIF_AGC_CONFIG1_REG.
     */
    uint32_t u32_T_RX_GTM_02_AGC_CONFIG1_REG;                               /* 10207ff7(hex) */
    /**
     * Value for Register CLIF_AGC_CONFIG0_REG.
     */
    uint32_t u32_T_RX_GTM_03_AGC_CONFIG0_REG;                               /* 4003(hex) */
    /**
     * Value for Register CLIF_AGC_INPUT_REG.
     */
    uint32_t u32_T_RX_GTM_04_AGC_INPUT_REG;                                 /* 3000150(hex) */
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_THRESHOLD_REG.
     */
    uint32_t u32_T_RX_GTM_05_SIGPRO_ADCBCM_THRESHOLD_REG;                   /* 80060(hex) */
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_CONFIG_REG.
     */
    uint32_t u32_T_RX_GTM_06_SIGPRO_ADCBCM_CONFIG_REG;                      /* f809d0d(hex) */
    /**
     * Value for Register CLIF_ANA_CM_CONFIG_REG.
     */
    uint32_t u32_T_RX_GTM_07_ANA_CM_CONFIG_REG;                             /* 4080(hex) */
    /**
     * Value for Register CLIF_SIGPRO_CM_CONFIG_REG.
     */
    uint32_t u32_T_RX_GTM_08_SIGPRO_CM_CONFIG_REG;                          /* 6b40(hex) */
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     */
    uint32_t u32_T_RX_GTM_09_SIGPRO_RM_CONFIG1_REG;                         /* 10ccc05(hex) */
    /**
     * Value for Register CLIF_BBA_CONTROL_REG.
     */
    uint32_t u32_T_RX_GTM_10_BBA_CONTROL_REG;                               /* 0(hex) */
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     *
     * Note: Configuration: T_RX_A starts from here.
     */
    uint32_t u32_T_RX_A_00_SIGPRO_RM_CONFIG1_REG;                           /* 0(hex) */
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: T_RX_A_106 starts from here.
     */
    uint32_t u32_T_RX_A_106_00_ANA_RX_REG;                                  /* 390a3(hex) */
    /**
     * Value for Register CLIF_AGC_CONFIG1_REG.
     */
    uint32_t u32_T_RX_A_106_01_AGC_CONFIG1_REG;                             /* 10207ff7(hex) */
    /**
     * Value for Register CLIF_AGC_CONFIG0_REG.
     */
    uint32_t u32_T_RX_A_106_02_AGC_CONFIG0_REG;                             /* 44003(hex) */
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_THRESHOLD_REG.
     */
    uint32_t u32_T_RX_A_106_03_SIGPRO_ADCBCM_THRESHOLD_REG;                 /* 4003c(hex) */
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_CONFIG_REG.
     */
    uint32_t u32_T_RX_A_106_04_SIGPRO_ADCBCM_CONFIG_REG;                    /* 180f9ed(hex) */
    /**
     * Value for Register CLIF_ANA_CM_CONFIG_REG.
     */
    uint32_t u32_T_RX_A_106_05_ANA_CM_CONFIG_REG;                           /* 4080(hex) */
    /**
     * Value for Register CLIF_SIGPRO_CM_CONFIG_REG.
     */
    uint32_t u32_T_RX_A_106_06_SIGPRO_CM_CONFIG_REG;                        /* 944(hex) */
    /**
     * Value for Register CLIF_BBA_CONTROL_REG.
     */
    uint32_t u32_T_RX_A_106_07_BBA_CONTROL_REG;                             /* 0(hex) */
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: T_RX_A_212 starts from here.
     */
    uint32_t u32_T_RX_A_212_00_ANA_RX_REG;                                  /* 390a3(hex) */
    /**
     * Value for Register CLIF_AGC_CONFIG1_REG.
     */
    uint32_t u32_T_RX_A_212_01_AGC_CONFIG1_REG;                             /* 10207ff7(hex) */
    /**
     * Value for Register CLIF_AGC_CONFIG0_REG.
     */
    uint32_t u32_T_RX_A_212_02_AGC_CONFIG0_REG;                             /* 44003(hex) */
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_THRESHOLD_REG.
     */
    uint32_t u32_T_RX_A_212_03_SIGPRO_ADCBCM_THRESHOLD_REG;                 /* 3000e0(hex) */
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_CONFIG_REG.
     */
    uint32_t u32_T_RX_A_212_04_SIGPRO_ADCBCM_CONFIG_REG;                    /* 880f9ef(hex) */
    /**
     * Value for Register CLIF_ANA_CM_CONFIG_REG.
     */
    uint32_t u32_T_RX_A_212_05_ANA_CM_CONFIG_REG;                           /* 7080(hex) */
    /**
     * Value for Register CLIF_SIGPRO_CM_CONFIG_REG.
     */
    uint32_t u32_T_RX_A_212_06_SIGPRO_CM_CONFIG_REG;                        /* 944(hex) */
    /**
     * Value for Register CLIF_BBA_CONTROL_REG.
     */
    uint32_t u32_T_RX_A_212_07_BBA_CONTROL_REG;                             /* 0(hex) */
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: T_RX_A_424 starts from here.
     */
    uint32_t u32_T_RX_A_424_00_ANA_RX_REG;                                  /* 390a3(hex) */
    /**
     * Value for Register CLIF_AGC_CONFIG1_REG.
     */
    uint32_t u32_T_RX_A_424_01_AGC_CONFIG1_REG;                             /* 10207ff7(hex) */
    /**
     * Value for Register CLIF_AGC_CONFIG0_REG.
     */
    uint32_t u32_T_RX_A_424_02_AGC_CONFIG0_REG;                             /* 44003(hex) */
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_THRESHOLD_REG.
     */
    uint32_t u32_T_RX_A_424_03_SIGPRO_ADCBCM_THRESHOLD_REG;                 /* 200040(hex) */
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_CONFIG_REG.
     */
    uint32_t u32_T_RX_A_424_04_SIGPRO_ADCBCM_CONFIG_REG;                    /* 8805d0f(hex) */
    /**
     * Value for Register CLIF_ANA_CM_CONFIG_REG.
     */
    uint32_t u32_T_RX_A_424_05_ANA_CM_CONFIG_REG;                           /* 4080(hex) */
    /**
     * Value for Register CLIF_SIGPRO_CM_CONFIG_REG.
     */
    uint32_t u32_T_RX_A_424_06_SIGPRO_CM_CONFIG_REG;                        /* 1144(hex) */
    /**
     * Value for Register CLIF_BBA_CONTROL_REG.
     */
    uint32_t u32_T_RX_A_424_07_BBA_CONTROL_REG;                             /* 0(hex) */
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: T_RX_A_848 starts from here.
     */
    uint32_t u32_T_RX_A_848_00_ANA_RX_REG;                                  /* 390af(hex) */
    /**
     * Value for Register CLIF_AGC_CONFIG1_REG.
     */
    uint32_t u32_T_RX_A_848_01_AGC_CONFIG1_REG;                             /* 10207ff7(hex) */
    /**
     * Value for Register CLIF_AGC_CONFIG0_REG.
     */
    uint32_t u32_T_RX_A_848_02_AGC_CONFIG0_REG;                             /* 44003(hex) */
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_THRESHOLD_REG.
     */
    uint32_t u32_T_RX_A_848_03_SIGPRO_ADCBCM_THRESHOLD_REG;                 /* 180040(hex) */
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_CONFIG_REG.
     */
    uint32_t u32_T_RX_A_848_04_SIGPRO_ADCBCM_CONFIG_REG;                    /* 41101e71(hex) */
    /**
     * Value for Register CLIF_ANA_CM_CONFIG_REG.
     */
    uint32_t u32_T_RX_A_848_05_ANA_CM_CONFIG_REG;                           /* 4080(hex) */
    /**
     * Value for Register CLIF_SIGPRO_CM_CONFIG_REG.
     */
    uint32_t u32_T_RX_A_848_06_SIGPRO_CM_CONFIG_REG;                        /* 1144(hex) */
    /**
     * Value for Register CLIF_BBA_CONTROL_REG.
     */
    uint32_t u32_T_RX_A_848_07_BBA_CONTROL_REG;                             /* 0(hex) */
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: T_RX_F starts from here.
     */
    uint32_t u32_T_RX_F_00_ANA_RX_REG;                                      /* 390a3(hex) */
    /**
     * Value for Register CLIF_AGC_CONFIG1_REG.
     */
    uint32_t u32_T_RX_F_01_AGC_CONFIG1_REG;                                 /* 207ff6(hex) */
    /**
     * Value for Register CLIF_AGC_CONFIG0_REG.
     */
    uint32_t u32_T_RX_F_02_AGC_CONFIG0_REG;                                 /* 4400b(hex) */
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_THRESHOLD_REG.
     */
    uint32_t u32_T_RX_F_03_SIGPRO_ADCBCM_THRESHOLD_REG;                     /* 80060(hex) */
    /**
     * Value for Register CLIF_BBA_CONTROL_REG.
     */
    uint32_t u32_T_RX_F_04_BBA_CONTROL_REG;                                 /* 0(hex) */
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_CONFIG_REG.
     *
     * Note: Configuration: T_RX_F_212 starts from here.
     */
    uint32_t u32_T_RX_F_212_00_SIGPRO_ADCBCM_CONFIG_REG;                    /* f80ad05(hex) */
    /**
     * Value for Register CLIF_SIGPRO_CM_CONFIG_REG.
     */
    uint32_t u32_T_RX_F_212_01_SIGPRO_CM_CONFIG_REG;                        /* 6206(hex) */
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_CONFIG_REG.
     *
     * Note: Configuration: T_RX_F_424 starts from here.
     */
    uint32_t u32_T_RX_F_424_00_SIGPRO_ADCBCM_CONFIG_REG;                    /* f80ad09(hex) */
    /**
     * Value for Register CLIF_SIGPRO_CM_CONFIG_REG.
     */
    uint32_t u32_T_RX_F_424_01_SIGPRO_CM_CONFIG_REG;                        /* 6206(hex) */
    /**
     * Value for Register CLIF_AGC_CONFIG1_REG.
     *
     * Note: Configuration: T_RX_ACT starts from here.
     */
    uint32_t u32_T_RX_ACT_00_AGC_CONFIG1_REG;                               /* 207ff6(hex) */
    /**
     * Value for Register CLIF_AGC_CONFIG0_REG.
     */
    uint32_t u32_T_RX_ACT_01_AGC_CONFIG0_REG;                               /* 4400b(hex) */
    /**
     * Value for Register CLIF_SIGPRO_CM_CONFIG_REG.
     *
     * Note: Configuration: T_RX_A_106_ACT starts from here.
     */
    uint32_t u32_T_RX_A_106_ACT_00_SIGPRO_CM_CONFIG_REG;                    /* 104(hex) */
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_THRESHOLD_REG.
     *
     * Note: Configuration: T_RX_F_212_ACT starts from here.
     */
    uint32_t u32_T_RX_F_212_ACT_00_SIGPRO_ADCBCM_THRESHOLD_REG;             /* 80060(hex) */
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_CONFIG_REG.
     */
    uint32_t u32_T_RX_F_212_ACT_01_SIGPRO_ADCBCM_CONFIG_REG;                /* f801c85(hex) */
    /**
     * Value for Register CLIF_SIGPRO_CM_CONFIG_REG.
     */
    uint32_t u32_T_RX_F_212_ACT_02_SIGPRO_CM_CONFIG_REG;                    /* 6206(hex) */
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_THRESHOLD_REG.
     *
     * Note: Configuration: T_RX_F_424_ACT starts from here.
     */
    uint32_t u32_T_RX_F_424_ACT_00_SIGPRO_ADCBCM_THRESHOLD_REG;             /* 80060(hex) */
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_CONFIG_REG.
     */
    uint32_t u32_T_RX_F_424_ACT_01_SIGPRO_ADCBCM_CONFIG_REG;                /* f801c89(hex) */
    /**
     * Value for Register CLIF_SIGPRO_CM_CONFIG_REG.
     */
    uint32_t u32_T_RX_F_424_ACT_02_SIGPRO_CM_CONFIG_REG;                    /* 6206(hex) */
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: T_RX_B starts from here.
     */
    uint32_t u32_T_RX_B_00_ANA_RX_REG;                                      /* 390a3(hex) */
    /**
     * Value for Register CLIF_BBA_CONTROL_REG.
     */
    uint32_t u32_T_RX_B_01_BBA_CONTROL_REG;                                 /* 341(hex) */
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_THRESHOLD_REG.
     *
     * Note: Configuration: T_RX_B_106 starts from here.
     */
    uint32_t u32_T_RX_B_106_00_SIGPRO_ADCBCM_THRESHOLD_REG;                 /* 6400c8(hex) */
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_CONFIG_REG.
     */
    uint32_t u32_T_RX_B_106_01_SIGPRO_ADCBCM_CONFIG_REG;                    /* 1780adef(hex) */
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_THRESHOLD_REG.
     *
     * Note: Configuration: T_RX_B_212 starts from here.
     */
    uint32_t u32_T_RX_B_212_00_SIGPRO_ADCBCM_THRESHOLD_REG;                 /* 6400c8(hex) */
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_CONFIG_REG.
     */
    uint32_t u32_T_RX_B_212_01_SIGPRO_ADCBCM_CONFIG_REG;                    /* 17805def(hex) */
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_THRESHOLD_REG.
     *
     * Note: Configuration: T_RX_B_424 starts from here.
     */
    uint32_t u32_T_RX_B_424_00_SIGPRO_ADCBCM_THRESHOLD_REG;                 /* 6400c8(hex) */
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_CONFIG_REG.
     */
    uint32_t u32_T_RX_B_424_01_SIGPRO_ADCBCM_CONFIG_REG;                    /* 17805def(hex) */
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_THRESHOLD_REG.
     *
     * Note: Configuration: T_RX_B_848 starts from here.
     */
    uint32_t u32_T_RX_B_848_00_SIGPRO_ADCBCM_THRESHOLD_REG;                 /* 6400a8(hex) */
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_CONFIG_REG.
     */
    uint32_t u32_T_RX_B_848_01_SIGPRO_ADCBCM_CONFIG_REG;                    /* 17805c71(hex) */
} PH_PACK_STRUCT_END phCfg_EE_phRFLP_T_Rx_val_t, * pphCfg_EE_phRFLP_T_Rx_val_t;

extern const phCfg_EE_phRFLP_T_Rx_val_t * const gpkphCfg_EE_phRFLP_T_Rx_val;

#define PH_CFG_EE_I_TX_VAL_START_ADDRESS (0x20167c)
/** Structure: I_Tx_val
 *
 *             Value to be applied to the corresponding CLIF register for CLIF Initiator Mode - Transmit.
 *
 */
typedef PH_PACK_STRUCT_BEGIN struct phCfg_EE_phRFLP_I_Tx_val
{
    /**
     * Value for Register CLIF_ANA_PBF_CONTROL_REG.
     *
     * Note: Configuration: I_TX starts from here.
     */
    uint32_t u32_I_TX_00_ANA_PBF_CONTROL_REG;                               /* a0(hex) */
    /**
     * Value for Register CLIF_TRANSCEIVE_CONTROL_REG.
     *
     * Note: Configuration: I_TX_A starts from here.
     */
    uint32_t u32_I_TX_A_00_TRANSCEIVE_CONTROL_REG;                          /* 5041(hex) */
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     *
     * Note: Configuration: I_TX_A_106 starts from here.
     */
    uint32_t u32_I_TX_A_106_00_ANA_TX_AMPLITUDE_REG;                        /* ffff50f4(hex) */
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    uint32_t u32_I_TX_A_106_01_ANA_TX_CLK_CONTROL_REG;                      /* 783(hex) */
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    uint32_t u32_I_TX_A_106_02_TX_UNDERSHOOT_CONFIG_REG;                    /* 17(hex) */
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    uint32_t u32_I_TX_A_106_03_TX_OVERSHOOT_CONFIG_REG;                     /* 0(hex) */
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    uint32_t u32_I_TX_A_106_04_ANA_TX_SHAPE_CONTROL_REG;                    /* 1b000f43(hex) */
    /**
     * Value for Register CLIF_TX_DATA_MOD_REG.
     */
    uint32_t u32_I_TX_A_106_05_TX_DATA_MOD_REG;                             /* 230104(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL23_MOD_REG.
     */
    uint32_t u32_I_TX_A_106_06_TX_SYMBOL23_MOD_REG;                         /* 230104(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL_CONFIG_REG.
     */
    uint32_t u32_I_TX_A_106_07_TX_SYMBOL_CONFIG_REG;                        /* 0(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL01_MOD_REG.
     */
    uint32_t u32_I_TX_A_106_08_TX_SYMBOL01_MOD_REG;                         /* 230104(hex) */
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     *
     * Note: Configuration: I_TX_A_212 starts from here.
     */
    uint32_t u32_I_TX_A_212_00_ANA_TX_AMPLITUDE_REG;                        /* ffff50f4(hex) */
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    uint32_t u32_I_TX_A_212_01_ANA_TX_CLK_CONTROL_REG;                      /* 83(hex) */
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    uint32_t u32_I_TX_A_212_02_TX_UNDERSHOOT_CONFIG_REG;                    /* 5(hex) */
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    uint32_t u32_I_TX_A_212_03_TX_OVERSHOOT_CONFIG_REG;                     /* 0(hex) */
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    uint32_t u32_I_TX_A_212_04_ANA_TX_SHAPE_CONTROL_REG;                    /* 1b000f43(hex) */
    /**
     * Value for Register CLIF_TX_DATA_MOD_REG.
     */
    uint32_t u32_I_TX_A_212_05_TX_DATA_MOD_REG;                             /* f0105(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL23_MOD_REG.
     */
    uint32_t u32_I_TX_A_212_06_TX_SYMBOL23_MOD_REG;                         /* f0105(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL_CONFIG_REG.
     */
    uint32_t u32_I_TX_A_212_07_TX_SYMBOL_CONFIG_REG;                        /* 0(hex) */
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     *
     * Note: Configuration: I_TX_A_424 starts from here.
     */
    uint32_t u32_I_TX_A_424_00_ANA_TX_AMPLITUDE_REG;                        /* ffff50f4(hex) */
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    uint32_t u32_I_TX_A_424_01_ANA_TX_CLK_CONTROL_REG;                      /* 83(hex) */
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    uint32_t u32_I_TX_A_424_02_TX_UNDERSHOOT_CONFIG_REG;                    /* 5(hex) */
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    uint32_t u32_I_TX_A_424_03_TX_OVERSHOOT_CONFIG_REG;                     /* 0(hex) */
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    uint32_t u32_I_TX_A_424_04_ANA_TX_SHAPE_CONTROL_REG;                    /* 1b000f43(hex) */
    /**
     * Value for Register CLIF_TX_DATA_MOD_REG.
     */
    uint32_t u32_I_TX_A_424_05_TX_DATA_MOD_REG;                             /* 60106(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL23_MOD_REG.
     */
    uint32_t u32_I_TX_A_424_06_TX_SYMBOL23_MOD_REG;                         /* 60106(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL_CONFIG_REG.
     */
    uint32_t u32_I_TX_A_424_07_TX_SYMBOL_CONFIG_REG;                        /* 0(hex) */
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     *
     * Note: Configuration: I_TX_A_848 starts from here.
     */
    uint32_t u32_I_TX_A_848_00_ANA_TX_AMPLITUDE_REG;                        /* ffff507c(hex) */
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    uint32_t u32_I_TX_A_848_01_ANA_TX_CLK_CONTROL_REG;                      /* 83(hex) */
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    uint32_t u32_I_TX_A_848_02_TX_UNDERSHOOT_CONFIG_REG;                    /* 1(hex) */
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    uint32_t u32_I_TX_A_848_03_TX_OVERSHOOT_CONFIG_REG;                     /* 0(hex) */
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    uint32_t u32_I_TX_A_848_04_ANA_TX_SHAPE_CONTROL_REG;                    /* 1f000f45(hex) */
    /**
     * Value for Register CLIF_TX_DATA_MOD_REG.
     */
    uint32_t u32_I_TX_A_848_05_TX_DATA_MOD_REG;                             /* 10107(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL23_MOD_REG.
     */
    uint32_t u32_I_TX_A_848_06_TX_SYMBOL23_MOD_REG;                         /* 20107(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL_CONFIG_REG.
     */
    uint32_t u32_I_TX_A_848_07_TX_SYMBOL_CONFIG_REG;                        /* 0(hex) */
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     *
     * Note: Configuration: I_TX_B_106 starts from here.
     */
    uint32_t u32_I_TX_B_106_00_ANA_TX_AMPLITUDE_REG;                        /* ffff5094(hex) */
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    uint32_t u32_I_TX_B_106_01_ANA_TX_CLK_CONTROL_REG;                      /* 8f(hex) */
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    uint32_t u32_I_TX_B_106_02_TX_UNDERSHOOT_CONFIG_REG;                    /* 0(hex) */
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    uint32_t u32_I_TX_B_106_03_TX_OVERSHOOT_CONFIG_REG;                     /* 0(hex) */
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    uint32_t u32_I_TX_B_106_04_ANA_TX_SHAPE_CONTROL_REG;                    /* 7000756(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL_CONFIG_REG.
     */
    uint32_t u32_I_TX_B_106_05_TX_SYMBOL_CONFIG_REG;                        /* 402b9(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL01_MOD_REG.
     */
    uint32_t u32_I_TX_B_106_06_TX_SYMBOL01_MOD_REG;                         /* 85(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL0_DEF_REG.
     */
    uint32_t u32_I_TX_B_106_07_TX_SYMBOL0_DEF_REG;                          /* 1f(hex) */
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     *
     * Note: Configuration: I_TX_B_212 starts from here.
     */
    uint32_t u32_I_TX_B_212_00_ANA_TX_AMPLITUDE_REG;                        /* ffff5074(hex) */
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    uint32_t u32_I_TX_B_212_01_ANA_TX_CLK_CONTROL_REG;                      /* 8f(hex) */
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    uint32_t u32_I_TX_B_212_02_TX_UNDERSHOOT_CONFIG_REG;                    /* 0(hex) */
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    uint32_t u32_I_TX_B_212_03_TX_OVERSHOOT_CONFIG_REG;                     /* 0(hex) */
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    uint32_t u32_I_TX_B_212_04_ANA_TX_SHAPE_CONTROL_REG;                    /* 7000746(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL_CONFIG_REG.
     */
    uint32_t u32_I_TX_B_212_05_TX_SYMBOL_CONFIG_REG;                        /* 4014c(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL01_MOD_REG.
     */
    uint32_t u32_I_TX_B_212_06_TX_SYMBOL01_MOD_REG;                         /* 85(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL0_DEF_REG.
     */
    uint32_t u32_I_TX_B_212_07_TX_SYMBOL0_DEF_REG;                          /* 3(hex) */
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     *
     * Note: Configuration: I_TX_B_424 starts from here.
     */
    uint32_t u32_I_TX_B_424_00_ANA_TX_AMPLITUDE_REG;                        /* ffff5074(hex) */
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    uint32_t u32_I_TX_B_424_01_ANA_TX_CLK_CONTROL_REG;                      /* 78f(hex) */
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    uint32_t u32_I_TX_B_424_02_TX_UNDERSHOOT_CONFIG_REG;                    /* 0(hex) */
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    uint32_t u32_I_TX_B_424_03_TX_OVERSHOOT_CONFIG_REG;                     /* 1fe0013(hex) */
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    uint32_t u32_I_TX_B_424_04_ANA_TX_SHAPE_CONTROL_REG;                    /* e000f54(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL_CONFIG_REG.
     */
    uint32_t u32_I_TX_B_424_05_TX_SYMBOL_CONFIG_REG;                        /* 4014c(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL01_MOD_REG.
     */
    uint32_t u32_I_TX_B_424_06_TX_SYMBOL01_MOD_REG;                         /* 86(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL0_DEF_REG.
     */
    uint32_t u32_I_TX_B_424_07_TX_SYMBOL0_DEF_REG;                          /* 3(hex) */
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     *
     * Note: Configuration: I_TX_B_848 starts from here.
     */
    uint32_t u32_I_TX_B_848_00_ANA_TX_AMPLITUDE_REG;                        /* ffff506c(hex) */
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    uint32_t u32_I_TX_B_848_01_ANA_TX_CLK_CONTROL_REG;                      /* 78f(hex) */
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    uint32_t u32_I_TX_B_848_02_TX_UNDERSHOOT_CONFIG_REG;                    /* 0(hex) */
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    uint32_t u32_I_TX_B_848_03_TX_OVERSHOOT_CONFIG_REG;                     /* 7e000d(hex) */
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    uint32_t u32_I_TX_B_848_04_ANA_TX_SHAPE_CONTROL_REG;                    /* d000f32(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL_CONFIG_REG.
     */
    uint32_t u32_I_TX_B_848_05_TX_SYMBOL_CONFIG_REG;                        /* 4014c(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL01_MOD_REG.
     */
    uint32_t u32_I_TX_B_848_06_TX_SYMBOL01_MOD_REG;                         /* 87(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL0_DEF_REG.
     */
    uint32_t u32_I_TX_B_848_07_TX_SYMBOL0_DEF_REG;                          /* 3(hex) */
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     *
     * Note: Configuration: I_TX_F starts from here.
     */
    uint32_t u32_I_TX_F_00_ANA_TX_CLK_CONTROL_REG;                          /* 8f(hex) */
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     *
     * Note: Configuration: I_TX_F_212 starts from here.
     */
    uint32_t u32_I_TX_F_212_00_ANA_TX_AMPLITUDE_REG;                        /* ffff507c(hex) */
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    uint32_t u32_I_TX_F_212_01_TX_UNDERSHOOT_CONFIG_REG;                    /* 0(hex) */
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    uint32_t u32_I_TX_F_212_02_TX_OVERSHOOT_CONFIG_REG;                     /* 0(hex) */
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    uint32_t u32_I_TX_F_212_03_ANA_TX_SHAPE_CONTROL_REG;                    /* 7010744(hex) */
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     *
     * Note: Configuration: I_TX_F_424 starts from here.
     */
    uint32_t u32_I_TX_F_424_00_ANA_TX_AMPLITUDE_REG;                        /* ffff507c(hex) */
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    uint32_t u32_I_TX_F_424_01_TX_UNDERSHOOT_CONFIG_REG;                    /* 0(hex) */
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    uint32_t u32_I_TX_F_424_02_TX_OVERSHOOT_CONFIG_REG;                     /* 0(hex) */
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    uint32_t u32_I_TX_F_424_03_ANA_TX_SHAPE_CONTROL_REG;                    /* 7010f33(hex) */
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     *
     * Note: Configuration: I_TX_15693_100 starts from here.
     */
    uint32_t u32_I_TX_15693_100_00_ANA_TX_AMPLITUDE_REG;                    /* ffff50f4(hex) */
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    uint32_t u32_I_TX_15693_100_01_ANA_TX_CLK_CONTROL_REG;                  /* 783(hex) */
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    uint32_t u32_I_TX_15693_100_02_TX_UNDERSHOOT_CONFIG_REG;                /* f000001f(hex) */
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    uint32_t u32_I_TX_15693_100_03_TX_OVERSHOOT_CONFIG_REG;                 /* 0(hex) */
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    uint32_t u32_I_TX_15693_100_04_ANA_TX_SHAPE_CONTROL_REG;                /* 1b000745(hex) */
    /**
     * Value for Register CLIF_TX_DATA_MOD_REG.
     */
    uint32_t u32_I_TX_15693_100_05_TX_DATA_MOD_REG;                         /* 43(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL23_MOD_REG.
     */
    uint32_t u32_I_TX_15693_100_06_TX_SYMBOL23_MOD_REG;                     /* 4(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL_CONFIG_REG.
     */
    uint32_t u32_I_TX_15693_100_07_TX_SYMBOL_CONFIG_REG;                    /* 7c00(hex) */
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     *
     * Note: Configuration: I_TX_15693_10 starts from here.
     */
    uint32_t u32_I_TX_15693_10_00_ANA_TX_AMPLITUDE_REG;                     /* ffff5090(hex) */
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    uint32_t u32_I_TX_15693_10_01_ANA_TX_CLK_CONTROL_REG;                   /* 8f(hex) */
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    uint32_t u32_I_TX_15693_10_02_TX_UNDERSHOOT_CONFIG_REG;                 /* ff000f(hex) */
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    uint32_t u32_I_TX_15693_10_03_TX_OVERSHOOT_CONFIG_REG;                  /* 0(hex) */
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    uint32_t u32_I_TX_15693_10_04_ANA_TX_SHAPE_CONTROL_REG;                 /* 7010f44(hex) */
    /**
     * Value for Register CLIF_TX_DATA_MOD_REG.
     */
    uint32_t u32_I_TX_15693_10_05_TX_DATA_MOD_REG;                          /* 43(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL23_MOD_REG.
     */
    uint32_t u32_I_TX_15693_10_06_TX_SYMBOL23_MOD_REG;                      /* 4(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL_CONFIG_REG.
     */
    uint32_t u32_I_TX_15693_10_07_TX_SYMBOL_CONFIG_REG;                     /* 7c00(hex) */
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     *
     * Note: Configuration: I_TX_EPCV2_TARI_9_44 starts from here.
     */
    uint32_t u32_I_TX_EPCV2_TARI_9_44_00_ANA_TX_AMPLITUDE_REG;              /* fffff094(hex) */
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    uint32_t u32_I_TX_EPCV2_TARI_9_44_01_ANA_TX_CLK_CONTROL_REG;            /* 8f(hex) */
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    uint32_t u32_I_TX_EPCV2_TARI_9_44_02_TX_UNDERSHOOT_CONFIG_REG;          /* ff000f(hex) */
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    uint32_t u32_I_TX_EPCV2_TARI_9_44_03_TX_OVERSHOOT_CONFIG_REG;           /* 0(hex) */
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    uint32_t u32_I_TX_EPCV2_TARI_9_44_04_ANA_TX_SHAPE_CONTROL_REG;          /* 7000734(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL_CONFIG_REG.
     */
    uint32_t u32_I_TX_EPCV2_TARI_9_44_05_TX_SYMBOL_CONFIG_REG;              /* ed(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL0_DEF_REG.
     */
    uint32_t u32_I_TX_EPCV2_TARI_9_44_06_TX_SYMBOL0_DEF_REG;                /* 2841(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL1_DEF_REG.
     */
    uint32_t u32_I_TX_EPCV2_TARI_9_44_07_TX_SYMBOL1_DEF_REG;                /* a1(hex) */
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     *
     * Note: Configuration: I_TX_EPCV2_TARI_18_88 starts from here.
     */
    uint32_t u32_I_TX_EPCV2_TARI_18_88_00_ANA_TX_AMPLITUDE_REG;             /* fffff08c(hex) */
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    uint32_t u32_I_TX_EPCV2_TARI_18_88_01_ANA_TX_CLK_CONTROL_REG;           /* 8f(hex) */
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    uint32_t u32_I_TX_EPCV2_TARI_18_88_02_TX_UNDERSHOOT_CONFIG_REG;         /* ff000f(hex) */
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    uint32_t u32_I_TX_EPCV2_TARI_18_88_03_TX_OVERSHOOT_CONFIG_REG;          /* 0(hex) */
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    uint32_t u32_I_TX_EPCV2_TARI_18_88_04_ANA_TX_SHAPE_CONTROL_REG;         /* 7000734(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL_CONFIG_REG.
     */
    uint32_t u32_I_TX_EPCV2_TARI_18_88_05_TX_SYMBOL_CONFIG_REG;             /* ed(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL0_DEF_REG.
     */
    uint32_t u32_I_TX_EPCV2_TARI_18_88_06_TX_SYMBOL0_DEF_REG;               /* 2841(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL1_DEF_REG.
     */
    uint32_t u32_I_TX_EPCV2_TARI_18_88_07_TX_SYMBOL1_DEF_REG;               /* a1(hex) */
    /**
     * Value for Register CLIF_ANA_PBF_CONTROL_REG.
     *
     * Note: Configuration: I_TX_ACT starts from here.
     */
    uint32_t u32_I_TX_ACT_00_ANA_PBF_CONTROL_REG;                           /* a0(hex) */
    /**
     * Value for Register CLIF_TRANSCEIVE_CONTROL_REG.
     *
     * Note: Configuration: I_TX_ACT_106 starts from here.
     */
    uint32_t u32_I_TX_ACT_106_00_TRANSCEIVE_CONTROL_REG;                    /* 35003(hex) */
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     */
    uint32_t u32_I_TX_ACT_106_01_ANA_TX_AMPLITUDE_REG;                      /* ffff50f4(hex) */
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    uint32_t u32_I_TX_ACT_106_02_ANA_TX_CLK_CONTROL_REG;                    /* 783(hex) */
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    uint32_t u32_I_TX_ACT_106_03_TX_UNDERSHOOT_CONFIG_REG;                  /* 17(hex) */
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    uint32_t u32_I_TX_ACT_106_04_TX_OVERSHOOT_CONFIG_REG;                   /* 0(hex) */
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    uint32_t u32_I_TX_ACT_106_05_ANA_TX_SHAPE_CONTROL_REG;                  /* 1b000f43(hex) */
    /**
     * Value for Register CLIF_TX_DATA_MOD_REG.
     */
    uint32_t u32_I_TX_ACT_106_06_TX_DATA_MOD_REG;                           /* 230104(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL23_MOD_REG.
     */
    uint32_t u32_I_TX_ACT_106_07_TX_SYMBOL23_MOD_REG;                       /* 260104(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL_CONFIG_REG.
     */
    uint32_t u32_I_TX_ACT_106_08_TX_SYMBOL_CONFIG_REG;                      /* 9(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL01_MOD_REG.
     */
    uint32_t u32_I_TX_ACT_106_09_TX_SYMBOL01_MOD_REG;                       /* 230104(hex) */
    /**
     * Value for Register CLIF_TRANSCEIVE_CONTROL_REG.
     *
     * Note: Configuration: I_TX_ACT_212 starts from here.
     */
    uint32_t u32_I_TX_ACT_212_00_TRANSCEIVE_CONTROL_REG;                    /* 30001(hex) */
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     */
    uint32_t u32_I_TX_ACT_212_01_ANA_TX_AMPLITUDE_REG;                      /* ffff507c(hex) */
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    uint32_t u32_I_TX_ACT_212_02_ANA_TX_CLK_CONTROL_REG;                    /* 8f(hex) */
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    uint32_t u32_I_TX_ACT_212_03_TX_UNDERSHOOT_CONFIG_REG;                  /* 0(hex) */
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    uint32_t u32_I_TX_ACT_212_04_TX_OVERSHOOT_CONFIG_REG;                   /* 0(hex) */
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    uint32_t u32_I_TX_ACT_212_05_ANA_TX_SHAPE_CONTROL_REG;                  /* 7010f44(hex) */
    /**
     * Value for Register CLIF_TX_DATA_MOD_REG.
     */
    uint32_t u32_I_TX_ACT_212_06_TX_DATA_MOD_REG;                           /* 15(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL_CONFIG_REG.
     */
    uint32_t u32_I_TX_ACT_212_07_TX_SYMBOL_CONFIG_REG;                      /* 31000f(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL01_MOD_REG.
     */
    uint32_t u32_I_TX_ACT_212_08_TX_SYMBOL01_MOD_REG;                       /* 15(hex) */
    /**
     * Value for Register CLIF_TRANSCEIVE_CONTROL_REG.
     *
     * Note: Configuration: I_TX_ACT_424 starts from here.
     */
    uint32_t u32_I_TX_ACT_424_00_TRANSCEIVE_CONTROL_REG;                    /* 30001(hex) */
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     */
    uint32_t u32_I_TX_ACT_424_01_ANA_TX_AMPLITUDE_REG;                      /* ffff507c(hex) */
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    uint32_t u32_I_TX_ACT_424_02_ANA_TX_CLK_CONTROL_REG;                    /* 8f(hex) */
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    uint32_t u32_I_TX_ACT_424_03_TX_UNDERSHOOT_CONFIG_REG;                  /* 0(hex) */
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    uint32_t u32_I_TX_ACT_424_04_TX_OVERSHOOT_CONFIG_REG;                   /* 0(hex) */
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    uint32_t u32_I_TX_ACT_424_05_ANA_TX_SHAPE_CONTROL_REG;                  /* 7010f33(hex) */
    /**
     * Value for Register CLIF_TX_DATA_MOD_REG.
     */
    uint32_t u32_I_TX_ACT_424_06_TX_DATA_MOD_REG;                           /* 16(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL_CONFIG_REG.
     */
    uint32_t u32_I_TX_ACT_424_07_TX_SYMBOL_CONFIG_REG;                      /* 31000f(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL01_MOD_REG.
     */
    uint32_t u32_I_TX_ACT_424_08_TX_SYMBOL01_MOD_REG;                       /* 16(hex) */
    /**
     * Value for Register CLIF_TRANSCEIVE_CONTROL_REG.
     *
     * Note: Configuration: I_TX_BOOT starts from here.
     */
    uint32_t u32_I_TX_BOOT_00_TRANSCEIVE_CONTROL_REG;                       /* 0(hex) */
    /**
     * Value for Register CLIF_ANA_PBF_CONTROL_REG.
     */
    uint32_t u32_I_TX_BOOT_01_ANA_PBF_CONTROL_REG;                          /* a0(hex) */
    /**
     * Value for Register CLIF_ANA_TX_AMPLITUDE_REG.
     */
    uint32_t u32_I_TX_BOOT_02_ANA_TX_AMPLITUDE_REG;                         /* ffff0003(hex) */
    /**
     * Value for Register CLIF_ANA_TX_CLK_CONTROL_REG.
     */
    uint32_t u32_I_TX_BOOT_03_ANA_TX_CLK_CONTROL_REG;                       /* 83(hex) */
    /**
     * Value for Register CLIF_TX_UNDERSHOOT_CONFIG_REG.
     */
    uint32_t u32_I_TX_BOOT_04_TX_UNDERSHOOT_CONFIG_REG;                     /* 0(hex) */
    /**
     * Value for Register CLIF_TX_OVERSHOOT_CONFIG_REG.
     */
    uint32_t u32_I_TX_BOOT_05_TX_OVERSHOOT_CONFIG_REG;                      /* 0(hex) */
    /**
     * Value for Register CLIF_ANA_TX_SHAPE_CONTROL_REG.
     */
    uint32_t u32_I_TX_BOOT_06_ANA_TX_SHAPE_CONTROL_REG;                     /* 0(hex) */
    /**
     * Value for Register CLIF_TX_DATA_MOD_REG.
     */
    uint32_t u32_I_TX_BOOT_07_TX_DATA_MOD_REG;                              /* 0(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL23_MOD_REG.
     */
    uint32_t u32_I_TX_BOOT_08_TX_SYMBOL23_MOD_REG;                          /* 0(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL_CONFIG_REG.
     */
    uint32_t u32_I_TX_BOOT_09_TX_SYMBOL_CONFIG_REG;                         /* 0(hex) */
    /**
     * Value for Register CLIF_ANA_CLK_MAN_REG.
     */
    uint32_t u32_I_TX_BOOT_10_ANA_CLK_MAN_REG;                              /* 0(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL01_MOD_REG.
     */
    uint32_t u32_I_TX_BOOT_11_TX_SYMBOL01_MOD_REG;                          /* 0(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL0_DEF_REG.
     */
    uint32_t u32_I_TX_BOOT_12_TX_SYMBOL0_DEF_REG;                           /* 0(hex) */
    /**
     * Value for Register CLIF_TX_SYMBOL1_DEF_REG.
     */
    uint32_t u32_I_TX_BOOT_13_TX_SYMBOL1_DEF_REG;                           /* 0(hex) */
    /**
     * Value for Register CLIF_TEST_CONTROL_REG.
     */
    uint32_t u32_I_TX_BOOT_14_TEST_CONTROL_REG;                             /* 280000(hex) */
} PH_PACK_STRUCT_END phCfg_EE_phRFLP_I_Tx_val_t, * pphCfg_EE_phRFLP_I_Tx_val_t;

extern const phCfg_EE_phRFLP_I_Tx_val_t * const gpkphCfg_EE_phRFLP_I_Tx_val;

#define PH_CFG_EE_I_RX_VAL_START_ADDRESS (0x2018dc)
/** Structure: I_Rx_val
 *
 *             Value to be applied to the corresponding CLIF register for CLIF Initiator Mode - Receive.
 *
 */
typedef PH_PACK_STRUCT_BEGIN struct phCfg_EE_phRFLP_I_Rx_val
{
    /**
     * Value for Register CLIF_ANA_AGC_REG.
     *
     * Note: Configuration: I_RX_PASS starts from here.
     */
    uint32_t u32_I_RX_PASS_00_ANA_AGC_REG;                                  /* 2(hex) */
    /**
     * Value for Register CLIF_AGC_INPUT_REG.
     */
    uint32_t u32_I_RX_PASS_01_AGC_INPUT_REG;                                /* 20001f0(hex) */
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_A_106_P starts from here.
     */
    uint32_t u32_I_RX_A_106_P_00_ANA_RX_REG;                                /* 2002f(hex) */
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     */
    uint32_t u32_I_RX_A_106_P_01_SIGPRO_RM_CONFIG1_REG;                     /* 440dc(hex) */
    /**
     * Value for Register CLIF_AGC_CONFIG1_REG.
     */
    uint32_t u32_I_RX_A_106_P_02_AGC_CONFIG1_REG;                           /* 3e40104(hex) */
    /**
     * Value for Register CLIF_AGC_CONFIG0_REG.
     */
    uint32_t u32_I_RX_A_106_P_03_AGC_CONFIG0_REG;                           /* 7001008b(hex) */
    /**
     * Value for Register CLIF_RX_CONFIG_REG.
     */
    uint32_t u32_I_RX_A_106_P_04_RX_CONFIG_REG;                             /* 3(hex) */
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_A_212 starts from here.
     */
    uint32_t u32_I_RX_A_212_00_ANA_RX_REG;                                  /* 20026(hex) */
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     */
    uint32_t u32_I_RX_A_212_01_SIGPRO_RM_CONFIG1_REG;                       /* 1192605(hex) */
    /**
     * Value for Register CLIF_AGC_CONFIG1_REG.
     */
    uint32_t u32_I_RX_A_212_02_AGC_CONFIG1_REG;                             /* 3e10a04(hex) */
    /**
     * Value for Register CLIF_AGC_CONFIG0_REG.
     */
    uint32_t u32_I_RX_A_212_03_AGC_CONFIG0_REG;                             /* 40c0b(hex) */
    /**
     * Value for Register CLIF_RX_CONFIG_REG.
     */
    uint32_t u32_I_RX_A_212_04_RX_CONFIG_REG;                               /* 23(hex) */
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_A_424 starts from here.
     */
    uint32_t u32_I_RX_A_424_00_ANA_RX_REG;                                  /* 20026(hex) */
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     */
    uint32_t u32_I_RX_A_424_01_SIGPRO_RM_CONFIG1_REG;                       /* 1192905(hex) */
    /**
     * Value for Register CLIF_AGC_CONFIG1_REG.
     */
    uint32_t u32_I_RX_A_424_02_AGC_CONFIG1_REG;                             /* 3e10a04(hex) */
    /**
     * Value for Register CLIF_AGC_CONFIG0_REG.
     */
    uint32_t u32_I_RX_A_424_03_AGC_CONFIG0_REG;                             /* 40c0b(hex) */
    /**
     * Value for Register CLIF_RX_CONFIG_REG.
     */
    uint32_t u32_I_RX_A_424_04_RX_CONFIG_REG;                               /* 23(hex) */
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_A_848 starts from here.
     */
    uint32_t u32_I_RX_A_848_00_ANA_RX_REG;                                  /* 20021(hex) */
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     */
    uint32_t u32_I_RX_A_848_01_SIGPRO_RM_CONFIG1_REG;                       /* 10f2505(hex) */
    /**
     * Value for Register CLIF_AGC_CONFIG1_REG.
     */
    uint32_t u32_I_RX_A_848_02_AGC_CONFIG1_REG;                             /* 3e10a04(hex) */
    /**
     * Value for Register CLIF_AGC_CONFIG0_REG.
     */
    uint32_t u32_I_RX_A_848_03_AGC_CONFIG0_REG;                             /* 40c0b(hex) */
    /**
     * Value for Register CLIF_RX_CONFIG_REG.
     */
    uint32_t u32_I_RX_A_848_04_RX_CONFIG_REG;                               /* 23(hex) */
    /**
     * Value for Register CLIF_AGC_CONFIG1_REG.
     *
     * Note: Configuration: I_RX_B starts from here.
     */
    uint32_t u32_I_RX_B_00_AGC_CONFIG1_REG;                                 /* 3e10a04(hex) */
    /**
     * Value for Register CLIF_AGC_CONFIG0_REG.
     */
    uint32_t u32_I_RX_B_01_AGC_CONFIG0_REG;                                 /* 40c0b(hex) */
    /**
     * Value for Register CLIF_RX_CONFIG_REG.
     */
    uint32_t u32_I_RX_B_02_RX_CONFIG_REG;                                   /* 54(hex) */
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_B_106 starts from here.
     */
    uint32_t u32_I_RX_B_106_00_ANA_RX_REG;                                  /* 2002b(hex) */
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     */
    uint32_t u32_I_RX_B_106_01_SIGPRO_RM_CONFIG1_REG;                       /* 11f4615(hex) */
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_B_212 starts from here.
     */
    uint32_t u32_I_RX_B_212_00_ANA_RX_REG;                                  /* 20026(hex) */
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     */
    uint32_t u32_I_RX_B_212_01_SIGPRO_RM_CONFIG1_REG;                       /* 1192805(hex) */
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_B_424 starts from here.
     */
    uint32_t u32_I_RX_B_424_00_ANA_RX_REG;                                  /* 20026(hex) */
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     */
    uint32_t u32_I_RX_B_424_01_SIGPRO_RM_CONFIG1_REG;                       /* 1192a05(hex) */
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_B_848 starts from here.
     */
    uint32_t u32_I_RX_B_848_00_ANA_RX_REG;                                  /* 2002a(hex) */
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     */
    uint32_t u32_I_RX_B_848_01_SIGPRO_RM_CONFIG1_REG;                       /* 10f2505(hex) */
    /**
     * Value for Register CLIF_AGC_CONFIG1_REG.
     *
     * Note: Configuration: I_RX_F_P starts from here.
     */
    uint32_t u32_I_RX_F_P_00_AGC_CONFIG1_REG;                               /* 3e10a04(hex) */
    /**
     * Value for Register CLIF_AGC_CONFIG0_REG.
     */
    uint32_t u32_I_RX_F_P_01_AGC_CONFIG0_REG;                               /* 40c0b(hex) */
    /**
     * Value for Register CLIF_RX_CONFIG_REG.
     */
    uint32_t u32_I_RX_F_P_02_RX_CONFIG_REG;                                 /* 38(hex) */
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_F_212_P starts from here.
     */
    uint32_t u32_I_RX_F_212_P_00_ANA_RX_REG;                                /* 20021(hex) */
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     */
    uint32_t u32_I_RX_F_212_P_01_SIGPRO_RM_CONFIG1_REG;                     /* 10f2605(hex) */
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_F_424_P starts from here.
     */
    uint32_t u32_I_RX_F_424_P_00_ANA_RX_REG;                                /* 20025(hex) */
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     */
    uint32_t u32_I_RX_F_424_P_01_SIGPRO_RM_CONFIG1_REG;                     /* 10f2605(hex) */
    /**
     * Value for Register CLIF_AGC_CONFIG1_REG.
     *
     * Note: Configuration: I_RX_15693 starts from here.
     */
    uint32_t u32_I_RX_15693_00_AGC_CONFIG1_REG;                             /* 3e40104(hex) */
    /**
     * Value for Register CLIF_AGC_CONFIG0_REG.
     */
    uint32_t u32_I_RX_15693_01_AGC_CONFIG0_REG;                             /* 7000008b(hex) */
    /**
     * Value for Register CLIF_RX_CONFIG_REG.
     */
    uint32_t u32_I_RX_15693_02_RX_CONFIG_REG;                               /* 1d10(hex) */
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_15693_26 starts from here.
     */
    uint32_t u32_I_RX_15693_26_00_ANA_RX_REG;                               /* 2002a(hex) */
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     */
    uint32_t u32_I_RX_15693_26_01_SIGPRO_RM_CONFIG1_REG;                    /* c4010(hex) */
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_15693_53 starts from here.
     */
    uint32_t u32_I_RX_15693_53_00_ANA_RX_REG;                               /* 2002a(hex) */
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     */
    uint32_t u32_I_RX_15693_53_01_SIGPRO_RM_CONFIG1_REG;                    /* c4010(hex) */
    /**
     * Value for Register CLIF_AGC_CONFIG1_REG.
     *
     * Note: Configuration: I_RX_EPCV2 starts from here.
     */
    uint32_t u32_I_RX_EPCV2_00_AGC_CONFIG1_REG;                             /* 3e40a04(hex) */
    /**
     * Value for Register CLIF_AGC_CONFIG0_REG.
     */
    uint32_t u32_I_RX_EPCV2_01_AGC_CONFIG0_REG;                             /* c0b(hex) */
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_EPCV2_SC424_2MP starts from here.
     */
    uint32_t u32_I_RX_EPCV2_SC424_2MP_00_ANA_RX_REG;                        /* 2002e(hex) */
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     */
    uint32_t u32_I_RX_EPCV2_SC424_2MP_01_SIGPRO_RM_CONFIG1_REG;             /* c6014(hex) */
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_EPCV2_SC424_4MP starts from here.
     */
    uint32_t u32_I_RX_EPCV2_SC424_4MP_00_ANA_RX_REG;                        /* 2002a(hex) */
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     */
    uint32_t u32_I_RX_EPCV2_SC424_4MP_01_SIGPRO_RM_CONFIG1_REG;             /* c8014(hex) */
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_EPCV2_SC848_2MP starts from here.
     */
    uint32_t u32_I_RX_EPCV2_SC848_2MP_00_ANA_RX_REG;                        /* 2002f(hex) */
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     */
    uint32_t u32_I_RX_EPCV2_SC848_2MP_01_SIGPRO_RM_CONFIG1_REG;             /* c8094(hex) */
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_EPCV2_SC848_4MP starts from here.
     */
    uint32_t u32_I_RX_EPCV2_SC848_4MP_00_ANA_RX_REG;                        /* 20022(hex) */
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     */
    uint32_t u32_I_RX_EPCV2_SC848_4MP_01_SIGPRO_RM_CONFIG1_REG;             /* c7094(hex) */
    /**
     * Value for Register CLIF_ANA_AGC_REG.
     *
     * Note: Configuration: I_RX_ACT starts from here.
     */
    uint32_t u32_I_RX_ACT_00_ANA_AGC_REG;                                   /* 2(hex) */
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     */
    uint32_t u32_I_RX_ACT_01_SIGPRO_RM_CONFIG1_REG;                         /* 10ccc05(hex) */
    /**
     * Value for Register CLIF_AGC_INPUT_REG.
     */
    uint32_t u32_I_RX_ACT_02_AGC_INPUT_REG;                                 /* 3000150(hex) */
    /**
     * Value for Register CLIF_ANA_CM_CONFIG_REG.
     */
    uint32_t u32_I_RX_ACT_03_ANA_CM_CONFIG_REG;                             /* 14080(hex) */
    /**
     * Value for Register CLIF_BBA_CONTROL_REG.
     */
    uint32_t u32_I_RX_ACT_04_BBA_CONTROL_REG;                               /* 0(hex) */
    /**
     * Value for Register CLIF_ANA_CLK_MAN_REG.
     */
    uint32_t u32_I_RX_ACT_05_ANA_CLK_MAN_REG;                               /* 10(hex) */
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_ACT_106 starts from here.
     */
    uint32_t u32_I_RX_ACT_106_00_ANA_RX_REG;                                /* 390a3(hex) */
    /**
     * Value for Register CLIF_AGC_CONFIG1_REG.
     */
    uint32_t u32_I_RX_ACT_106_01_AGC_CONFIG1_REG;                           /* 207ff6(hex) */
    /**
     * Value for Register CLIF_AGC_CONFIG0_REG.
     */
    uint32_t u32_I_RX_ACT_106_02_AGC_CONFIG0_REG;                           /* 4400b(hex) */
    /**
     * Value for Register CLIF_SIGPRO_CM_CONFIG_REG.
     */
    uint32_t u32_I_RX_ACT_106_03_SIGPRO_CM_CONFIG_REG;                      /* 104(hex) */
    /**
     * Value for Register CLIF_RX_CONFIG_REG.
     */
    uint32_t u32_I_RX_ACT_106_04_RX_CONFIG_REG;                             /* 113(hex) */
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_ACT_212 starts from here.
     */
    uint32_t u32_I_RX_ACT_212_00_ANA_RX_REG;                                /* 390a3(hex) */
    /**
     * Value for Register CLIF_AGC_CONFIG1_REG.
     */
    uint32_t u32_I_RX_ACT_212_01_AGC_CONFIG1_REG;                           /* 207ff6(hex) */
    /**
     * Value for Register CLIF_AGC_CONFIG0_REG.
     */
    uint32_t u32_I_RX_ACT_212_02_AGC_CONFIG0_REG;                           /* 4400b(hex) */
    /**
     * Value for Register CLIF_SIGPRO_CM_CONFIG_REG.
     */
    uint32_t u32_I_RX_ACT_212_03_SIGPRO_CM_CONFIG_REG;                      /* 6206(hex) */
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_THRESHOLD_REG.
     */
    uint32_t u32_I_RX_ACT_212_04_SIGPRO_ADCBCM_THRESHOLD_REG;               /* 80060(hex) */
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_CONFIG_REG.
     */
    uint32_t u32_I_RX_ACT_212_05_SIGPRO_ADCBCM_CONFIG_REG;                  /* f805d05(hex) */
    /**
     * Value for Register CLIF_RX_CONFIG_REG.
     */
    uint32_t u32_I_RX_ACT_212_06_RX_CONFIG_REG;                             /* 38(hex) */
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_ACT_424 starts from here.
     */
    uint32_t u32_I_RX_ACT_424_00_ANA_RX_REG;                                /* 390a3(hex) */
    /**
     * Value for Register CLIF_AGC_CONFIG1_REG.
     */
    uint32_t u32_I_RX_ACT_424_01_AGC_CONFIG1_REG;                           /* 207ff6(hex) */
    /**
     * Value for Register CLIF_AGC_CONFIG0_REG.
     */
    uint32_t u32_I_RX_ACT_424_02_AGC_CONFIG0_REG;                           /* 4400b(hex) */
    /**
     * Value for Register CLIF_SIGPRO_CM_CONFIG_REG.
     */
    uint32_t u32_I_RX_ACT_424_03_SIGPRO_CM_CONFIG_REG;                      /* 6206(hex) */
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_THRESHOLD_REG.
     */
    uint32_t u32_I_RX_ACT_424_04_SIGPRO_ADCBCM_THRESHOLD_REG;               /* 80060(hex) */
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_CONFIG_REG.
     */
    uint32_t u32_I_RX_ACT_424_05_SIGPRO_ADCBCM_CONFIG_REG;                  /* f805d09(hex) */
    /**
     * Value for Register CLIF_RX_CONFIG_REG.
     */
    uint32_t u32_I_RX_ACT_424_06_RX_CONFIG_REG;                             /* 38(hex) */
    /**
     * Value for Register CLIF_ANA_RX_REG.
     *
     * Note: Configuration: I_RX_BOOT starts from here.
     */
    uint32_t u32_I_RX_BOOT_00_ANA_RX_REG;                                   /* 3db20(hex) */
    /**
     * Value for Register CLIF_ANA_AGC_REG.
     */
    uint32_t u32_I_RX_BOOT_01_ANA_AGC_REG;                                  /* 2(hex) */
    /**
     * Value for Register CLIF_SIGPRO_RM_CONFIG1_REG.
     */
    uint32_t u32_I_RX_BOOT_02_SIGPRO_RM_CONFIG1_REG;                        /* c0000(hex) */
    /**
     * Value for Register CLIF_AGC_CONFIG1_REG.
     */
    uint32_t u32_I_RX_BOOT_03_AGC_CONFIG1_REG;                              /* 10107ff7(hex) */
    /**
     * Value for Register CLIF_AGC_CONFIG0_REG.
     */
    uint32_t u32_I_RX_BOOT_04_AGC_CONFIG0_REG;                              /* 4007(hex) */
    /**
     * Value for Register CLIF_AGC_INPUT_REG.
     */
    uint32_t u32_I_RX_BOOT_05_AGC_INPUT_REG;                                /* 3000150(hex) */
    /**
     * Value for Register CLIF_ANA_CM_CONFIG_REG.
     */
    uint32_t u32_I_RX_BOOT_06_ANA_CM_CONFIG_REG;                            /* c080(hex) */
    /**
     * Value for Register CLIF_ANA_TEST_REG.
     */
    uint32_t u32_I_RX_BOOT_07_ANA_TEST_REG;                                 /* 50004a(hex) */
    /**
     * Value for Register CLIF_ANA_NFCLD_REG.
     */
    uint32_t u32_I_RX_BOOT_08_ANA_NFCLD_REG;                                /* 1c(hex) */
    /**
     * Value for Register CLIF_SIGPRO_CM_CONFIG_REG.
     */
    uint32_t u32_I_RX_BOOT_09_SIGPRO_CM_CONFIG_REG;                         /* 4(hex) */
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_THRESHOLD_REG.
     */
    uint32_t u32_I_RX_BOOT_10_SIGPRO_ADCBCM_THRESHOLD_REG;                  /* 0(hex) */
    /**
     * Value for Register CLIF_SIGPRO_ADCBCM_CONFIG_REG.
     */
    uint32_t u32_I_RX_BOOT_11_SIGPRO_ADCBCM_CONFIG_REG;                     /* 1000000(hex) */
    /**
     * Value for Register CLIF_RX_CONFIG_REG.
     */
    uint32_t u32_I_RX_BOOT_12_RX_CONFIG_REG;                                /* 2(hex) */
    /**
     * Value for Register CLIF_BBA_CONTROL_REG.
     */
    uint32_t u32_I_RX_BOOT_13_BBA_CONTROL_REG;                              /* 0(hex) */
} PH_PACK_STRUCT_END phCfg_EE_phRFLP_I_Rx_val_t, * pphCfg_EE_phRFLP_I_Rx_val_t;

extern const phCfg_EE_phRFLP_I_Rx_val_t * const gpkphCfg_EE_phRFLP_I_Rx_val;

/* ****************************************************************************************************************** */
/** \name Page: Trailer
 *
                Trailer region of the EEPROM.  This region does not contain any function data/values.
                Test cases can write scratch data beyond this region.
 */

#define PH_CFG_EE_LAST_START_ADDRESS (0x201a80)
/** Structure: Last
 *
 *                     Last structure on EEPROM. Starting from this address/region,
 *                     there is nothing relevent for the example/reference implementation.
 *
 */
typedef PH_PACK_STRUCT_BEGIN struct phCfg_EE_Trailer_Last
{
    /**
     * Dummy Byte for the Structure
     */
    uint32_t dummyByte;                                                     /* 32363437(hex) */
} PH_PACK_STRUCT_END phCfg_EE_Trailer_Last_t, * pphCfg_EE_Trailer_Last_t;

extern const phCfg_EE_Trailer_Last_t * const gpkphCfg_EE_Trailer_Last;
/* PRQA S 0639 -- */
#endif /* PHCFG_EE_H */
