/*
 *                    Copyright (c), NXP Semiconductors
 *
 *                       (C) NXP Semiconductors 2014,2015
 *
 *         All rights are reserved. Reproduction in whole or in part is
 *        prohibited without the written consent of the copyright owner.
 *    NXP reserves the right to make changes without notice at any time.
 *   NXP makes no warranty, expressed, implied or statutory, including but
 *   not limited to any implied warranty of merchantability or fitness for any
 *  particular purpose, or that the use will not infringe any third party patent,
 *   copyright or trademark. NXP must not be liable for any loss or damage
 *                            arising from its use.
 */

/** @file
 *
 * Run Time configuration settings extracted from EEPROM/FLASH.
 *
 * Project:  PN7462AU
 *
 * $Date: 2016-07-04 23:48:03 +0530 (Mon, 04 Jul 2016) $
 * $Author: Purnank G (ing05193) $
 * $Revision: 18541 $ (v04.18.00)
 */

#include <ph_Datatypes.h>
#include "ph_NxpBuild.h"

#ifdef NXPBUILD__CFG_ENABLE_EE_DOWNLOAD

#if PHFL_CONFIG_TARGET_PLATFORM == PH_CONFIG_TARGET_PLATFORM_IAR
    #pragma location = ".eeprom"
#endif
#if PHFL_CONFIG_TARGET_PLATFORM == PH_CONFIG_TARGET_PLATFORM_ARMGCC
#   error Not available with GCC.
#endif
#if PHFL_CONFIG_TARGET_PLATFORM == PH_CONFIG_TARGET_PLATFORM_DS5
    __attribute__((at(0x00201200)))
#endif

const uint8_t phCfg_EE_Build_Values[3584]  = {

/* 0x201200 */ 0x49, 0x6e, 0x74, 0x65,   0x6e, 0x74, 0x69, 0x6f,     0x6e, 0x61, 0x6c, 0x6c,   0x79, 0x45, 0x6d, 0x70,
/* 0x201210 */ 0x74, 0x79, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,     0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,
/* 0x201220 */ 0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,     0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,
/* 0x201230 */ 0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,     0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,
/* 0x201240 */ 0x1c, 0x00, 0x00, 0x00,   0x52, 0x66, 0x23, 0x76,     0x31, 0x2e, 0x39, 0x00,   0x00, 0x00, 0x00, 0x00,
/* 0x201250 */ 0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,     0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,
/* 0x201260 */ 0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,     0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,
/* 0x201270 */ 0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,     0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,
/* 0x201280 */ 0x26, 0x00, 0x00, 0x00,   0xd0, 0x07, 0x00, 0x00,     0x00, 0x00, 0x03, 0x03,   0x00, 0x00, 0x00, 0x00,
/* 0x201290 */ 0xFF, 0xFF, 0xFF, 0x7F,   0x0F, 0x00, 0x00, 0x00,     0x03, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,
/* 0x2012a0 */ 0x00, 0x01, 0x00, 0x00,   0x00, 0x04, 0x00, 0x00,     0x60, 0xc4, 0x00, 0x00,   0x01, 0x01, 0x01, 0x38,
/* 0x2012b0 */ 0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x03, 0x03,     0x07, 0x03, 0x03, 0x03,   0x00, 0x00, 0x00, 0x00,
/* 0x2012c0 */ 0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,     0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,
/* 0x2012d0 */ 0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,     0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,
/* 0x2012e0 */ 0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,     0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,
/* 0x2012f0 */ 0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,     0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,
/* 0x201300 */ 0x2c, 0x01, 0x00, 0x28,   0x01, 0x00, 0x01, 0x01,     0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,
/* 0x201310 */ 0xF7, 0x7F, 0x10, 0x00,   0x03, 0x40, 0x04, 0x00,     0xAC, 0x20, 0x00, 0x00,   0x05, 0x00, 0x00, 0x00,
/* 0x201320 */ 0x28, 0x00, 0x00, 0x00,   0x00, 0x00, 0x0C, 0x09,     0x20, 0x4E, 0x40, 0x25,   0x44, 0x01, 0xB8, 0x88,
/* 0x201330 */ 0xA8, 0x61, 0x90, 0x01,   0x4A, 0x01, 0x4B, 0x01,     0x4A, 0x01, 0x48, 0x01,   0x46, 0x01, 0x43, 0x01,
/* 0x201340 */ 0x3D, 0x01, 0x2E, 0x01,   0x70, 0x01, 0xAD, 0x00,     0xA7, 0x00, 0x9E, 0x00,   0x96, 0x00, 0x87, 0x00,
/* 0x201350 */ 0x4A, 0x00, 0x73, 0x00,   0x00, 0x05, 0x09, 0xF9,     0xF1, 0xF3, 0xF5, 0xF7,   0xF0, 0xF2, 0xF4, 0xF6,
/* 0x201360 */ 0x96, 0x66, 0x46, 0x36,   0x26, 0x16, 0x00, 0x00,     0x91, 0x99, 0x07, 0x08,   0x91, 0x99, 0x08, 0x00,
/* 0x201370 */ 0x91, 0x99, 0xA0, 0x17,   0x91, 0xF9, 0x40, 0x00,     0x92, 0xB9, 0x10, 0x00,   0xA2, 0x9B, 0x20, 0x00,
/* 0x201380 */ 0xA2, 0xE9, 0x40, 0x00,   0x92, 0x9A, 0x08, 0x00,     0x92, 0xF9, 0x80, 0x00,   0x93, 0x90, 0x47, 0x08,
/* 0x201390 */ 0xA7, 0x99, 0x07, 0x08,   0x97, 0x99, 0x08, 0x00,     0x97, 0x99, 0x30, 0x17,   0x81, 0x46, 0x01, 0x00,
/* 0x2013a0 */ 0x85, 0x4A, 0x10, 0x00,   0x00, 0x00, 0x00, 0x00,     0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,
/* 0x2013b0 */ 0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,     0x2D, 0x00, 0x00, 0x00,   0x23, 0x04, 0x10, 0x00,
/* 0x2013c0 */ 0x00, 0x00, 0x00, 0x84,   0xC0, 0x06, 0x98, 0x00,     0x80, 0x11, 0xC4, 0x00,   0x00, 0x1E, 0xD8, 0x00,
/* 0x2013d0 */ 0x80, 0x25, 0xDA, 0x00,   0x80, 0x2F, 0x20, 0x01,     0x00, 0x37, 0x24, 0x00,   0x80, 0x3E, 0xAA, 0x00,
/* 0x2013e0 */ 0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,     0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,
/* 0x2013f0 */ 0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,     0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,
/* 0x201400 */ 0x00, 0x00, 0x00, 0x03,   0x2e, 0x01, 0x00, 0x00,     0x0a, 0x00, 0x00, 0x00,   0x2e, 0x01, 0x00, 0x00,
/* 0x201410 */ 0x32, 0x00, 0x00, 0x00,   0x32, 0x00, 0x00, 0x00,     0x32, 0x00, 0x00, 0x00,   0x14, 0x00, 0x00, 0x00,
/* 0x201420 */ 0x64, 0x00, 0x00, 0x00,   0xd0, 0x07, 0x00, 0x00,     0x63, 0x00, 0x00, 0x00,   0x33, 0x14, 0x17, 0x00,
/* 0x201430 */ 0x55, 0x2A, 0x04, 0x00,   0x91, 0x85, 0x00, 0x80,     0x00, 0x00, 0x00, 0x00,   0x05, 0x00, 0x00, 0x00,
/* 0x201440 */ 0x00, 0x00, 0x00, 0x00,   0x05, 0x00, 0x00, 0x00,     0x00, 0x00, 0x00, 0x00,   0x05, 0x00, 0x00, 0x00,
/* 0x201450 */ 0x02, 0x03, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,     0x00, 0x00, 0x00, 0x00,   0x02, 0x00, 0x00, 0x00,
/* 0x201460 */ 0x00, 0x10, 0x50, 0x50,   0xa0, 0x86, 0x01, 0x00,     0x28, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,
/* 0x201470 */ 0x01, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,     0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,
/* 0x201480 */ 0x00, 0x72, 0x00, 0x00,   0x2c, 0x00, 0x00, 0x00,     0x00, 0x40, 0xff, 0xff,   0x01, 0x00, 0x00, 0x00,
/* 0x201490 */ 0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,     0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,
/* 0x2014a0 */ 0x10, 0x00, 0x00, 0x00,   0x02, 0x72, 0x00, 0x00,     0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,
/* 0x2014b0 */ 0x02, 0x72, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,     0x00, 0x00, 0x00, 0x00,   0x02, 0x72, 0x00, 0x00,
/* 0x2014c0 */ 0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,     0x02, 0x72, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,
/* 0x2014d0 */ 0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,     0x00, 0x40, 0xff, 0xff,   0x00, 0x00, 0x00, 0x00,
/* 0x2014e0 */ 0x00, 0x00, 0x00, 0x00,   0x10, 0x00, 0x00, 0x00,     0xa0, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,
/* 0x2014f0 */ 0x10, 0x00, 0x00, 0x00,   0x02, 0x50, 0x03, 0x00,     0xf4, 0x50, 0xff, 0xff,   0x83, 0x07, 0x00, 0x00,
/* 0x201500 */ 0x17, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,     0x43, 0x0f, 0x00, 0x1b,   0x04, 0x01, 0x23, 0x00,
/* 0x201510 */ 0x04, 0x01, 0x26, 0x00,   0x04, 0x01, 0x23, 0x00,     0x00, 0x00, 0x03, 0x00,   0x7c, 0x50, 0xff, 0xff,
/* 0x201520 */ 0x8f, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,     0x00, 0x00, 0x00, 0x00,   0x44, 0x07, 0x01, 0x07,
/* 0x201530 */ 0x15, 0x00, 0x00, 0x00,   0x15, 0x00, 0x00, 0x00,     0x00, 0x00, 0x03, 0x00,   0x7c, 0x50, 0xff, 0xff,
/* 0x201540 */ 0x8f, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,     0x00, 0x00, 0x00, 0x00,   0x33, 0x0f, 0x01, 0x07,
/* 0x201550 */ 0x16, 0x00, 0x00, 0x00,   0x16, 0x00, 0x00, 0x00,     0x00, 0x00, 0xff, 0xff,   0xa3, 0x90, 0x03, 0x00,
/* 0x201560 */ 0x02, 0x00, 0x00, 0x00,   0xf7, 0x7f, 0x20, 0x10,     0x03, 0x40, 0x00, 0x00,   0x50, 0x01, 0x00, 0x03,
/* 0x201570 */ 0x60, 0x00, 0x08, 0x00,   0x0d, 0x9d, 0x80, 0x0f,     0x80, 0x40, 0x00, 0x00,   0x40, 0x6b, 0x00, 0x00,
/* 0x201580 */ 0x05, 0xcc, 0x0c, 0x01,   0x00, 0x00, 0x00, 0x00,     0x00, 0x00, 0x00, 0x00,   0xa3, 0x90, 0x03, 0x00,
/* 0x201590 */ 0xf7, 0x7f, 0x20, 0x10,   0x03, 0x40, 0x04, 0x00,     0x3c, 0x00, 0x04, 0x00,   0xed, 0xf9, 0x80, 0x01,
/* 0x2015a0 */ 0x80, 0x40, 0x00, 0x00,   0x44, 0x09, 0x00, 0x00,     0x00, 0x00, 0x00, 0x00,   0xa3, 0x90, 0x03, 0x00,
/* 0x2015b0 */ 0xf7, 0x7f, 0x20, 0x10,   0x03, 0x40, 0x04, 0x00,     0xe0, 0x00, 0x30, 0x00,   0xef, 0xf9, 0x80, 0x08,
/* 0x2015c0 */ 0x80, 0x70, 0x00, 0x00,   0x44, 0x09, 0x00, 0x00,     0x00, 0x00, 0x00, 0x00,   0xa3, 0x90, 0x03, 0x00,
/* 0x2015d0 */ 0xf7, 0x7f, 0x20, 0x10,   0x03, 0x40, 0x04, 0x00,     0x40, 0x00, 0x20, 0x00,   0x0f, 0x5d, 0x80, 0x08,
/* 0x2015e0 */ 0x80, 0x40, 0x00, 0x00,   0x44, 0x11, 0x00, 0x00,     0x00, 0x00, 0x00, 0x00,   0xaf, 0x90, 0x03, 0x00,
/* 0x2015f0 */ 0xf7, 0x7f, 0x20, 0x10,   0x03, 0x40, 0x04, 0x00,     0x40, 0x00, 0x18, 0x00,   0x71, 0x1e, 0x10, 0x41,
/* 0x201600 */ 0x80, 0x40, 0x00, 0x00,   0x44, 0x11, 0x00, 0x00,     0x00, 0x00, 0x00, 0x00,   0xa3, 0x90, 0x03, 0x00,
/* 0x201610 */ 0xf6, 0x7f, 0x20, 0x00,   0x0b, 0x40, 0x04, 0x00,     0x60, 0x00, 0x08, 0x00,   0x00, 0x00, 0x00, 0x00,
/* 0x201620 */ 0x05, 0xad, 0x80, 0x0f,   0x06, 0x62, 0x00, 0x00,     0x09, 0xad, 0x80, 0x0f,   0x06, 0x62, 0x00, 0x00,
/* 0x201630 */ 0xf6, 0x7f, 0x20, 0x00,   0x0b, 0x40, 0x04, 0x00,     0x04, 0x01, 0x00, 0x00,   0x60, 0x00, 0x08, 0x00,
/* 0x201640 */ 0x85, 0x1c, 0x80, 0x0f,   0x06, 0x62, 0x00, 0x00,     0x60, 0x00, 0x08, 0x00,   0x89, 0x1c, 0x80, 0x0f,
/* 0x201650 */ 0x06, 0x62, 0x00, 0x00,   0xa3, 0x90, 0x03, 0x00,     0x41, 0x03, 0x00, 0x00,   0xc8, 0x00, 0x64, 0x00,
/* 0x201660 */ 0xef, 0xad, 0x80, 0x17,   0xc8, 0x00, 0x64, 0x00,     0xef, 0x5d, 0x80, 0x17,   0xc8, 0x00, 0x64, 0x00,
/* 0x201670 */ 0xef, 0x5d, 0x80, 0x17,   0xa8, 0x00, 0x64, 0x00,     0x71, 0x5c, 0x80, 0x17,   0xa0, 0x00, 0x00, 0x00,
/* 0x201680 */ 0x41, 0x50, 0x00, 0x00,   0xf4, 0x50, 0xff, 0xff,     0x83, 0x07, 0x00, 0x00,   0x17, 0x00, 0x00, 0x00,
/* 0x201690 */ 0x00, 0x00, 0x00, 0x00,   0x43, 0x0f, 0x00, 0x1b,     0x04, 0x01, 0x23, 0x00,   0x04, 0x01, 0x23, 0x00,
/* 0x2016a0 */ 0x00, 0x00, 0x00, 0x00,   0x04, 0x01, 0x23, 0x00,     0xf4, 0x50, 0xff, 0xff,   0x83, 0x00, 0x00, 0x00,
/* 0x2016b0 */ 0x05, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,     0x43, 0x0f, 0x00, 0x1b,   0x05, 0x01, 0x0f, 0x00,
/* 0x2016c0 */ 0x05, 0x01, 0x0f, 0x00,   0x00, 0x00, 0x00, 0x00,     0xf4, 0x50, 0xff, 0xff,   0x83, 0x00, 0x00, 0x00,
/* 0x2016d0 */ 0x05, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,     0x43, 0x0f, 0x00, 0x1b,   0x06, 0x01, 0x06, 0x00,
/* 0x2016e0 */ 0x06, 0x01, 0x06, 0x00,   0x00, 0x00, 0x00, 0x00,     0x7c, 0x50, 0xff, 0xff,   0x83, 0x00, 0x00, 0x00,
/* 0x2016f0 */ 0x01, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,     0x45, 0x0f, 0x00, 0x1f,   0x07, 0x01, 0x01, 0x00,
/* 0x201700 */ 0x07, 0x01, 0x02, 0x00,   0x00, 0x00, 0x00, 0x00,     0x94, 0x50, 0xff, 0xff,   0x8f, 0x00, 0x00, 0x00,
/* 0x201710 */ 0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,     0x56, 0x07, 0x00, 0x07,   0xb9, 0x02, 0x04, 0x00,
/* 0x201720 */ 0x85, 0x00, 0x00, 0x00,   0x1f, 0x00, 0x00, 0x00,     0x74, 0x50, 0xff, 0xff,   0x8f, 0x00, 0x00, 0x00,
/* 0x201730 */ 0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,     0x46, 0x07, 0x00, 0x07,   0x4c, 0x01, 0x04, 0x00,
/* 0x201740 */ 0x85, 0x00, 0x00, 0x00,   0x03, 0x00, 0x00, 0x00,     0x74, 0x50, 0xff, 0xff,   0x8f, 0x07, 0x00, 0x00,
/* 0x201750 */ 0x00, 0x00, 0x00, 0x00,   0x13, 0x00, 0xfe, 0x01,     0x54, 0x0f, 0x00, 0x0e,   0x4c, 0x01, 0x04, 0x00,
/* 0x201760 */ 0x86, 0x00, 0x00, 0x00,   0x03, 0x00, 0x00, 0x00,     0x6c, 0x50, 0xff, 0xff,   0x8f, 0x07, 0x00, 0x00,
/* 0x201770 */ 0x00, 0x00, 0x00, 0x00,   0x0d, 0x00, 0x7e, 0x00,     0x32, 0x0f, 0x00, 0x0d,   0x4c, 0x01, 0x04, 0x00,
/* 0x201780 */ 0x87, 0x00, 0x00, 0x00,   0x03, 0x00, 0x00, 0x00,     0x8f, 0x00, 0x00, 0x00,   0x7c, 0x50, 0xff, 0xff,
/* 0x201790 */ 0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,     0x44, 0x07, 0x01, 0x07,   0x7c, 0x50, 0xff, 0xff,
/* 0x2017a0 */ 0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,     0x33, 0x0f, 0x01, 0x07,   0xf4, 0x50, 0xff, 0xff,
/* 0x2017b0 */ 0x83, 0x07, 0x00, 0x00,   0x1f, 0x00, 0x00, 0xf0,     0x00, 0x00, 0x00, 0x00,   0x45, 0x07, 0x00, 0x1b,
/* 0x2017c0 */ 0x43, 0x00, 0x00, 0x00,   0x04, 0x00, 0x00, 0x00,     0x00, 0x7c, 0x00, 0x00,   0x90, 0x50, 0xff, 0xff,
/* 0x2017d0 */ 0x8f, 0x00, 0x00, 0x00,   0x0f, 0x00, 0xff, 0x00,     0x00, 0x00, 0x00, 0x00,   0x44, 0x0f, 0x01, 0x07,
/* 0x2017e0 */ 0x43, 0x00, 0x00, 0x00,   0x04, 0x00, 0x00, 0x00,     0x00, 0x7c, 0x00, 0x00,   0x94, 0xf0, 0xff, 0xff,
/* 0x2017f0 */ 0x8f, 0x00, 0x00, 0x00,   0x0f, 0x00, 0xff, 0x00,     0x00, 0x00, 0x00, 0x00,   0x34, 0x07, 0x00, 0x07,
/* 0x201800 */ 0xed, 0x00, 0x00, 0x00,   0x41, 0x28, 0x00, 0x00,     0xa1, 0x00, 0x00, 0x00,   0x8c, 0xf0, 0xff, 0xff,
/* 0x201810 */ 0x8f, 0x00, 0x00, 0x00,   0x0f, 0x00, 0xff, 0x00,     0x00, 0x00, 0x00, 0x00,   0x34, 0x07, 0x00, 0x07,
/* 0x201820 */ 0xed, 0x00, 0x00, 0x00,   0x41, 0x28, 0x00, 0x00,     0xa1, 0x00, 0x00, 0x00,   0xa0, 0x00, 0x00, 0x00,
/* 0x201830 */ 0x03, 0x50, 0x03, 0x00,   0xf4, 0x50, 0xff, 0xff,     0x83, 0x07, 0x00, 0x00,   0x17, 0x00, 0x00, 0x00,
/* 0x201840 */ 0x00, 0x00, 0x00, 0x00,   0x43, 0x0f, 0x00, 0x1b,     0x04, 0x01, 0x23, 0x00,   0x04, 0x01, 0x26, 0x00,
/* 0x201850 */ 0x09, 0x00, 0x00, 0x00,   0x04, 0x01, 0x23, 0x00,     0x01, 0x00, 0x03, 0x00,   0x7c, 0x50, 0xff, 0xff,
/* 0x201860 */ 0x8f, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,     0x00, 0x00, 0x00, 0x00,   0x44, 0x0f, 0x01, 0x07,
/* 0x201870 */ 0x15, 0x00, 0x00, 0x00,   0x0f, 0x00, 0x31, 0x00,     0x15, 0x00, 0x00, 0x00,   0x01, 0x00, 0x03, 0x00,
/* 0x201880 */ 0x7c, 0x50, 0xff, 0xff,   0x8f, 0x00, 0x00, 0x00,     0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,
/* 0x201890 */ 0x33, 0x0f, 0x01, 0x07,   0x16, 0x00, 0x00, 0x00,     0x0f, 0x00, 0x31, 0x00,   0x16, 0x00, 0x00, 0x00,
/* 0x2018a0 */ 0x00, 0x00, 0x00, 0x00,   0xa0, 0x00, 0x00, 0x00,     0x03, 0x00, 0xff, 0xff,   0x83, 0x00, 0x00, 0x00,
/* 0x2018b0 */ 0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,     0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,
/* 0x2018c0 */ 0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,     0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,
/* 0x2018d0 */ 0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,     0x00, 0x00, 0x28, 0x00,   0x02, 0x00, 0x00, 0x00,
/* 0x2018e0 */ 0xf0, 0x01, 0x00, 0x02,   0x2f, 0x00, 0x02, 0x00,     0xdc, 0x40, 0x04, 0x00,   0x04, 0x01, 0xe4, 0x03,
/* 0x2018f0 */ 0x8b, 0x00, 0x01, 0x70,   0x03, 0x00, 0x00, 0x00,     0x26, 0x00, 0x02, 0x00,   0x05, 0x26, 0x19, 0x01,
/* 0x201900 */ 0x04, 0x0a, 0xe1, 0x03,   0x0b, 0x0c, 0x04, 0x00,     0x23, 0x00, 0x00, 0x00,   0x26, 0x00, 0x02, 0x00,
/* 0x201910 */ 0x05, 0x29, 0x19, 0x01,   0x04, 0x0a, 0xe1, 0x03,     0x0b, 0x0c, 0x04, 0x00,   0x23, 0x00, 0x00, 0x00,
/* 0x201920 */ 0x21, 0x00, 0x02, 0x00,   0x05, 0x25, 0x0f, 0x01,     0x04, 0x0a, 0xe1, 0x03,   0x0b, 0x0c, 0x04, 0x00,
/* 0x201930 */ 0x23, 0x00, 0x00, 0x00,   0x04, 0x0a, 0xe1, 0x03,     0x0b, 0x0c, 0x04, 0x00,   0x54, 0x00, 0x00, 0x00,
/* 0x201940 */ 0x2b, 0x00, 0x02, 0x00,   0x15, 0x46, 0x1f, 0x01,     0x26, 0x00, 0x02, 0x00,   0x05, 0x28, 0x19, 0x01,
/* 0x201950 */ 0x26, 0x00, 0x02, 0x00,   0x05, 0x2a, 0x19, 0x01,     0x2a, 0x00, 0x02, 0x00,   0x05, 0x25, 0x0f, 0x01,
/* 0x201960 */ 0x04, 0x0a, 0xe1, 0x03,   0x0b, 0x0c, 0x04, 0x00,     0x38, 0x00, 0x00, 0x00,   0x21, 0x00, 0x02, 0x00,
/* 0x201970 */ 0x05, 0x26, 0x0f, 0x01,   0x25, 0x00, 0x02, 0x00,     0x05, 0x26, 0x0f, 0x01,   0x04, 0x01, 0xe4, 0x03,
/* 0x201980 */ 0x8b, 0x00, 0x00, 0x70,   0x10, 0x1d, 0x00, 0x00,     0x2a, 0x00, 0x02, 0x00,   0x10, 0x40, 0x0c, 0x00,
/* 0x201990 */ 0x2a, 0x00, 0x02, 0x00,   0x10, 0x40, 0x0c, 0x00,     0x04, 0x0a, 0xe4, 0x03,   0x0b, 0x0c, 0x00, 0x00,
/* 0x2019a0 */ 0x2e, 0x00, 0x02, 0x00,   0x14, 0x60, 0x0c, 0x00,     0x2a, 0x00, 0x02, 0x00,   0x14, 0x80, 0x0c, 0x00,
/* 0x2019b0 */ 0x2f, 0x00, 0x02, 0x00,   0x94, 0x80, 0x0c, 0x00,     0x22, 0x00, 0x02, 0x00,   0x94, 0x70, 0x0c, 0x00,
/* 0x2019c0 */ 0x02, 0x00, 0x00, 0x00,   0x05, 0xcc, 0x0c, 0x01,     0x50, 0x01, 0x00, 0x03,   0x80, 0x40, 0x01, 0x00,
/* 0x2019d0 */ 0x00, 0x00, 0x00, 0x00,   0x10, 0x00, 0x00, 0x00,     0xa3, 0x90, 0x03, 0x00,   0xf6, 0x7f, 0x20, 0x00,
/* 0x2019e0 */ 0x0b, 0x40, 0x04, 0x00,   0x04, 0x01, 0x00, 0x00,     0x13, 0x01, 0x00, 0x00,   0xa3, 0x90, 0x03, 0x00,
/* 0x2019f0 */ 0xf6, 0x7f, 0x20, 0x00,   0x0b, 0x40, 0x04, 0x00,     0x06, 0x62, 0x00, 0x00,   0x60, 0x00, 0x08, 0x00,
/* 0x201a00 */ 0x05, 0x5d, 0x80, 0x0f,   0x38, 0x00, 0x00, 0x00,     0xa3, 0x90, 0x03, 0x00,   0xf6, 0x7f, 0x20, 0x00,
/* 0x201a10 */ 0x0b, 0x40, 0x04, 0x00,   0x06, 0x62, 0x00, 0x00,     0x60, 0x00, 0x08, 0x00,   0x09, 0x5d, 0x80, 0x0f,
/* 0x201a20 */ 0x38, 0x00, 0x00, 0x00,   0x20, 0xdb, 0x03, 0x00,     0x02, 0x00, 0x00, 0x00,   0x00, 0x00, 0x0c, 0x00,
/* 0x201a30 */ 0xf7, 0x7f, 0x10, 0x10,   0x07, 0x40, 0x00, 0x00,     0x50, 0x01, 0x00, 0x03,   0x80, 0xc0, 0x00, 0x00,
/* 0x201a40 */ 0x4a, 0x00, 0x50, 0x00,   0x1c, 0x00, 0x00, 0x00,     0x04, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,
/* 0x201a50 */ 0x00, 0x00, 0x00, 0x01,   0x02, 0x00, 0x00, 0x00,     0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,
/* 0x201a60 */ 0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,     0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,
/* 0x201a70 */ 0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,     0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,
/* 0x201a80 */ 0x37, 0x34, 0x36, 0x32,   0x00, 0x00, 0x00, 0x00,     0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,
/* 0x201a90 */ 0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,     0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,
/* 0x201aa0 */ 0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,     0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,
/* 0x201ab0 */ 0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00,     0x00, 0x00, 0x00, 0x00,   0x00, 0x00, 0x00, 0x00
/* 0x201ac0 */

}; /* phCfg_EE_Build_Values */

#if PHFL_CONFIG_TARGET_PLATFORM == PH_CONFIG_TARGET_PLATFORM_IAR
    #pragma keep_definition=phCfg_EE_Build_Values
#endif

#endif /* NXPBUILD__CFG_ENABLE_EE_DOWNLOAD */
