/*
 *                    Copyright (c), NXP Semiconductors
 *
 *                       (C) NXP Semiconductors 2014,2015
 *
 *         All rights are reserved. Reproduction in whole or in part is
 *        prohibited without the written consent of the copyright owner.
 *    NXP reserves the right to make changes without notice at any time.
 *   NXP makes no warranty, expressed, implied or statutory, including but
 *   not limited to any implied warranty of merchantability or fitness for any
 *  particular purpose, or that the use will not infringe any third party patent,
 *   copyright or trademark. NXP must not be liable for any loss or damage
 *                            arising from its use.
 */

/** @file
 *
 * CT RTOS event mechanism.
 *
 * Project:  PN7462AU
 *
 * $Date: 2015-12-14 11:44:15 +0530 (Mon, 14 Dec 2015) $
 * $Author: Rajesh Sugasi (nxp69678) $
 * $Revision: 16973 $ (v04.18.00)
 */

/* *****************************************************************************************************************
 * Includes
 * ***************************************************************************************************************** */
#include "ph_Datatypes.h"
#include "ph_NxpBuild.h"

#ifdef NXPBUILD__PHHAL_CT
#include "phhalNvic.h"
#include "phhalCt.h"

/* Event Based Functionality. */
#include "phhalCt_Event.h"

/* Kernel includes. */
#include "phFlashBoot_Event.h"
#include "phOsal.h"

/* *****************************************************************************************************************
 * Internal Definitions
 * ***************************************************************************************************************** */

/* *****************************************************************************************************************
 * Type Definitions
 * ***************************************************************************************************************** */

/* *****************************************************************************************************************
 * Global and Static Variables
 * Total Size: NNNbytes
 * ***************************************************************************************************************** */

phOsal_EventObj_t 		HwEventObj;                               /**< Event Object */

/* *****************************************************************************************************************
 * Private Functions Prototypes
 * ***************************************************************************************************************** */

/* *****************************************************************************************************************
 * Private Functions
 * ***************************************************************************************************************** */

/* *****************************************************************************************************************
 * Public Functions
 * ***************************************************************************************************************** */

phStatus_t phhalCt_Event_Init(void)
{
	return phOsal_EventCreate( &(HwEventObj.EventHandle), &HwEventObj );
}

phStatus_t phhalCt_Event_WaitAny( 	phhalCt_EventType_t eEventType,
        							uint32_t dwTimeout,
									phhalCt_EventType_t * pRcvdEvt,
									uint32_t fConsume)
{
    phStatus_t eStatus = PH_ERR_FAILED;
    uint32_t xbits = 0;

    if (HwEventObj.EventHandle == NULL) /* In case it is not initialized yet */
        return PH_ERR(FAILED,HAL_CT);

    /* Clear the Events */
    if (fConsume == TRUE)
    {
        eStatus = phhalCt_Event_Consume(eEventType);
    }

    /* Don't Clear flags after ISR and Wait for any bits to be Set */
    phOsal_EventPend( &(HwEventObj.EventHandle), E_OS_EVENT_OPT_NONE, dwTimeout, (uint32_t)eEventType, (phOsal_EventBits_t *)&xbits );

    if( (xbits & ((uint32_t)eEventType)) != 0 )
    {
        /* Return the Events That were Set */
        *pRcvdEvt = (phhalCt_EventType_t) xbits;
        eStatus = PH_ERR_SUCCESS;
    }
    else
    {
        eStatus = PH_ERR_OPERATION_TIMEDOUT;
    }

    return PH_ADD_COMPCODE(eStatus,PH_COMP_HAL_CT);
}
/**
 *
 * @param eEventType
 * @return
 */
phStatus_t  phhalCt_Event_Post(phhalCt_EventType_t eEventType)
{
	if( HwEventObj.EventHandle == NULL )    /* In case it is not initialized yet */
	     return PH_ERR(INVALID_PARAMETER,HAL_CT);

	phOsal_EventPost( &(HwEventObj.EventHandle),E_OS_EVENT_OPT_NONE, (uint32_t)eEventType, NULL );

    return PH_ERR_SUCCESS;
}

phStatus_t  phhalCt_Event_Consume(phhalCt_EventType_t eEventType)
{
	phOsal_EventClear( &(HwEventObj.EventHandle), E_OS_EVENT_OPT_NONE, (uint32_t)eEventType, NULL );

    return PH_ERR_SUCCESS;
}

phStatus_t phhalCt_Event_Deinit(void)
{
    /* Delete the Event Group */
	phOsal_EventDelete( &(HwEventObj.EventHandle) );

    return PH_ERR_SUCCESS;
}

#endif /* NXPBUILD__PHHAL_CT */
