/*----------------------------------------------------------------------------*/
/* Copyright 2014-2015, 2022 NXP                                              */
/*                                                                            */
/* NXP Confidential. This software is owned or controlled by NXP and may only */
/* be used strictly in accordance with the applicable license terms.          */
/* By expressly accepting such terms or by downloading, installing,           */
/* activating and/or otherwise using the software, you are agreeing that you  */
/* have read, and that you agree to comply with and are bound by, such        */
/* license terms. If you do not agree to be bound by the applicable license   */
/* terms, then you may not retain, install, activate or otherwise use the     */
/* software.                                                                  */
/*----------------------------------------------------------------------------*/

/** @file
 *
 * SPI Master event based mechanism implementation.
 *
 * Project:  PN7462AU
 *
 * $Date:
 * $Author:
 * $Revision:
 */

/* *****************************************************************************************************************
 * Includes
 * ***************************************************************************************************************** */
#include "ph_Datatypes.h"
#include "ph_NxpBuild.h"

#ifdef NXPBUILD__PHHAL_SPIM
#include "phhalSPIM.h"
#include "phhalSPIM_Event.h"
#include "PN7462AU/PN7462AU_spim.h"
#include "phOsal.h"

/* *****************************************************************************************************************
 * Internal Definitions
 * ***************************************************************************************************************** */

/* *****************************************************************************************************************
 * Type Definitions
 * ***************************************************************************************************************** */

/* *****************************************************************************************************************
 * Global and Static Variables
 * Total Size: NNNbytes
 * ***************************************************************************************************************** */
/* The Event signals used by SPIM tasks. */
PH_NOINIT static uint32_t dwEventTimeOut = 0;
PH_NOINIT static phOsal_EventObj_t      HwEventObj;                               /**< Event Object */
/* *****************************************************************************************************************
 * Private Functions Prototypes
 * ***************************************************************************************************************** */

/* *****************************************************************************************************************
 * Public Functions
 * ***************************************************************************************************************** */

phStatus_t phhalSPIM_EventRegister(uint32_t dwSpimTimeOut PH_UNUSED)
{
    phStatus_t e_Status;
    dwEventTimeOut  = dwSpimTimeOut;

    e_Status = phOsal_EventCreate( &(HwEventObj.EventHandle), &HwEventObj );

#if PHFL_PARAM_CHECK >= PH_PARAM_CHECK_SW_RESOURCE
    /* Was the event group created successfully? */
    PH_RETURN_IF_TRUE_WITH_ERROR((e_Status != PH_OSAL_SUCCESS),RESOURCE_ERROR, SPIM )
#endif
    return PH_ERR_SUCCESS;
}

/*
 * phhalSPIM_EventHandler Event handler is called from Interrupt/Handler context.
 *
 * */
phStatus_t phhalSPIM_EventHandler(phStatus_t eStatus PH_UNUSED)
{

#if PHFL_PARAM_CHECK >= PH_PARAM_CHECK_SW_RESOURCE
    phStatus_t e_Status;
#endif

#if PHFL_PARAM_CHECK >= PH_PARAM_CHECK_SW_RESOURCE
    e_Status = /* We are interested in the value only conditionally */
#endif

    phOsal_EventPost( &(HwEventObj.EventHandle),E_OS_EVENT_OPT_NONE, (uint32_t)eStatus, NULL );

#if PHFL_PARAM_CHECK >= PH_PARAM_CHECK_SW_RESOURCE
    PH_RETURN_IF_TRUE_WITH_ERROR((e_Status != PH_OSAL_SUCCESS),RESOURCE_ERROR,SPIM)
#endif
    return PH_ERR_SUCCESS;
}

phStatus_t phhalSPIM_EventWait(void)
{
    uint32_t dwBits = 0;

    phOsal_EventPend( &(HwEventObj.EventHandle), E_OS_EVENT_OPT_PEND_CLEAR_ON_EXIT, dwEventTimeOut,
            SPIM_INT_STATUS_REG_AHB_ADDR_ERROR_STATUS_MASK
            | SPIM_INT_STATUS_REG_AHB_ERROR_STATUS_MASK
            | SPIM_INT_STATUS_REG_EOT_STATUS_MASK
            | SPIM_INT_STATUS_REG_EOR_STATUS_MASK, &dwBits);

    if ( dwBits & (SPIM_INT_STATUS_REG_AHB_ADDR_ERROR_STATUS_MASK | SPIM_INT_STATUS_REG_AHB_ERROR_STATUS_MASK) )
    {
        dwBits >>= 8;
        return (uint16_t)(dwBits | PH_ERR_CUSTOM_BEGIN | PH_COMP_SPIM);
    }else if ( dwBits & (SPIM_INT_STATUS_REG_EOT_STATUS_MASK | SPIM_INT_STATUS_REG_EOR_STATUS_MASK) ){
        return PH_ERR_SUCCESS;
    }
    else{
        return PH_ERR(OPERATION_TIMEDOUT, SPIM);
    }
}

void phhalSPIM_EventUnRegister(void)
{
    /* Delete an event group that was previously created by phhalSPIM_EventRegister. */
    phOsal_EventDelete( &(HwEventObj.EventHandle) );
}

/* *****************************************************************************************************************
 * Private Functions
 * ***************************************************************************************************************** */

#endif /* NXPBUILD__PHHAL_SPIM */
