/*----------------------------------------------------------------------------*/
/* Copyright 2020 NXP                                                         */
/*                                                                            */
/* NXP Confidential. This software is owned or controlled by NXP and may only */
/* be used strictly in accordance with the applicable license terms.          */
/* By expressly accepting such terms or by downloading, installing,           */
/* activating and/or otherwise using the software, you are agreeing that you  */
/* have read, and that you agree to comply with and are bound by, such        */
/* license terms. If you do not agree to be bound by the applicable license   */
/* terms, then you may not retain, install, activate or otherwise use the     */
/* software.                                                                  */
/*----------------------------------------------------------------------------*/

/** \file
* Example application demonstrating one use case of MIFARE Plus contactless IC with Reader Library.
* $Author$
* $Revision$ (v06.10.00)
* $Date$
*/

#ifndef INTFS_NFCRDLIBEX_MIFAREPLUS_H_
#define INTFS_NFCRDLIBEX_MIFAREPLUS_H_

/**
* Reader Library Headers
*/
#include <ph_Status.h>

/* Enable(1) / Disable(0) printing error/info */
#define DETECT_ERROR 0

#if DETECT_ERROR
    #include <stdio.h>
    #define DEBUG_ERROR_PRINT CHECK_STATUS
    #define PRINT_ERROR(...) DEBUG_PRINTF(__VA_ARGS__)
#else /* DETECT_ERROR */
    #define DEBUG_ERROR_PRINT(x)
    #define PRINT_ERROR(...)
#endif /* DETECT_ERROR */


/* Reader library layers required for this example */
#define NXPBUILD_TEST_MFPEVX_MANDATORY_LAYERS                     \
            (defined(NXPBUILD__PHHAL_HW_RC663)                    \
            || defined(NXPBUILD__PHHAL_HW_PN5190)                 \
            || defined(NXPBUILD__PHHAL_HW_PN5180)                 \
            || defined (NXPBUILD__PHHAL_HW_PN7462AU))             \
            && defined(NXPBUILD__PHHAL_HW)                        \
            && defined(NXPBUILD__PHPAL_I14443P3A_SW)              \
            && defined(NXPBUILD__PHPAL_I14443P4A_SW)              \
            && defined(NXPBUILD__PHPAL_I14443P4_SW)               \
            && defined(NXPBUILD__PHPAL_MIFARE_SW)                 \
            && (defined(PH_OSAL_FREERTOS)                         \
            || defined(PH_OSAL_NULLOS)                            \
            || defined (PH_OSAL_LINUX))                           \
            && defined(NXPBUILD__PH_CRYPTOSYM_SW)                 \
            && defined(NXPBUILD__PH_CRYPTORNG_SW)                 \
            && (defined(NXPBUILD__PH_KEYSTORE_SW)                 \
            || defined(NXPBUILD__PH_KEYSTORE_RC663))

/* Check if all required reader library layers are enabled. */
#if NXPBUILD_TEST_MFPEVX_MANDATORY_LAYERS

/*******************************************************************************
**  Macros
*******************************************************************************/

/* Use application callback for processing UPDATE BINARY and proprietary
 * commands */
#define USE_APP_CALLBACK 1

/* Get content length from CC file. Initial content length is 0. */
#define GET_CCFILE_CONTENT_LEN(x) ((((uint16_t)(x[0]) << 8) & 0xFF00) | (x[1]))

/* Get content length specified in file (first 2 bytes of file) for NDEF and
 * proprietary files */
#define GET_FILE_CONTENT_LEN(x) ((((((uint16_t)(x[0]) << 8) & 0xFF00) | (x[1])) > 0)?   \
                                 (((((uint16_t)(x[0]) << 8) & 0xFF00) | (x[1])) + 2) : 0)

/***********************************************************************************************
 * \brief   Print a given array of integers on the console
 * \param   *pBuff   Buffer Reference
 * \param   size      data size to be print
 **********************************************************************************************/
/* Print system critical errors (with which execution can't proceed further)
 * and halt the execution. */
#define ERROR_CRITICAL(...) DEBUG_PRINTF(__VA_ARGS__); while(1) { /* Nothing to do */ }

#ifdef PH_OSAL_FREERTOS
#ifdef PHOSAL_FREERTOS_STATIC_MEM_ALLOCATION
#define MIFAREPLUSEV1_TASK_STACK              (1600/4)
#else /* PHOSAL_FREERTOS_STATIC_MEM_ALLOCATION */
#ifdef __PN74XXXX__
#define MIFAREPLUSEV1_TASK_STACK              (1600/4)
#else /*  __PN74XXXX__*/
#define MIFAREPLUSEV1_TASK_STACK              (1600)
#endif /*  __PN74XXXX__*/
#endif /* PHOSAL_FREERTOS_STATIC_MEM_ALLOCATION */

#define MIFAREPLUSEV1_TASK_PRIO                3
#endif /* PH_OSAL_FREERTOS */

#ifdef PH_OSAL_LINUX
#define MIFAREPLUSEV1_TASK_STACK                0x20000
#define MIFAREPLUSEV1_TASK_PRIO                 0
#endif /* PH_OSAL_LINUX */

/*******************************************************************************
**  Forward declarations
*******************************************************************************/
/**
 * Main thread which starts discovery loop in poll mode and detect MIFARE Plus card.
 * Performs possible operations with MIFARE Plus card to show case the different operations
 * that can be performed on MIFARE Plus card.
 * */
void MIFAREPlusEV1_EV2_Demo(
                     void *pParams        /* [in] Input parameter to thread (not used here) */
                     );

#endif /* NXPBUILD_TEST_MFPEVX_MANDATORY_LAYERS */

#endif /* INTFS_NFCRDLIBEX_MIFAREPLUS_H_ */
