/*
*                     Copyright 2016-2020, NXP
*
*       All rights are reserved. Reproduction in whole or in part is
*      prohibited without the written consent of the copyright owner.
*  NXP reserves the right to make changes without notice at any time.
* NXP makes no warranty, expressed, implied or statutory, including but
* not limited to any implied warranty of merchantability or fitness for any
*particular purpose, or that the use will not infringe any third party patent,
* copyright or trademark. NXP must not be liable for any loss or damage
*                          arising from its use.
*/

/** \file
* NTag I2C application.
* $Author$
* $Revision$ (v06.10.00)
* $Date$
*/

#ifndef INTFS_NFCRDLIBEX9_NTAGI2C_H_
#define INTFS_NFCRDLIBEX9_NTAGI2C_H_
#include <ph_Status.h>

#define DATA_BUFFER_LEN         16         /* Buffer length */

/* Tag Version info macros */
#define NTAG_I2C_1K_VERSION     0x13       /* Tag Version: 1k */
#define NTAG_I2C_2K_VERSION     0x15       /* Tag Version: 2k */

#define PTHRU_ON_OFF            (1 << 6)   /* NC_REG Pass-through bit */

#ifdef PH_OSAL_FREERTOS
#ifdef PHOSAL_FREERTOS_STATIC_MEM_ALLOCATION
#define NTAGI2C_TASK_STACK              (1200/4)
#else /* PHOSAL_FREERTOS_STATIC_MEM_ALLOCATION */
#ifdef __PN74XXXX__
#define NTAGI2C_TASK_STACK              (1200/4)
#else /*  __PN74XXXX__*/
#define NTAGI2C_TASK_STACK              (1200)
#endif /*  __PN74XXXX__*/
#endif /* PHOSAL_FREERTOS_STATIC_MEM_ALLOCATION */
#define NTAGI2C_TASK_PRIO                4
#endif /* PH_OSAL_FREERTOS */

#ifdef PH_OSAL_LINUX
#define NTAGI2C_TASK_STACK                0x20000
#define NTAGI2C_TASK_PRIO                 0
#endif /* PH_OSAL_LINUX */


#endif /* INTFS_NFCRDLIBEX9_NTAGI2C_H_ */
