/* Copyright 2021 NXP
*
* This software is owned or controlled by NXP and may only be used
* strictly in accordance with the applicable license terms.  By expressly
* accepting such terms or by downloading, installing, activating and/or
* otherwise using the software, you are agreeing that you have read, and
* that you agree to comply with and are bound by, such license terms.  If
* you do not agree to be bound by the applicable license terms, then you
* may not retain, install, activate or otherwise use the software.
*
*/

/** \file
* Generic phDriver Component of Reader Library Framework.
* $Author$ Petar Hlad
* $Revision$
* $Date$
*
* History:
*  RS: Generated 12. Jul 2021
*
*/

#ifndef BOARD_MIMXRT1170_PNEV5190B_H_
#define BOARD_MIMXRT1170_PNEV5190B_H_

#include "MIMXRT1176_cm7.h"
#include "board.h"
#include "clock_config.h"
#include "pin_mux.h"


#define GPIO_PORT_A         1
#define GPIO_PORT_B         2
#define GPIO_PORT_C         3
#define GPIO_PORT_D         4
#define GPIO_PORT_E         5
#define GPIO_PORT_F         6
#define GPIO_PORT_G         7
#define GPIO_PORT_H         8
#define GPIO_PORT_I         9
#define GPIO_PORT_J        10
#define GPIO_PORT_K        11
#define GPIO_PORT_L        12
#define GPIO_PORT_M        13

/******************************************************************
 * Board Pin/Gpio configurations
 ******************************************************************/
/* Pin configuration format : Its a 32 bit format where every byte represents a field as shown below.
 * | Byte3 | Byte2 | Byte1      | Byte0 |
 * |  --   |  --   | GPIO/PORT  | PIN   |
 * */
#define PHDRIVER_PIN_RESET  ((GPIO_PORT_I << 8) | 13)  /**< Reset pin, Pin13, GPIO9  */
#define PHDRIVER_PIN_IRQ    ((GPIO_PORT_E << 8) | 13)    /**< IRQ pin, Pin13, GPIO5  */

/* For 5190 busy is same as IRQ */
#define PHDRIVER_PIN_BUSY    ((GPIO_PORT_K << 8) | 13)  /**< IRQ pin,     Pin13, GPIO11 */
#define PHDRIVER_PIN_DWL     ((GPIO_PORT_I << 8) |  4)  /**< Download pin, Pin4, GPIO9 */

#define PHDRIVER_PIN_RLED   ((GPIO_PORT_I << 8) | 25)   /**< RED LED, Pin25, GPIO9 */
#define PHDRIVER_PIN_GLED   ((GPIO_PORT_I << 8) |  3)   /**< GREEN LED, Pin3, GPIO9 */

/* These pins are used for EMVCo Interoperability test status indication,
 * not for the generic Reader Library implementation.
 */
#define PHDRIVER_PIN_SUCCESS   ((GPIO_PORT_K << 8) | 12)   /**< GPIO, Pin12, GPIO11 */
#define PHDRIVER_PIN_FAIL      ((GPIO_PORT_K << 8) | 11)   /**< GPIO, Pin11, GPIO11 */

/******************************************************************
 * PIN Pull-Up/Pull-Down configurations.
 ******************************************************************/
#define PHDRIVER_PIN_RESET_PULL_CFG    PH_DRIVER_PULL_UP
#define PHDRIVER_PIN_IRQ_PULL_CFG      PH_DRIVER_PULL_DOWN
#define PHDRIVER_PIN_NSS_PULL_CFG      PH_DRIVER_PULL_UP

#define PHDRIVER_PIN_BUSY_PULL_CFG     PH_DRIVER_PULL_UP
#define PHDRIVER_PIN_DWL_PULL_CFG      PH_DRIVER_PULL_UP


/******************************************************************
 * IRQ PIN NVIC settings
 ******************************************************************/
#define EINT_IRQn                 GPIO5_Combined_0_15_IRQn
#define EINT_PRIORITY             8
#define CLIF_IRQHandler           GPIO5_Combined_0_15_IRQHandler
#define PIN_IRQ_TRIGGER_TYPE      PH_DRIVER_INTERRUPT_RISINGEDGE

/*****************************************************************
 * Front End Reset logic level settings
 ****************************************************************/
#define PH_DRIVER_SET_HIGH            1          /**< Logic High. */
#define PH_DRIVER_SET_LOW             0          /**< Logic Low. */
#define RESET_POWERDOWN_LEVEL         PH_DRIVER_SET_LOW
#define RESET_POWERUP_LEVEL           PH_DRIVER_SET_HIGH

/*****************************************************************
 * SPI Configuration
 ****************************************************************/
#define PHDRIVER_IMX_SPI_POLLING          /* Enable to perform SPI transfer using polling method. */
#define PHDRIVER_IMX_SPI_MASTER           LPSPI1
#define PHDRIVER_IMX_SPI_DATA_RATE        5000000U
#define PHDRIVER_IMX_SPI_CLK_SRC          CCM_OBS_LPSPI1_CLK_ROOT
#define PHDRIVER_IMX_SPI_IRQ              LPSPI1_IRQn

#define RX_BUFFER_SIZE_MAX                260

#define LPSPI_IRQ_PRIORITY     7

#define PHDRIVER_PIN_SSEL     ((GPIO_PORT_I  << 8) | 28 )  /**< Slave select pin, pin28, GPIO9 */

/*****************************************************************
 * Timer Configuration
 ****************************************************************/
#define PH_DRIVER_IMX_PIT_TIMER          PIT1
#define PH_DRIVER_IMX_PIT_CLK            kCLOCK_Root_Bus
#define PH_DRIVER_IMX_TIMER_CHANNEL      kPIT_Chnl_0    /**< PIT channel number 0 */
#define PH_DRIVER_IMX_TIMER_NVIC         PIT1_IRQn
#define PH_DRIVER_IMX_TIMER_PRIORITY     8

#endif /* DAL_BOARDS_BOARD_MIMXRT1170_PNEV5190B_H_ */
