/*
 *                  Copyright (c), NXP Semiconductors
 *
 *                     (C)NXP Semiconductors
 *        All rights are reserved. Reproduction in whole or in part is
 *       prohibited without the written consent of the copyright owner.
 *   NXP reserves the right to make changes without notice at any time.
 *  NXP makes no warranty, expressed, implied or statutory, including but
 * not limited to any implied warranty of merchantability or fitness for any
 * particular purpose, or that the use will not infringe any third party patent,
 *  copyright or trademark. NXP must not be liable for any loss or damage
 *                          arising from its use.
 */

/**
 * \file phFlashBoot_InitArm_GNU.c
 *
 * $Author: Ankur Srivastava (nxp79569) $
 * $Revision: 18485 $ (v04.16.00)
 * $Date: 2016-06-22 11:25:52 +0530 (Wed, 22 Jun 2016) $
 *
 */


#include <ph_Datatypes.h>

#ifdef __GNUC__

#include "ph_MemoryMap.h"
#include "phUser.h"
extern int main( void );
void phFlashBoot_ZIBSS(void);

#ifdef __CODE_RED
extern void __main(void);

void
__attribute__((naked))
PH_PLACE_FUNCTION_TO_SECTION(".after_vectors")
ResetISR(void) {

    /* Copy the data sections from flash to SRAM. */

    asm("CPSID i");

    asm("LDR     R0, =gkpphFlashBoot_InitialPSP");
    asm("LDR     R1, [R0]");
    asm("msr     PSP, R1");
    asm("movs    R0, #2");
    asm("msr     CONTROL, R0");
    asm("isb");

    phFlashBoot_ZIBSS();

/* SystemInit(); */

#if defined (__cplusplus)
    /* Call C++ library initialization */
    __libc_init_array();
#endif /* __cplusplus */

#if defined (__REDLIB__)
    /* Call the Redlib library, which in turn calls main() */
    __main();
#else /* __REDLIB__ */
    main();
#endif /* __REDLIB__ */
    /* main() shouldn't return, but if it does, we'll just enter an infinite loop */
    while (1) {
        ;
    }
}


#else /* __CODE_RED */

__attribute__((naked))
PH_PLACE_FUNCTION_TO_SECTION(".after_vectors")
void phFlashBoot_BootISR() {

    asm("CPSID i");

    asm("LDR     R0, =gkpphFlashBoot_InitialPSP");
    asm("LDR     R1, [R0]");
    asm("msr     PSP, R1");
    asm("movs    R0, #2");
    asm("msr     CONTROL, R0");
    asm("isb");

    main();

    /* main() shouldn't return, but if it does, we'll just enter an infinite loop */
    __phUser_EnterCriticalSection();
    while ( 1 ) {
        __WFI();
    }

}
#endif  /* __CODE_RED */

/* Use the 'naked' attribute so that C stacking is not used. */
__attribute__((naked))
PH_PLACE_FUNCTION_TO_SECTION(".after_vectors")
void phFlashBoot_HardFault_Handler(void){
    /* Use assembly to pick up date, but feed to C Code. */

    __asm(  ".syntax divided\n"
            "MOVS   R0, #4  \n"
            "MOV    R1, LR  \n"
            "TST    R0, R1  \n"
            "BEQ    _MSP    \n"
            "MRS    R0, PSP \n"
            "B      phFlashBoot_HardFault_HandlerC      \n"
        "_MSP:  \n"
            "MRS    R0, MSP \n"
            "B      phFlashBoot_HardFault_HandlerC      \n"
        ".syntax divided\n") ;
}


static void data_init(unsigned int romstart, unsigned int start, unsigned int len);
static void bss_init(unsigned int start, unsigned int len);

/*****************************************************************************
 The following symbols are constructs generated by the linker, indicating
 the location of various points in the "Global Section Table". This table is
 created by the linker via the linker script mechanism. It contains the length
 of BSS (Non-zero initialized) section.
 *****************************************************************************/

extern unsigned int __data_section_table;
extern unsigned int __data_section_table_end;
extern unsigned int __bss_section_table;
extern unsigned int __bss_section_table_end;



/* ****************************************************************************
 * Functions to carry out the initialization of RW and BSS data sections. These
 * are written as separate functions rather than being inlined within the
 * ResetISR() function in order to cope with MCUs with multiple banks of
 * memory.
 ***************************************************************************** */
PH_PLACE_FUNCTION_TO_SECTION(".after_vectors")
static void data_init(unsigned int romstart, unsigned int start, unsigned int len) {
    unsigned int *pulDest = (unsigned int*) start;
    unsigned int *pulSrc = (unsigned int*) romstart;
    unsigned int loop;
    for (loop = 0; loop < len; loop = loop + 4)
        *pulDest++ = *pulSrc++;
}

PH_PLACE_FUNCTION_TO_SECTION(".after_vectors")
static void bss_init(unsigned int start, unsigned int len) {
    unsigned int *pulDest = (unsigned int*) start;
    unsigned int loop;
    for (loop = 0; loop < len; loop = loop + 4)
        *pulDest++ = 0;
}

PH_PLACE_FUNCTION_TO_SECTION(".after_vectors")
void phFlashBoot_ZIBSS(void)
{
    /* Copy the data sections from flash to SRAM. */
    unsigned int LoadAddr, ExeAddr, SectionLen;
    unsigned int *SectionTableAddr;

    /* Load base address of Global Section Table */
    SectionTableAddr = &__data_section_table;

    /* Copy the data sections from flash to SRAM. */
    while (SectionTableAddr < &__data_section_table_end) {
        LoadAddr = *SectionTableAddr++;
        ExeAddr = *SectionTableAddr++;
        SectionLen = *SectionTableAddr++;
        data_init(LoadAddr, ExeAddr, SectionLen);
    }
    /* At this point, SectionTableAddr = &__bss_section_table; */
    /* Zero fill the bss segment */
    while (SectionTableAddr < &__bss_section_table_end) {
        ExeAddr = *SectionTableAddr++;
        SectionLen = *SectionTableAddr++;
        bss_init(ExeAddr, SectionLen);
    }
}


#endif /* __GNUC__ */
