/*
 *                    Copyright (c), NXP Semiconductors
 *
 *                       (C) NXP Semiconductors 2013
 *
 *         All rights are reserved. Reproduction in whole or in part is
 *        prohibited without the written consent of the copyright owner.
 *    NXP reserves the right to make changes without notice at any time.
 *   NXP makes no warranty, expressed, implied or statutory, including but
 *   not limited to any implied warranty of merchantability or fitness for any
 *  particular purpose, or that the use will not infringe any third party patent,
 *   copyright or trademark. NXP must not be liable for any loss or damage
 *                            arising from its use.
 */

/**
 *
 * Useful and portable binary conversions across compilers
 *
 * Project:  PN7462AU
 *
 * $Date: 2015-05-08 14:11:07 +0530 (Fri, 08 May 2015) $
 * $Author: Purnank H G (ing05193) $
 * $Revision: 12421 $ (v04.16.00)
 */

#ifndef PH_BINARYNUMBERS_H
#define PH_BINARYNUMBERS_H

#define B_000_0000_0000 (0x000U)
#define B_000_0000_0001 (0x001U)
#define B_000_0000_0010 (0x002U)
#define B_000_0000_0011 (0x003U)
#define B_000_0000_0100 (0x004U)
#define B_000_0000_0101 (0x005U)
#define B_000_0000_0110 (0x006U)
#define B_000_0000_0111 (0x007U)
#define B_000_0000_1000 (0x008U)
#define B_000_0000_1001 (0x009U)
#define B_000_0000_1010 (0x00AU)
#define B_000_0000_1011 (0x00BU)
#define B_000_0000_1100 (0x00CU)
#define B_000_0000_1101 (0x00DU)
#define B_000_0000_1110 (0x00EU)
#define B_000_0000_1111 (0x00FU)

#define B_000_0001_0000 (0x010U)
#define B_000_0001_0001 (0x011U)
#define B_000_0001_0010 (0x012U)
#define B_000_0001_0011 (0x013U)
#define B_000_0001_0100 (0x014U)
#define B_000_0001_0101 (0x015U)
#define B_000_0001_0110 (0x016U)
#define B_000_0001_0111 (0x017U)
#define B_000_0001_1000 (0x018U)
#define B_000_0001_1001 (0x019U)
#define B_000_0001_1010 (0x01AU)
#define B_000_0001_1011 (0x01BU)
#define B_000_0001_1100 (0x01CU)
#define B_000_0001_1101 (0x01DU)
#define B_000_0001_1110 (0x01EU)
#define B_000_0001_1111 (0x01FU)

#define B_000_0010_0000 (0x020U)
#define B_000_0010_0001 (0x021U)
#define B_000_0010_0010 (0x022U)
#define B_000_0010_0011 (0x023U)
#define B_000_0010_0100 (0x024U)
#define B_000_0010_0101 (0x025U)
#define B_000_0010_0110 (0x026U)
#define B_000_0010_0111 (0x027U)
#define B_000_0010_1000 (0x028U)
#define B_000_0010_1001 (0x029U)
#define B_000_0010_1010 (0x02AU)
#define B_000_0010_1011 (0x02BU)
#define B_000_0010_1100 (0x02CU)
#define B_000_0010_1101 (0x02DU)
#define B_000_0010_1110 (0x02EU)
#define B_000_0010_1111 (0x02FU)

#define B_000_0011_0000 (0x030U)
#define B_000_0011_0001 (0x031U)
#define B_000_0011_0010 (0x032U)
#define B_000_0011_0011 (0x033U)
#define B_000_0011_0100 (0x034U)
#define B_000_0011_0101 (0x035U)
#define B_000_0011_0110 (0x036U)
#define B_000_0011_0111 (0x037U)
#define B_000_0011_1000 (0x038U)
#define B_000_0011_1001 (0x039U)
#define B_000_0011_1010 (0x03AU)
#define B_000_0011_1011 (0x03BU)
#define B_000_0011_1100 (0x03CU)
#define B_000_0011_1101 (0x03DU)
#define B_000_0011_1110 (0x03EU)
#define B_000_0011_1111 (0x03FU)

#define B_000_0100_0000 (0x040U)
#define B_000_0100_0001 (0x041U)
#define B_000_0100_0010 (0x042U)
#define B_000_0100_0011 (0x043U)
#define B_000_0100_0100 (0x044U)
#define B_000_0100_0101 (0x045U)
#define B_000_0100_0110 (0x046U)
#define B_000_0100_0111 (0x047U)
#define B_000_0100_1000 (0x048U)
#define B_000_0100_1001 (0x049U)
#define B_000_0100_1010 (0x04AU)
#define B_000_0100_1011 (0x04BU)
#define B_000_0100_1100 (0x04CU)
#define B_000_0100_1101 (0x04DU)
#define B_000_0100_1110 (0x04EU)
#define B_000_0100_1111 (0x04FU)

#define B_000_0101_0000 (0x050U)
#define B_000_0101_0001 (0x051U)
#define B_000_0101_0010 (0x052U)
#define B_000_0101_0011 (0x053U)
#define B_000_0101_0100 (0x054U)
#define B_000_0101_0101 (0x055U)
#define B_000_0101_0110 (0x056U)
#define B_000_0101_0111 (0x057U)
#define B_000_0101_1000 (0x058U)
#define B_000_0101_1001 (0x059U)
#define B_000_0101_1010 (0x05AU)
#define B_000_0101_1011 (0x05BU)
#define B_000_0101_1100 (0x05CU)
#define B_000_0101_1101 (0x05DU)
#define B_000_0101_1110 (0x05EU)
#define B_000_0101_1111 (0x05FU)

#define B_000_0110_0000 (0x060U)
#define B_000_0110_0001 (0x061U)
#define B_000_0110_0010 (0x062U)
#define B_000_0110_0011 (0x063U)
#define B_000_0110_0100 (0x064U)
#define B_000_0110_0101 (0x065U)
#define B_000_0110_0110 (0x066U)
#define B_000_0110_0111 (0x067U)
#define B_000_0110_1000 (0x068U)
#define B_000_0110_1001 (0x069U)
#define B_000_0110_1010 (0x06AU)
#define B_000_0110_1011 (0x06BU)
#define B_000_0110_1100 (0x06CU)
#define B_000_0110_1101 (0x06DU)
#define B_000_0110_1110 (0x06EU)
#define B_000_0110_1111 (0x06FU)

#define B_000_0111_0000 (0x070U)
#define B_000_0111_0001 (0x071U)
#define B_000_0111_0010 (0x072U)
#define B_000_0111_0011 (0x073U)
#define B_000_0111_0100 (0x074U)
#define B_000_0111_0101 (0x075U)
#define B_000_0111_0110 (0x076U)
#define B_000_0111_0111 (0x077U)
#define B_000_0111_1000 (0x078U)
#define B_000_0111_1001 (0x079U)
#define B_000_0111_1010 (0x07AU)
#define B_000_0111_1011 (0x07BU)
#define B_000_0111_1100 (0x07CU)
#define B_000_0111_1101 (0x07DU)
#define B_000_0111_1110 (0x07EU)
#define B_000_0111_1111 (0x07FU)

#define B_000_1000_0000 (0x080U)
#define B_000_1000_0001 (0x081U)
#define B_000_1000_0010 (0x082U)
#define B_000_1000_0011 (0x083U)
#define B_000_1000_0100 (0x084U)
#define B_000_1000_0101 (0x085U)
#define B_000_1000_0110 (0x086U)
#define B_000_1000_0111 (0x087U)
#define B_000_1000_1000 (0x088U)
#define B_000_1000_1001 (0x089U)
#define B_000_1000_1010 (0x08AU)
#define B_000_1000_1011 (0x08BU)
#define B_000_1000_1100 (0x08CU)
#define B_000_1000_1101 (0x08DU)
#define B_000_1000_1110 (0x08EU)
#define B_000_1000_1111 (0x08FU)

#define B_000_1001_0000 (0x090U)
#define B_000_1001_0001 (0x091U)
#define B_000_1001_0010 (0x092U)
#define B_000_1001_0011 (0x093U)
#define B_000_1001_0100 (0x094U)
#define B_000_1001_0101 (0x095U)
#define B_000_1001_0110 (0x096U)
#define B_000_1001_0111 (0x097U)
#define B_000_1001_1000 (0x098U)
#define B_000_1001_1001 (0x099U)
#define B_000_1001_1010 (0x09AU)
#define B_000_1001_1011 (0x09BU)
#define B_000_1001_1100 (0x09CU)
#define B_000_1001_1101 (0x09DU)
#define B_000_1001_1110 (0x09EU)
#define B_000_1001_1111 (0x09FU)

#define B_000_1010_0000 (0x0A0U)
#define B_000_1010_0001 (0x0A1U)
#define B_000_1010_0010 (0x0A2U)
#define B_000_1010_0011 (0x0A3U)
#define B_000_1010_0100 (0x0A4U)
#define B_000_1010_0101 (0x0A5U)
#define B_000_1010_0110 (0x0A6U)
#define B_000_1010_0111 (0x0A7U)
#define B_000_1010_1000 (0x0A8U)
#define B_000_1010_1001 (0x0A9U)
#define B_000_1010_1010 (0x0AAU)
#define B_000_1010_1011 (0x0ABU)
#define B_000_1010_1100 (0x0ACU)
#define B_000_1010_1101 (0x0ADU)
#define B_000_1010_1110 (0x0AEU)
#define B_000_1010_1111 (0x0AFU)

#define B_000_1011_0000 (0x0B0U)
#define B_000_1011_0001 (0x0B1U)
#define B_000_1011_0010 (0x0B2U)
#define B_000_1011_0011 (0x0B3U)
#define B_000_1011_0100 (0x0B4U)
#define B_000_1011_0101 (0x0B5U)
#define B_000_1011_0110 (0x0B6U)
#define B_000_1011_0111 (0x0B7U)
#define B_000_1011_1000 (0x0B8U)
#define B_000_1011_1001 (0x0B9U)
#define B_000_1011_1010 (0x0BAU)
#define B_000_1011_1011 (0x0BBU)
#define B_000_1011_1100 (0x0BCU)
#define B_000_1011_1101 (0x0BDU)
#define B_000_1011_1110 (0x0BEU)
#define B_000_1011_1111 (0x0BFU)

#define B_000_1100_0000 (0x0C0U)
#define B_000_1100_0001 (0x0C1U)
#define B_000_1100_0010 (0x0C2U)
#define B_000_1100_0011 (0x0C3U)
#define B_000_1100_0100 (0x0C4U)
#define B_000_1100_0101 (0x0C5U)
#define B_000_1100_0110 (0x0C6U)
#define B_000_1100_0111 (0x0C7U)
#define B_000_1100_1000 (0x0C8U)
#define B_000_1100_1001 (0x0C9U)
#define B_000_1100_1010 (0x0CAU)
#define B_000_1100_1011 (0x0CBU)
#define B_000_1100_1100 (0x0CCU)
#define B_000_1100_1101 (0x0CDU)
#define B_000_1100_1110 (0x0CEU)
#define B_000_1100_1111 (0x0CFU)

#define B_000_1101_0000 (0x0D0U)
#define B_000_1101_0001 (0x0D1U)
#define B_000_1101_0010 (0x0D2U)
#define B_000_1101_0011 (0x0D3U)
#define B_000_1101_0100 (0x0D4U)
#define B_000_1101_0101 (0x0D5U)
#define B_000_1101_0110 (0x0D6U)
#define B_000_1101_0111 (0x0D7U)
#define B_000_1101_1000 (0x0D8U)
#define B_000_1101_1001 (0x0D9U)
#define B_000_1101_1010 (0x0DAU)
#define B_000_1101_1011 (0x0DBU)
#define B_000_1101_1100 (0x0DCU)
#define B_000_1101_1101 (0x0DDU)
#define B_000_1101_1110 (0x0DEU)
#define B_000_1101_1111 (0x0DFU)

#define B_000_1110_0000 (0x0E0U)
#define B_000_1110_0001 (0x0E1U)
#define B_000_1110_0010 (0x0E2U)
#define B_000_1110_0011 (0x0E3U)
#define B_000_1110_0100 (0x0E4U)
#define B_000_1110_0101 (0x0E5U)
#define B_000_1110_0110 (0x0E6U)
#define B_000_1110_0111 (0x0E7U)
#define B_000_1110_1000 (0x0E8U)
#define B_000_1110_1001 (0x0E9U)
#define B_000_1110_1010 (0x0EAU)
#define B_000_1110_1011 (0x0EBU)
#define B_000_1110_1100 (0x0ECU)
#define B_000_1110_1101 (0x0EDU)
#define B_000_1110_1110 (0x0EEU)
#define B_000_1110_1111 (0x0EFU)

#define B_000_1111_0000 (0x0F0U)
#define B_000_1111_0001 (0x0F1U)
#define B_000_1111_0010 (0x0F2U)
#define B_000_1111_0011 (0x0F3U)
#define B_000_1111_0100 (0x0F4U)
#define B_000_1111_0101 (0x0F5U)
#define B_000_1111_0110 (0x0F6U)
#define B_000_1111_0111 (0x0F7U)
#define B_000_1111_1000 (0x0F8U)
#define B_000_1111_1001 (0x0F9U)
#define B_000_1111_1010 (0x0FAU)
#define B_000_1111_1011 (0x0FBU)
#define B_000_1111_1100 (0x0FCU)
#define B_000_1111_1101 (0x0FDU)
#define B_000_1111_1110 (0x0FEU)
#define B_000_1111_1111 (0x0FFU)

#define B_001_0000_0000 (0x100U)
#define B_001_0000_0001 (0x101U)
#define B_001_0000_0010 (0x102U)
#define B_001_0000_0011 (0x103U)
#define B_001_0000_0100 (0x104U)
#define B_001_0000_0101 (0x105U)
#define B_001_0000_0110 (0x106U)
#define B_001_0000_0111 (0x107U)
#define B_001_0000_1000 (0x108U)
#define B_001_0000_1001 (0x109U)
#define B_001_0000_1010 (0x10AU)
#define B_001_0000_1011 (0x10BU)
#define B_001_0000_1100 (0x10CU)
#define B_001_0000_1101 (0x10DU)
#define B_001_0000_1110 (0x10EU)
#define B_001_0000_1111 (0x10FU)

#define B_001_0001_0000 (0x110U)
#define B_001_0001_0001 (0x111U)
#define B_001_0001_0010 (0x112U)
#define B_001_0001_0011 (0x113U)
#define B_001_0001_0100 (0x114U)
#define B_001_0001_0101 (0x115U)
#define B_001_0001_0110 (0x116U)
#define B_001_0001_0111 (0x117U)
#define B_001_0001_1000 (0x118U)
#define B_001_0001_1001 (0x119U)
#define B_001_0001_1010 (0x11AU)
#define B_001_0001_1011 (0x11BU)
#define B_001_0001_1100 (0x11CU)
#define B_001_0001_1101 (0x11DU)
#define B_001_0001_1110 (0x11EU)
#define B_001_0001_1111 (0x11FU)

#define B_001_0010_0000 (0x120U)
#define B_001_0010_0001 (0x121U)
#define B_001_0010_0010 (0x122U)
#define B_001_0010_0011 (0x123U)
#define B_001_0010_0100 (0x124U)
#define B_001_0010_0101 (0x125U)
#define B_001_0010_0110 (0x126U)
#define B_001_0010_0111 (0x127U)
#define B_001_0010_1000 (0x128U)
#define B_001_0010_1001 (0x129U)
#define B_001_0010_1010 (0x12AU)
#define B_001_0010_1011 (0x12BU)
#define B_001_0010_1100 (0x12CU)
#define B_001_0010_1101 (0x12DU)
#define B_001_0010_1110 (0x12EU)
#define B_001_0010_1111 (0x12FU)

#define B_001_0011_0000 (0x130U)
#define B_001_0011_0001 (0x131U)
#define B_001_0011_0010 (0x132U)
#define B_001_0011_0011 (0x133U)
#define B_001_0011_0100 (0x134U)
#define B_001_0011_0101 (0x135U)
#define B_001_0011_0110 (0x136U)
#define B_001_0011_0111 (0x137U)
#define B_001_0011_1000 (0x138U)
#define B_001_0011_1001 (0x139U)
#define B_001_0011_1010 (0x13AU)
#define B_001_0011_1011 (0x13BU)
#define B_001_0011_1100 (0x13CU)
#define B_001_0011_1101 (0x13DU)
#define B_001_0011_1110 (0x13EU)
#define B_001_0011_1111 (0x13FU)

#define B_001_0100_0000 (0x140U)
#define B_001_0100_0001 (0x141U)
#define B_001_0100_0010 (0x142U)
#define B_001_0100_0011 (0x143U)
#define B_001_0100_0100 (0x144U)
#define B_001_0100_0101 (0x145U)
#define B_001_0100_0110 (0x146U)
#define B_001_0100_0111 (0x147U)
#define B_001_0100_1000 (0x148U)
#define B_001_0100_1001 (0x149U)
#define B_001_0100_1010 (0x14AU)
#define B_001_0100_1011 (0x14BU)
#define B_001_0100_1100 (0x14CU)
#define B_001_0100_1101 (0x14DU)
#define B_001_0100_1110 (0x14EU)
#define B_001_0100_1111 (0x14FU)

#define B_001_0101_0000 (0x150U)
#define B_001_0101_0001 (0x151U)
#define B_001_0101_0010 (0x152U)
#define B_001_0101_0011 (0x153U)
#define B_001_0101_0100 (0x154U)
#define B_001_0101_0101 (0x155U)
#define B_001_0101_0110 (0x156U)
#define B_001_0101_0111 (0x157U)
#define B_001_0101_1000 (0x158U)
#define B_001_0101_1001 (0x159U)
#define B_001_0101_1010 (0x15AU)
#define B_001_0101_1011 (0x15BU)
#define B_001_0101_1100 (0x15CU)
#define B_001_0101_1101 (0x15DU)
#define B_001_0101_1110 (0x15EU)
#define B_001_0101_1111 (0x15FU)

#define B_001_0110_0000 (0x160U)
#define B_001_0110_0001 (0x161U)
#define B_001_0110_0010 (0x162U)
#define B_001_0110_0011 (0x163U)
#define B_001_0110_0100 (0x164U)
#define B_001_0110_0101 (0x165U)
#define B_001_0110_0110 (0x166U)
#define B_001_0110_0111 (0x167U)
#define B_001_0110_1000 (0x168U)
#define B_001_0110_1001 (0x169U)
#define B_001_0110_1010 (0x16AU)
#define B_001_0110_1011 (0x16BU)
#define B_001_0110_1100 (0x16CU)
#define B_001_0110_1101 (0x16DU)
#define B_001_0110_1110 (0x16EU)
#define B_001_0110_1111 (0x16FU)

#define B_001_0111_0000 (0x170U)
#define B_001_0111_0001 (0x171U)
#define B_001_0111_0010 (0x172U)
#define B_001_0111_0011 (0x173U)
#define B_001_0111_0100 (0x174U)
#define B_001_0111_0101 (0x175U)
#define B_001_0111_0110 (0x176U)
#define B_001_0111_0111 (0x177U)
#define B_001_0111_1000 (0x178U)
#define B_001_0111_1001 (0x179U)
#define B_001_0111_1010 (0x17AU)
#define B_001_0111_1011 (0x17BU)
#define B_001_0111_1100 (0x17CU)
#define B_001_0111_1101 (0x17DU)
#define B_001_0111_1110 (0x17EU)
#define B_001_0111_1111 (0x17FU)

#define B_001_1000_0000 (0x180U)
#define B_001_1000_0001 (0x181U)
#define B_001_1000_0010 (0x182U)
#define B_001_1000_0011 (0x183U)
#define B_001_1000_0100 (0x184U)
#define B_001_1000_0101 (0x185U)
#define B_001_1000_0110 (0x186U)
#define B_001_1000_0111 (0x187U)
#define B_001_1000_1000 (0x188U)
#define B_001_1000_1001 (0x189U)
#define B_001_1000_1010 (0x18AU)
#define B_001_1000_1011 (0x18BU)
#define B_001_1000_1100 (0x18CU)
#define B_001_1000_1101 (0x18DU)
#define B_001_1000_1110 (0x18EU)
#define B_001_1000_1111 (0x18FU)

#define B_001_1001_0000 (0x190U)
#define B_001_1001_0001 (0x191U)
#define B_001_1001_0010 (0x192U)
#define B_001_1001_0011 (0x193U)
#define B_001_1001_0100 (0x194U)
#define B_001_1001_0101 (0x195U)
#define B_001_1001_0110 (0x196U)
#define B_001_1001_0111 (0x197U)
#define B_001_1001_1000 (0x198U)
#define B_001_1001_1001 (0x199U)
#define B_001_1001_1010 (0x19AU)
#define B_001_1001_1011 (0x19BU)
#define B_001_1001_1100 (0x19CU)
#define B_001_1001_1101 (0x19DU)
#define B_001_1001_1110 (0x19EU)
#define B_001_1001_1111 (0x19FU)

#define B_001_1010_0000 (0x1A0U)
#define B_001_1010_0001 (0x1A1U)
#define B_001_1010_0010 (0x1A2U)
#define B_001_1010_0011 (0x1A3U)
#define B_001_1010_0100 (0x1A4U)
#define B_001_1010_0101 (0x1A5U)
#define B_001_1010_0110 (0x1A6U)
#define B_001_1010_0111 (0x1A7U)
#define B_001_1010_1000 (0x1A8U)
#define B_001_1010_1001 (0x1A9U)
#define B_001_1010_1010 (0x1AAU)
#define B_001_1010_1011 (0x1ABU)
#define B_001_1010_1100 (0x1ACU)
#define B_001_1010_1101 (0x1ADU)
#define B_001_1010_1110 (0x1AEU)
#define B_001_1010_1111 (0x1AFU)

#define B_001_1011_0000 (0x1B0U)
#define B_001_1011_0001 (0x1B1U)
#define B_001_1011_0010 (0x1B2U)
#define B_001_1011_0011 (0x1B3U)
#define B_001_1011_0100 (0x1B4U)
#define B_001_1011_0101 (0x1B5U)
#define B_001_1011_0110 (0x1B6U)
#define B_001_1011_0111 (0x1B7U)
#define B_001_1011_1000 (0x1B8U)
#define B_001_1011_1001 (0x1B9U)
#define B_001_1011_1010 (0x1BAU)
#define B_001_1011_1011 (0x1BBU)
#define B_001_1011_1100 (0x1BCU)
#define B_001_1011_1101 (0x1BDU)
#define B_001_1011_1110 (0x1BEU)
#define B_001_1011_1111 (0x1BFU)

#define B_001_1100_0000 (0x1C0U)
#define B_001_1100_0001 (0x1C1U)
#define B_001_1100_0010 (0x1C2U)
#define B_001_1100_0011 (0x1C3U)
#define B_001_1100_0100 (0x1C4U)
#define B_001_1100_0101 (0x1C5U)
#define B_001_1100_0110 (0x1C6U)
#define B_001_1100_0111 (0x1C7U)
#define B_001_1100_1000 (0x1C8U)
#define B_001_1100_1001 (0x1C9U)
#define B_001_1100_1010 (0x1CAU)
#define B_001_1100_1011 (0x1CBU)
#define B_001_1100_1100 (0x1CCU)
#define B_001_1100_1101 (0x1CDU)
#define B_001_1100_1110 (0x1CEU)
#define B_001_1100_1111 (0x1CFU)

#define B_001_1101_0000 (0x1D0U)
#define B_001_1101_0001 (0x1D1U)
#define B_001_1101_0010 (0x1D2U)
#define B_001_1101_0011 (0x1D3U)
#define B_001_1101_0100 (0x1D4U)
#define B_001_1101_0101 (0x1D5U)
#define B_001_1101_0110 (0x1D6U)
#define B_001_1101_0111 (0x1D7U)
#define B_001_1101_1000 (0x1D8U)
#define B_001_1101_1001 (0x1D9U)
#define B_001_1101_1010 (0x1DAU)
#define B_001_1101_1011 (0x1DBU)
#define B_001_1101_1100 (0x1DCU)
#define B_001_1101_1101 (0x1DDU)
#define B_001_1101_1110 (0x1DEU)
#define B_001_1101_1111 (0x1DFU)

#define B_001_1110_0000 (0x1E0U)
#define B_001_1110_0001 (0x1E1U)
#define B_001_1110_0010 (0x1E2U)
#define B_001_1110_0011 (0x1E3U)
#define B_001_1110_0100 (0x1E4U)
#define B_001_1110_0101 (0x1E5U)
#define B_001_1110_0110 (0x1E6U)
#define B_001_1110_0111 (0x1E7U)
#define B_001_1110_1000 (0x1E8U)
#define B_001_1110_1001 (0x1E9U)
#define B_001_1110_1010 (0x1EAU)
#define B_001_1110_1011 (0x1EBU)
#define B_001_1110_1100 (0x1ECU)
#define B_001_1110_1101 (0x1EDU)
#define B_001_1110_1110 (0x1EEU)
#define B_001_1110_1111 (0x1EFU)

#define B_001_1111_0000 (0x1F0U)
#define B_001_1111_0001 (0x1F1U)
#define B_001_1111_0010 (0x1F2U)
#define B_001_1111_0011 (0x1F3U)
#define B_001_1111_0100 (0x1F4U)
#define B_001_1111_0101 (0x1F5U)
#define B_001_1111_0110 (0x1F6U)
#define B_001_1111_0111 (0x1F7U)
#define B_001_1111_1000 (0x1F8U)
#define B_001_1111_1001 (0x1F9U)
#define B_001_1111_1010 (0x1FAU)
#define B_001_1111_1011 (0x1FBU)
#define B_001_1111_1100 (0x1FCU)
#define B_001_1111_1101 (0x1FDU)
#define B_001_1111_1110 (0x1FEU)
#define B_001_1111_1111 (0x1FFU)

#define B_010_0000_0000 (0x200U)
#define B_010_0000_0001 (0x201U)
#define B_010_0000_0010 (0x202U)
#define B_010_0000_0011 (0x203U)
#define B_010_0000_0100 (0x204U)
#define B_010_0000_0101 (0x205U)
#define B_010_0000_0110 (0x206U)
#define B_010_0000_0111 (0x207U)
#define B_010_0000_1000 (0x208U)
#define B_010_0000_1001 (0x209U)
#define B_010_0000_1010 (0x20AU)
#define B_010_0000_1011 (0x20BU)
#define B_010_0000_1100 (0x20CU)
#define B_010_0000_1101 (0x20DU)
#define B_010_0000_1110 (0x20EU)
#define B_010_0000_1111 (0x20FU)

#define B_010_0001_0000 (0x210U)
#define B_010_0001_0001 (0x211U)
#define B_010_0001_0010 (0x212U)
#define B_010_0001_0011 (0x213U)
#define B_010_0001_0100 (0x214U)
#define B_010_0001_0101 (0x215U)
#define B_010_0001_0110 (0x216U)
#define B_010_0001_0111 (0x217U)
#define B_010_0001_1000 (0x218U)
#define B_010_0001_1001 (0x219U)
#define B_010_0001_1010 (0x21AU)
#define B_010_0001_1011 (0x21BU)
#define B_010_0001_1100 (0x21CU)
#define B_010_0001_1101 (0x21DU)
#define B_010_0001_1110 (0x21EU)
#define B_010_0001_1111 (0x21FU)

#define B_010_0010_0000 (0x220U)
#define B_010_0010_0001 (0x221U)
#define B_010_0010_0010 (0x222U)
#define B_010_0010_0011 (0x223U)
#define B_010_0010_0100 (0x224U)
#define B_010_0010_0101 (0x225U)
#define B_010_0010_0110 (0x226U)
#define B_010_0010_0111 (0x227U)
#define B_010_0010_1000 (0x228U)
#define B_010_0010_1001 (0x229U)
#define B_010_0010_1010 (0x22AU)
#define B_010_0010_1011 (0x22BU)
#define B_010_0010_1100 (0x22CU)
#define B_010_0010_1101 (0x22DU)
#define B_010_0010_1110 (0x22EU)
#define B_010_0010_1111 (0x22FU)

#define B_010_0011_0000 (0x230U)
#define B_010_0011_0001 (0x231U)
#define B_010_0011_0010 (0x232U)
#define B_010_0011_0011 (0x233U)
#define B_010_0011_0100 (0x234U)
#define B_010_0011_0101 (0x235U)
#define B_010_0011_0110 (0x236U)
#define B_010_0011_0111 (0x237U)
#define B_010_0011_1000 (0x238U)
#define B_010_0011_1001 (0x239U)
#define B_010_0011_1010 (0x23AU)
#define B_010_0011_1011 (0x23BU)
#define B_010_0011_1100 (0x23CU)
#define B_010_0011_1101 (0x23DU)
#define B_010_0011_1110 (0x23EU)
#define B_010_0011_1111 (0x23FU)

#define B_010_0100_0000 (0x240U)
#define B_010_0100_0001 (0x241U)
#define B_010_0100_0010 (0x242U)
#define B_010_0100_0011 (0x243U)
#define B_010_0100_0100 (0x244U)
#define B_010_0100_0101 (0x245U)
#define B_010_0100_0110 (0x246U)
#define B_010_0100_0111 (0x247U)
#define B_010_0100_1000 (0x248U)
#define B_010_0100_1001 (0x249U)
#define B_010_0100_1010 (0x24AU)
#define B_010_0100_1011 (0x24BU)
#define B_010_0100_1100 (0x24CU)
#define B_010_0100_1101 (0x24DU)
#define B_010_0100_1110 (0x24EU)
#define B_010_0100_1111 (0x24FU)

#define B_010_0101_0000 (0x250U)
#define B_010_0101_0001 (0x251U)
#define B_010_0101_0010 (0x252U)
#define B_010_0101_0011 (0x253U)
#define B_010_0101_0100 (0x254U)
#define B_010_0101_0101 (0x255U)
#define B_010_0101_0110 (0x256U)
#define B_010_0101_0111 (0x257U)
#define B_010_0101_1000 (0x258U)
#define B_010_0101_1001 (0x259U)
#define B_010_0101_1010 (0x25AU)
#define B_010_0101_1011 (0x25BU)
#define B_010_0101_1100 (0x25CU)
#define B_010_0101_1101 (0x25DU)
#define B_010_0101_1110 (0x25EU)
#define B_010_0101_1111 (0x25FU)

#define B_010_0110_0000 (0x260U)
#define B_010_0110_0001 (0x261U)
#define B_010_0110_0010 (0x262U)
#define B_010_0110_0011 (0x263U)
#define B_010_0110_0100 (0x264U)
#define B_010_0110_0101 (0x265U)
#define B_010_0110_0110 (0x266U)
#define B_010_0110_0111 (0x267U)
#define B_010_0110_1000 (0x268U)
#define B_010_0110_1001 (0x269U)
#define B_010_0110_1010 (0x26AU)
#define B_010_0110_1011 (0x26BU)
#define B_010_0110_1100 (0x26CU)
#define B_010_0110_1101 (0x26DU)
#define B_010_0110_1110 (0x26EU)
#define B_010_0110_1111 (0x26FU)

#define B_010_0111_0000 (0x270U)
#define B_010_0111_0001 (0x271U)
#define B_010_0111_0010 (0x272U)
#define B_010_0111_0011 (0x273U)
#define B_010_0111_0100 (0x274U)
#define B_010_0111_0101 (0x275U)
#define B_010_0111_0110 (0x276U)
#define B_010_0111_0111 (0x277U)
#define B_010_0111_1000 (0x278U)
#define B_010_0111_1001 (0x279U)
#define B_010_0111_1010 (0x27AU)
#define B_010_0111_1011 (0x27BU)
#define B_010_0111_1100 (0x27CU)
#define B_010_0111_1101 (0x27DU)
#define B_010_0111_1110 (0x27EU)
#define B_010_0111_1111 (0x27FU)

#define B_010_1000_0000 (0x280U)
#define B_010_1000_0001 (0x281U)
#define B_010_1000_0010 (0x282U)
#define B_010_1000_0011 (0x283U)
#define B_010_1000_0100 (0x284U)
#define B_010_1000_0101 (0x285U)
#define B_010_1000_0110 (0x286U)
#define B_010_1000_0111 (0x287U)
#define B_010_1000_1000 (0x288U)
#define B_010_1000_1001 (0x289U)
#define B_010_1000_1010 (0x28AU)
#define B_010_1000_1011 (0x28BU)
#define B_010_1000_1100 (0x28CU)
#define B_010_1000_1101 (0x28DU)
#define B_010_1000_1110 (0x28EU)
#define B_010_1000_1111 (0x28FU)

#define B_010_1001_0000 (0x290U)
#define B_010_1001_0001 (0x291U)
#define B_010_1001_0010 (0x292U)
#define B_010_1001_0011 (0x293U)
#define B_010_1001_0100 (0x294U)
#define B_010_1001_0101 (0x295U)
#define B_010_1001_0110 (0x296U)
#define B_010_1001_0111 (0x297U)
#define B_010_1001_1000 (0x298U)
#define B_010_1001_1001 (0x299U)
#define B_010_1001_1010 (0x29AU)
#define B_010_1001_1011 (0x29BU)
#define B_010_1001_1100 (0x29CU)
#define B_010_1001_1101 (0x29DU)
#define B_010_1001_1110 (0x29EU)
#define B_010_1001_1111 (0x29FU)

#define B_010_1010_0000 (0x2A0U)
#define B_010_1010_0001 (0x2A1U)
#define B_010_1010_0010 (0x2A2U)
#define B_010_1010_0011 (0x2A3U)
#define B_010_1010_0100 (0x2A4U)
#define B_010_1010_0101 (0x2A5U)
#define B_010_1010_0110 (0x2A6U)
#define B_010_1010_0111 (0x2A7U)
#define B_010_1010_1000 (0x2A8U)
#define B_010_1010_1001 (0x2A9U)
#define B_010_1010_1010 (0x2AAU)
#define B_010_1010_1011 (0x2ABU)
#define B_010_1010_1100 (0x2ACU)
#define B_010_1010_1101 (0x2ADU)
#define B_010_1010_1110 (0x2AEU)
#define B_010_1010_1111 (0x2AFU)

#define B_010_1011_0000 (0x2B0U)
#define B_010_1011_0001 (0x2B1U)
#define B_010_1011_0010 (0x2B2U)
#define B_010_1011_0011 (0x2B3U)
#define B_010_1011_0100 (0x2B4U)
#define B_010_1011_0101 (0x2B5U)
#define B_010_1011_0110 (0x2B6U)
#define B_010_1011_0111 (0x2B7U)
#define B_010_1011_1000 (0x2B8U)
#define B_010_1011_1001 (0x2B9U)
#define B_010_1011_1010 (0x2BAU)
#define B_010_1011_1011 (0x2BBU)
#define B_010_1011_1100 (0x2BCU)
#define B_010_1011_1101 (0x2BDU)
#define B_010_1011_1110 (0x2BEU)
#define B_010_1011_1111 (0x2BFU)

#define B_010_1100_0000 (0x2C0U)
#define B_010_1100_0001 (0x2C1U)
#define B_010_1100_0010 (0x2C2U)
#define B_010_1100_0011 (0x2C3U)
#define B_010_1100_0100 (0x2C4U)
#define B_010_1100_0101 (0x2C5U)
#define B_010_1100_0110 (0x2C6U)
#define B_010_1100_0111 (0x2C7U)
#define B_010_1100_1000 (0x2C8U)
#define B_010_1100_1001 (0x2C9U)
#define B_010_1100_1010 (0x2CAU)
#define B_010_1100_1011 (0x2CBU)
#define B_010_1100_1100 (0x2CCU)
#define B_010_1100_1101 (0x2CDU)
#define B_010_1100_1110 (0x2CEU)
#define B_010_1100_1111 (0x2CFU)

#define B_010_1101_0000 (0x2D0U)
#define B_010_1101_0001 (0x2D1U)
#define B_010_1101_0010 (0x2D2U)
#define B_010_1101_0011 (0x2D3U)
#define B_010_1101_0100 (0x2D4U)
#define B_010_1101_0101 (0x2D5U)
#define B_010_1101_0110 (0x2D6U)
#define B_010_1101_0111 (0x2D7U)
#define B_010_1101_1000 (0x2D8U)
#define B_010_1101_1001 (0x2D9U)
#define B_010_1101_1010 (0x2DAU)
#define B_010_1101_1011 (0x2DBU)
#define B_010_1101_1100 (0x2DCU)
#define B_010_1101_1101 (0x2DDU)
#define B_010_1101_1110 (0x2DEU)
#define B_010_1101_1111 (0x2DFU)

#define B_010_1110_0000 (0x2E0U)
#define B_010_1110_0001 (0x2E1U)
#define B_010_1110_0010 (0x2E2U)
#define B_010_1110_0011 (0x2E3U)
#define B_010_1110_0100 (0x2E4U)
#define B_010_1110_0101 (0x2E5U)
#define B_010_1110_0110 (0x2E6U)
#define B_010_1110_0111 (0x2E7U)
#define B_010_1110_1000 (0x2E8U)
#define B_010_1110_1001 (0x2E9U)
#define B_010_1110_1010 (0x2EAU)
#define B_010_1110_1011 (0x2EBU)
#define B_010_1110_1100 (0x2ECU)
#define B_010_1110_1101 (0x2EDU)
#define B_010_1110_1110 (0x2EEU)
#define B_010_1110_1111 (0x2EFU)

#define B_010_1111_0000 (0x2F0U)
#define B_010_1111_0001 (0x2F1U)
#define B_010_1111_0010 (0x2F2U)
#define B_010_1111_0011 (0x2F3U)
#define B_010_1111_0100 (0x2F4U)
#define B_010_1111_0101 (0x2F5U)
#define B_010_1111_0110 (0x2F6U)
#define B_010_1111_0111 (0x2F7U)
#define B_010_1111_1000 (0x2F8U)
#define B_010_1111_1001 (0x2F9U)
#define B_010_1111_1010 (0x2FAU)
#define B_010_1111_1011 (0x2FBU)
#define B_010_1111_1100 (0x2FCU)
#define B_010_1111_1101 (0x2FDU)
#define B_010_1111_1110 (0x2FEU)
#define B_010_1111_1111 (0x2FFU)

#define B_011_0000_0000 (0x300U)
#define B_011_0000_0001 (0x301U)
#define B_011_0000_0010 (0x302U)
#define B_011_0000_0011 (0x303U)
#define B_011_0000_0100 (0x304U)
#define B_011_0000_0101 (0x305U)
#define B_011_0000_0110 (0x306U)
#define B_011_0000_0111 (0x307U)
#define B_011_0000_1000 (0x308U)
#define B_011_0000_1001 (0x309U)
#define B_011_0000_1010 (0x30AU)
#define B_011_0000_1011 (0x30BU)
#define B_011_0000_1100 (0x30CU)
#define B_011_0000_1101 (0x30DU)
#define B_011_0000_1110 (0x30EU)
#define B_011_0000_1111 (0x30FU)

#define B_011_0001_0000 (0x310U)
#define B_011_0001_0001 (0x311U)
#define B_011_0001_0010 (0x312U)
#define B_011_0001_0011 (0x313U)
#define B_011_0001_0100 (0x314U)
#define B_011_0001_0101 (0x315U)
#define B_011_0001_0110 (0x316U)
#define B_011_0001_0111 (0x317U)
#define B_011_0001_1000 (0x318U)
#define B_011_0001_1001 (0x319U)
#define B_011_0001_1010 (0x31AU)
#define B_011_0001_1011 (0x31BU)
#define B_011_0001_1100 (0x31CU)
#define B_011_0001_1101 (0x31DU)
#define B_011_0001_1110 (0x31EU)
#define B_011_0001_1111 (0x31FU)

#define B_011_0010_0000 (0x320U)
#define B_011_0010_0001 (0x321U)
#define B_011_0010_0010 (0x322U)
#define B_011_0010_0011 (0x323U)
#define B_011_0010_0100 (0x324U)
#define B_011_0010_0101 (0x325U)
#define B_011_0010_0110 (0x326U)
#define B_011_0010_0111 (0x327U)
#define B_011_0010_1000 (0x328U)
#define B_011_0010_1001 (0x329U)
#define B_011_0010_1010 (0x32AU)
#define B_011_0010_1011 (0x32BU)
#define B_011_0010_1100 (0x32CU)
#define B_011_0010_1101 (0x32DU)
#define B_011_0010_1110 (0x32EU)
#define B_011_0010_1111 (0x32FU)

#define B_011_0011_0000 (0x330U)
#define B_011_0011_0001 (0x331U)
#define B_011_0011_0010 (0x332U)
#define B_011_0011_0011 (0x333U)
#define B_011_0011_0100 (0x334U)
#define B_011_0011_0101 (0x335U)
#define B_011_0011_0110 (0x336U)
#define B_011_0011_0111 (0x337U)
#define B_011_0011_1000 (0x338U)
#define B_011_0011_1001 (0x339U)
#define B_011_0011_1010 (0x33AU)
#define B_011_0011_1011 (0x33BU)
#define B_011_0011_1100 (0x33CU)
#define B_011_0011_1101 (0x33DU)
#define B_011_0011_1110 (0x33EU)
#define B_011_0011_1111 (0x33FU)

#define B_011_0100_0000 (0x340U)
#define B_011_0100_0001 (0x341U)
#define B_011_0100_0010 (0x342U)
#define B_011_0100_0011 (0x343U)
#define B_011_0100_0100 (0x344U)
#define B_011_0100_0101 (0x345U)
#define B_011_0100_0110 (0x346U)
#define B_011_0100_0111 (0x347U)
#define B_011_0100_1000 (0x348U)
#define B_011_0100_1001 (0x349U)
#define B_011_0100_1010 (0x34AU)
#define B_011_0100_1011 (0x34BU)
#define B_011_0100_1100 (0x34CU)
#define B_011_0100_1101 (0x34DU)
#define B_011_0100_1110 (0x34EU)
#define B_011_0100_1111 (0x34FU)

#define B_011_0101_0000 (0x350U)
#define B_011_0101_0001 (0x351U)
#define B_011_0101_0010 (0x352U)
#define B_011_0101_0011 (0x353U)
#define B_011_0101_0100 (0x354U)
#define B_011_0101_0101 (0x355U)
#define B_011_0101_0110 (0x356U)
#define B_011_0101_0111 (0x357U)
#define B_011_0101_1000 (0x358U)
#define B_011_0101_1001 (0x359U)
#define B_011_0101_1010 (0x35AU)
#define B_011_0101_1011 (0x35BU)
#define B_011_0101_1100 (0x35CU)
#define B_011_0101_1101 (0x35DU)
#define B_011_0101_1110 (0x35EU)
#define B_011_0101_1111 (0x35FU)

#define B_011_0110_0000 (0x360U)
#define B_011_0110_0001 (0x361U)
#define B_011_0110_0010 (0x362U)
#define B_011_0110_0011 (0x363U)
#define B_011_0110_0100 (0x364U)
#define B_011_0110_0101 (0x365U)
#define B_011_0110_0110 (0x366U)
#define B_011_0110_0111 (0x367U)
#define B_011_0110_1000 (0x368U)
#define B_011_0110_1001 (0x369U)
#define B_011_0110_1010 (0x36AU)
#define B_011_0110_1011 (0x36BU)
#define B_011_0110_1100 (0x36CU)
#define B_011_0110_1101 (0x36DU)
#define B_011_0110_1110 (0x36EU)
#define B_011_0110_1111 (0x36FU)

#define B_011_0111_0000 (0x370U)
#define B_011_0111_0001 (0x371U)
#define B_011_0111_0010 (0x372U)
#define B_011_0111_0011 (0x373U)
#define B_011_0111_0100 (0x374U)
#define B_011_0111_0101 (0x375U)
#define B_011_0111_0110 (0x376U)
#define B_011_0111_0111 (0x377U)
#define B_011_0111_1000 (0x378U)
#define B_011_0111_1001 (0x379U)
#define B_011_0111_1010 (0x37AU)
#define B_011_0111_1011 (0x37BU)
#define B_011_0111_1100 (0x37CU)
#define B_011_0111_1101 (0x37DU)
#define B_011_0111_1110 (0x37EU)
#define B_011_0111_1111 (0x37FU)

#define B_011_1000_0000 (0x380U)
#define B_011_1000_0001 (0x381U)
#define B_011_1000_0010 (0x382U)
#define B_011_1000_0011 (0x383U)
#define B_011_1000_0100 (0x384U)
#define B_011_1000_0101 (0x385U)
#define B_011_1000_0110 (0x386U)
#define B_011_1000_0111 (0x387U)
#define B_011_1000_1000 (0x388U)
#define B_011_1000_1001 (0x389U)
#define B_011_1000_1010 (0x38AU)
#define B_011_1000_1011 (0x38BU)
#define B_011_1000_1100 (0x38CU)
#define B_011_1000_1101 (0x38DU)
#define B_011_1000_1110 (0x38EU)
#define B_011_1000_1111 (0x38FU)

#define B_011_1001_0000 (0x390U)
#define B_011_1001_0001 (0x391U)
#define B_011_1001_0010 (0x392U)
#define B_011_1001_0011 (0x393U)
#define B_011_1001_0100 (0x394U)
#define B_011_1001_0101 (0x395U)
#define B_011_1001_0110 (0x396U)
#define B_011_1001_0111 (0x397U)
#define B_011_1001_1000 (0x398U)
#define B_011_1001_1001 (0x399U)
#define B_011_1001_1010 (0x39AU)
#define B_011_1001_1011 (0x39BU)
#define B_011_1001_1100 (0x39CU)
#define B_011_1001_1101 (0x39DU)
#define B_011_1001_1110 (0x39EU)
#define B_011_1001_1111 (0x39FU)

#define B_011_1010_0000 (0x3A0U)
#define B_011_1010_0001 (0x3A1U)
#define B_011_1010_0010 (0x3A2U)
#define B_011_1010_0011 (0x3A3U)
#define B_011_1010_0100 (0x3A4U)
#define B_011_1010_0101 (0x3A5U)
#define B_011_1010_0110 (0x3A6U)
#define B_011_1010_0111 (0x3A7U)
#define B_011_1010_1000 (0x3A8U)
#define B_011_1010_1001 (0x3A9U)
#define B_011_1010_1010 (0x3AAU)
#define B_011_1010_1011 (0x3ABU)
#define B_011_1010_1100 (0x3ACU)
#define B_011_1010_1101 (0x3ADU)
#define B_011_1010_1110 (0x3AEU)
#define B_011_1010_1111 (0x3AFU)

#define B_011_1011_0000 (0x3B0U)
#define B_011_1011_0001 (0x3B1U)
#define B_011_1011_0010 (0x3B2U)
#define B_011_1011_0011 (0x3B3U)
#define B_011_1011_0100 (0x3B4U)
#define B_011_1011_0101 (0x3B5U)
#define B_011_1011_0110 (0x3B6U)
#define B_011_1011_0111 (0x3B7U)
#define B_011_1011_1000 (0x3B8U)
#define B_011_1011_1001 (0x3B9U)
#define B_011_1011_1010 (0x3BAU)
#define B_011_1011_1011 (0x3BBU)
#define B_011_1011_1100 (0x3BCU)
#define B_011_1011_1101 (0x3BDU)
#define B_011_1011_1110 (0x3BEU)
#define B_011_1011_1111 (0x3BFU)

#define B_011_1100_0000 (0x3C0U)
#define B_011_1100_0001 (0x3C1U)
#define B_011_1100_0010 (0x3C2U)
#define B_011_1100_0011 (0x3C3U)
#define B_011_1100_0100 (0x3C4U)
#define B_011_1100_0101 (0x3C5U)
#define B_011_1100_0110 (0x3C6U)
#define B_011_1100_0111 (0x3C7U)
#define B_011_1100_1000 (0x3C8U)
#define B_011_1100_1001 (0x3C9U)
#define B_011_1100_1010 (0x3CAU)
#define B_011_1100_1011 (0x3CBU)
#define B_011_1100_1100 (0x3CCU)
#define B_011_1100_1101 (0x3CDU)
#define B_011_1100_1110 (0x3CEU)
#define B_011_1100_1111 (0x3CFU)

#define B_011_1101_0000 (0x3D0U)
#define B_011_1101_0001 (0x3D1U)
#define B_011_1101_0010 (0x3D2U)
#define B_011_1101_0011 (0x3D3U)
#define B_011_1101_0100 (0x3D4U)
#define B_011_1101_0101 (0x3D5U)
#define B_011_1101_0110 (0x3D6U)
#define B_011_1101_0111 (0x3D7U)
#define B_011_1101_1000 (0x3D8U)
#define B_011_1101_1001 (0x3D9U)
#define B_011_1101_1010 (0x3DAU)
#define B_011_1101_1011 (0x3DBU)
#define B_011_1101_1100 (0x3DCU)
#define B_011_1101_1101 (0x3DDU)
#define B_011_1101_1110 (0x3DEU)
#define B_011_1101_1111 (0x3DFU)

#define B_011_1110_0000 (0x3E0U)
#define B_011_1110_0001 (0x3E1U)
#define B_011_1110_0010 (0x3E2U)
#define B_011_1110_0011 (0x3E3U)
#define B_011_1110_0100 (0x3E4U)
#define B_011_1110_0101 (0x3E5U)
#define B_011_1110_0110 (0x3E6U)
#define B_011_1110_0111 (0x3E7U)
#define B_011_1110_1000 (0x3E8U)
#define B_011_1110_1001 (0x3E9U)
#define B_011_1110_1010 (0x3EAU)
#define B_011_1110_1011 (0x3EBU)
#define B_011_1110_1100 (0x3ECU)
#define B_011_1110_1101 (0x3EDU)
#define B_011_1110_1110 (0x3EEU)
#define B_011_1110_1111 (0x3EFU)

#define B_011_1111_0000 (0x3F0U)
#define B_011_1111_0001 (0x3F1U)
#define B_011_1111_0010 (0x3F2U)
#define B_011_1111_0011 (0x3F3U)
#define B_011_1111_0100 (0x3F4U)
#define B_011_1111_0101 (0x3F5U)
#define B_011_1111_0110 (0x3F6U)
#define B_011_1111_0111 (0x3F7U)
#define B_011_1111_1000 (0x3F8U)
#define B_011_1111_1001 (0x3F9U)
#define B_011_1111_1010 (0x3FAU)
#define B_011_1111_1011 (0x3FBU)
#define B_011_1111_1100 (0x3FCU)
#define B_011_1111_1101 (0x3FDU)
#define B_011_1111_1110 (0x3FEU)
#define B_011_1111_1111 (0x3FFU)

#define B_100_0000_0000 (0x400U)
#define B_100_0000_0001 (0x401U)
#define B_100_0000_0010 (0x402U)
#define B_100_0000_0011 (0x403U)
#define B_100_0000_0100 (0x404U)
#define B_100_0000_0101 (0x405U)
#define B_100_0000_0110 (0x406U)
#define B_100_0000_0111 (0x407U)
#define B_100_0000_1000 (0x408U)
#define B_100_0000_1001 (0x409U)
#define B_100_0000_1010 (0x40AU)
#define B_100_0000_1011 (0x40BU)
#define B_100_0000_1100 (0x40CU)
#define B_100_0000_1101 (0x40DU)
#define B_100_0000_1110 (0x40EU)
#define B_100_0000_1111 (0x40FU)

#define B_100_0001_0000 (0x410U)
#define B_100_0001_0001 (0x411U)
#define B_100_0001_0010 (0x412U)
#define B_100_0001_0011 (0x413U)
#define B_100_0001_0100 (0x414U)
#define B_100_0001_0101 (0x415U)
#define B_100_0001_0110 (0x416U)
#define B_100_0001_0111 (0x417U)
#define B_100_0001_1000 (0x418U)
#define B_100_0001_1001 (0x419U)
#define B_100_0001_1010 (0x41AU)
#define B_100_0001_1011 (0x41BU)
#define B_100_0001_1100 (0x41CU)
#define B_100_0001_1101 (0x41DU)
#define B_100_0001_1110 (0x41EU)
#define B_100_0001_1111 (0x41FU)

#define B_100_0010_0000 (0x420U)
#define B_100_0010_0001 (0x421U)
#define B_100_0010_0010 (0x422U)
#define B_100_0010_0011 (0x423U)
#define B_100_0010_0100 (0x424U)
#define B_100_0010_0101 (0x425U)
#define B_100_0010_0110 (0x426U)
#define B_100_0010_0111 (0x427U)
#define B_100_0010_1000 (0x428U)
#define B_100_0010_1001 (0x429U)
#define B_100_0010_1010 (0x42AU)
#define B_100_0010_1011 (0x42BU)
#define B_100_0010_1100 (0x42CU)
#define B_100_0010_1101 (0x42DU)
#define B_100_0010_1110 (0x42EU)
#define B_100_0010_1111 (0x42FU)

#define B_100_0011_0000 (0x430U)
#define B_100_0011_0001 (0x431U)
#define B_100_0011_0010 (0x432U)
#define B_100_0011_0011 (0x433U)
#define B_100_0011_0100 (0x434U)
#define B_100_0011_0101 (0x435U)
#define B_100_0011_0110 (0x436U)
#define B_100_0011_0111 (0x437U)
#define B_100_0011_1000 (0x438U)
#define B_100_0011_1001 (0x439U)
#define B_100_0011_1010 (0x43AU)
#define B_100_0011_1011 (0x43BU)
#define B_100_0011_1100 (0x43CU)
#define B_100_0011_1101 (0x43DU)
#define B_100_0011_1110 (0x43EU)
#define B_100_0011_1111 (0x43FU)

#define B_100_0100_0000 (0x440U)
#define B_100_0100_0001 (0x441U)
#define B_100_0100_0010 (0x442U)
#define B_100_0100_0011 (0x443U)
#define B_100_0100_0100 (0x444U)
#define B_100_0100_0101 (0x445U)
#define B_100_0100_0110 (0x446U)
#define B_100_0100_0111 (0x447U)
#define B_100_0100_1000 (0x448U)
#define B_100_0100_1001 (0x449U)
#define B_100_0100_1010 (0x44AU)
#define B_100_0100_1011 (0x44BU)
#define B_100_0100_1100 (0x44CU)
#define B_100_0100_1101 (0x44DU)
#define B_100_0100_1110 (0x44EU)
#define B_100_0100_1111 (0x44FU)

#define B_100_0101_0000 (0x450U)
#define B_100_0101_0001 (0x451U)
#define B_100_0101_0010 (0x452U)
#define B_100_0101_0011 (0x453U)
#define B_100_0101_0100 (0x454U)
#define B_100_0101_0101 (0x455U)
#define B_100_0101_0110 (0x456U)
#define B_100_0101_0111 (0x457U)
#define B_100_0101_1000 (0x458U)
#define B_100_0101_1001 (0x459U)
#define B_100_0101_1010 (0x45AU)
#define B_100_0101_1011 (0x45BU)
#define B_100_0101_1100 (0x45CU)
#define B_100_0101_1101 (0x45DU)
#define B_100_0101_1110 (0x45EU)
#define B_100_0101_1111 (0x45FU)

#define B_100_0110_0000 (0x460U)
#define B_100_0110_0001 (0x461U)
#define B_100_0110_0010 (0x462U)
#define B_100_0110_0011 (0x463U)
#define B_100_0110_0100 (0x464U)
#define B_100_0110_0101 (0x465U)
#define B_100_0110_0110 (0x466U)
#define B_100_0110_0111 (0x467U)
#define B_100_0110_1000 (0x468U)
#define B_100_0110_1001 (0x469U)
#define B_100_0110_1010 (0x46AU)
#define B_100_0110_1011 (0x46BU)
#define B_100_0110_1100 (0x46CU)
#define B_100_0110_1101 (0x46DU)
#define B_100_0110_1110 (0x46EU)
#define B_100_0110_1111 (0x46FU)

#define B_100_0111_0000 (0x470U)
#define B_100_0111_0001 (0x471U)
#define B_100_0111_0010 (0x472U)
#define B_100_0111_0011 (0x473U)
#define B_100_0111_0100 (0x474U)
#define B_100_0111_0101 (0x475U)
#define B_100_0111_0110 (0x476U)
#define B_100_0111_0111 (0x477U)
#define B_100_0111_1000 (0x478U)
#define B_100_0111_1001 (0x479U)
#define B_100_0111_1010 (0x47AU)
#define B_100_0111_1011 (0x47BU)
#define B_100_0111_1100 (0x47CU)
#define B_100_0111_1101 (0x47DU)
#define B_100_0111_1110 (0x47EU)
#define B_100_0111_1111 (0x47FU)

#define B_100_1000_0000 (0x480U)
#define B_100_1000_0001 (0x481U)
#define B_100_1000_0010 (0x482U)
#define B_100_1000_0011 (0x483U)
#define B_100_1000_0100 (0x484U)
#define B_100_1000_0101 (0x485U)
#define B_100_1000_0110 (0x486U)
#define B_100_1000_0111 (0x487U)
#define B_100_1000_1000 (0x488U)
#define B_100_1000_1001 (0x489U)
#define B_100_1000_1010 (0x48AU)
#define B_100_1000_1011 (0x48BU)
#define B_100_1000_1100 (0x48CU)
#define B_100_1000_1101 (0x48DU)
#define B_100_1000_1110 (0x48EU)
#define B_100_1000_1111 (0x48FU)

#define B_100_1001_0000 (0x490U)
#define B_100_1001_0001 (0x491U)
#define B_100_1001_0010 (0x492U)
#define B_100_1001_0011 (0x493U)
#define B_100_1001_0100 (0x494U)
#define B_100_1001_0101 (0x495U)
#define B_100_1001_0110 (0x496U)
#define B_100_1001_0111 (0x497U)
#define B_100_1001_1000 (0x498U)
#define B_100_1001_1001 (0x499U)
#define B_100_1001_1010 (0x49AU)
#define B_100_1001_1011 (0x49BU)
#define B_100_1001_1100 (0x49CU)
#define B_100_1001_1101 (0x49DU)
#define B_100_1001_1110 (0x49EU)
#define B_100_1001_1111 (0x49FU)

#define B_100_1010_0000 (0x4A0U)
#define B_100_1010_0001 (0x4A1U)
#define B_100_1010_0010 (0x4A2U)
#define B_100_1010_0011 (0x4A3U)
#define B_100_1010_0100 (0x4A4U)
#define B_100_1010_0101 (0x4A5U)
#define B_100_1010_0110 (0x4A6U)
#define B_100_1010_0111 (0x4A7U)
#define B_100_1010_1000 (0x4A8U)
#define B_100_1010_1001 (0x4A9U)
#define B_100_1010_1010 (0x4AAU)
#define B_100_1010_1011 (0x4ABU)
#define B_100_1010_1100 (0x4ACU)
#define B_100_1010_1101 (0x4ADU)
#define B_100_1010_1110 (0x4AEU)
#define B_100_1010_1111 (0x4AFU)

#define B_100_1011_0000 (0x4B0U)
#define B_100_1011_0001 (0x4B1U)
#define B_100_1011_0010 (0x4B2U)
#define B_100_1011_0011 (0x4B3U)
#define B_100_1011_0100 (0x4B4U)
#define B_100_1011_0101 (0x4B5U)
#define B_100_1011_0110 (0x4B6U)
#define B_100_1011_0111 (0x4B7U)
#define B_100_1011_1000 (0x4B8U)
#define B_100_1011_1001 (0x4B9U)
#define B_100_1011_1010 (0x4BAU)
#define B_100_1011_1011 (0x4BBU)
#define B_100_1011_1100 (0x4BCU)
#define B_100_1011_1101 (0x4BDU)
#define B_100_1011_1110 (0x4BEU)
#define B_100_1011_1111 (0x4BFU)

#define B_100_1100_0000 (0x4C0U)
#define B_100_1100_0001 (0x4C1U)
#define B_100_1100_0010 (0x4C2U)
#define B_100_1100_0011 (0x4C3U)
#define B_100_1100_0100 (0x4C4U)
#define B_100_1100_0101 (0x4C5U)
#define B_100_1100_0110 (0x4C6U)
#define B_100_1100_0111 (0x4C7U)
#define B_100_1100_1000 (0x4C8U)
#define B_100_1100_1001 (0x4C9U)
#define B_100_1100_1010 (0x4CAU)
#define B_100_1100_1011 (0x4CBU)
#define B_100_1100_1100 (0x4CCU)
#define B_100_1100_1101 (0x4CDU)
#define B_100_1100_1110 (0x4CEU)
#define B_100_1100_1111 (0x4CFU)

#define B_100_1101_0000 (0x4D0U)
#define B_100_1101_0001 (0x4D1U)
#define B_100_1101_0010 (0x4D2U)
#define B_100_1101_0011 (0x4D3U)
#define B_100_1101_0100 (0x4D4U)
#define B_100_1101_0101 (0x4D5U)
#define B_100_1101_0110 (0x4D6U)
#define B_100_1101_0111 (0x4D7U)
#define B_100_1101_1000 (0x4D8U)
#define B_100_1101_1001 (0x4D9U)
#define B_100_1101_1010 (0x4DAU)
#define B_100_1101_1011 (0x4DBU)
#define B_100_1101_1100 (0x4DCU)
#define B_100_1101_1101 (0x4DDU)
#define B_100_1101_1110 (0x4DEU)
#define B_100_1101_1111 (0x4DFU)

#define B_100_1110_0000 (0x4E0U)
#define B_100_1110_0001 (0x4E1U)
#define B_100_1110_0010 (0x4E2U)
#define B_100_1110_0011 (0x4E3U)
#define B_100_1110_0100 (0x4E4U)
#define B_100_1110_0101 (0x4E5U)
#define B_100_1110_0110 (0x4E6U)
#define B_100_1110_0111 (0x4E7U)
#define B_100_1110_1000 (0x4E8U)
#define B_100_1110_1001 (0x4E9U)
#define B_100_1110_1010 (0x4EAU)
#define B_100_1110_1011 (0x4EBU)
#define B_100_1110_1100 (0x4ECU)
#define B_100_1110_1101 (0x4EDU)
#define B_100_1110_1110 (0x4EEU)
#define B_100_1110_1111 (0x4EFU)

#define B_100_1111_0000 (0x4F0U)
#define B_100_1111_0001 (0x4F1U)
#define B_100_1111_0010 (0x4F2U)
#define B_100_1111_0011 (0x4F3U)
#define B_100_1111_0100 (0x4F4U)
#define B_100_1111_0101 (0x4F5U)
#define B_100_1111_0110 (0x4F6U)
#define B_100_1111_0111 (0x4F7U)
#define B_100_1111_1000 (0x4F8U)
#define B_100_1111_1001 (0x4F9U)
#define B_100_1111_1010 (0x4FAU)
#define B_100_1111_1011 (0x4FBU)
#define B_100_1111_1100 (0x4FCU)
#define B_100_1111_1101 (0x4FDU)
#define B_100_1111_1110 (0x4FEU)
#define B_100_1111_1111 (0x4FFU)

#define B_101_0000_0000 (0x500U)
#define B_101_0000_0001 (0x501U)
#define B_101_0000_0010 (0x502U)
#define B_101_0000_0011 (0x503U)
#define B_101_0000_0100 (0x504U)
#define B_101_0000_0101 (0x505U)
#define B_101_0000_0110 (0x506U)
#define B_101_0000_0111 (0x507U)
#define B_101_0000_1000 (0x508U)
#define B_101_0000_1001 (0x509U)
#define B_101_0000_1010 (0x50AU)
#define B_101_0000_1011 (0x50BU)
#define B_101_0000_1100 (0x50CU)
#define B_101_0000_1101 (0x50DU)
#define B_101_0000_1110 (0x50EU)
#define B_101_0000_1111 (0x50FU)

#define B_101_0001_0000 (0x510U)
#define B_101_0001_0001 (0x511U)
#define B_101_0001_0010 (0x512U)
#define B_101_0001_0011 (0x513U)
#define B_101_0001_0100 (0x514U)
#define B_101_0001_0101 (0x515U)
#define B_101_0001_0110 (0x516U)
#define B_101_0001_0111 (0x517U)
#define B_101_0001_1000 (0x518U)
#define B_101_0001_1001 (0x519U)
#define B_101_0001_1010 (0x51AU)
#define B_101_0001_1011 (0x51BU)
#define B_101_0001_1100 (0x51CU)
#define B_101_0001_1101 (0x51DU)
#define B_101_0001_1110 (0x51EU)
#define B_101_0001_1111 (0x51FU)

#define B_101_0010_0000 (0x520U)
#define B_101_0010_0001 (0x521U)
#define B_101_0010_0010 (0x522U)
#define B_101_0010_0011 (0x523U)
#define B_101_0010_0100 (0x524U)
#define B_101_0010_0101 (0x525U)
#define B_101_0010_0110 (0x526U)
#define B_101_0010_0111 (0x527U)
#define B_101_0010_1000 (0x528U)
#define B_101_0010_1001 (0x529U)
#define B_101_0010_1010 (0x52AU)
#define B_101_0010_1011 (0x52BU)
#define B_101_0010_1100 (0x52CU)
#define B_101_0010_1101 (0x52DU)
#define B_101_0010_1110 (0x52EU)
#define B_101_0010_1111 (0x52FU)

#define B_101_0011_0000 (0x530U)
#define B_101_0011_0001 (0x531U)
#define B_101_0011_0010 (0x532U)
#define B_101_0011_0011 (0x533U)
#define B_101_0011_0100 (0x534U)
#define B_101_0011_0101 (0x535U)
#define B_101_0011_0110 (0x536U)
#define B_101_0011_0111 (0x537U)
#define B_101_0011_1000 (0x538U)
#define B_101_0011_1001 (0x539U)
#define B_101_0011_1010 (0x53AU)
#define B_101_0011_1011 (0x53BU)
#define B_101_0011_1100 (0x53CU)
#define B_101_0011_1101 (0x53DU)
#define B_101_0011_1110 (0x53EU)
#define B_101_0011_1111 (0x53FU)

#define B_101_0100_0000 (0x540U)
#define B_101_0100_0001 (0x541U)
#define B_101_0100_0010 (0x542U)
#define B_101_0100_0011 (0x543U)
#define B_101_0100_0100 (0x544U)
#define B_101_0100_0101 (0x545U)
#define B_101_0100_0110 (0x546U)
#define B_101_0100_0111 (0x547U)
#define B_101_0100_1000 (0x548U)
#define B_101_0100_1001 (0x549U)
#define B_101_0100_1010 (0x54AU)
#define B_101_0100_1011 (0x54BU)
#define B_101_0100_1100 (0x54CU)
#define B_101_0100_1101 (0x54DU)
#define B_101_0100_1110 (0x54EU)
#define B_101_0100_1111 (0x54FU)

#define B_101_0101_0000 (0x550U)
#define B_101_0101_0001 (0x551U)
#define B_101_0101_0010 (0x552U)
#define B_101_0101_0011 (0x553U)
#define B_101_0101_0100 (0x554U)
#define B_101_0101_0101 (0x555U)
#define B_101_0101_0110 (0x556U)
#define B_101_0101_0111 (0x557U)
#define B_101_0101_1000 (0x558U)
#define B_101_0101_1001 (0x559U)
#define B_101_0101_1010 (0x55AU)
#define B_101_0101_1011 (0x55BU)
#define B_101_0101_1100 (0x55CU)
#define B_101_0101_1101 (0x55DU)
#define B_101_0101_1110 (0x55EU)
#define B_101_0101_1111 (0x55FU)

#define B_101_0110_0000 (0x560U)
#define B_101_0110_0001 (0x561U)
#define B_101_0110_0010 (0x562U)
#define B_101_0110_0011 (0x563U)
#define B_101_0110_0100 (0x564U)
#define B_101_0110_0101 (0x565U)
#define B_101_0110_0110 (0x566U)
#define B_101_0110_0111 (0x567U)
#define B_101_0110_1000 (0x568U)
#define B_101_0110_1001 (0x569U)
#define B_101_0110_1010 (0x56AU)
#define B_101_0110_1011 (0x56BU)
#define B_101_0110_1100 (0x56CU)
#define B_101_0110_1101 (0x56DU)
#define B_101_0110_1110 (0x56EU)
#define B_101_0110_1111 (0x56FU)

#define B_101_0111_0000 (0x570U)
#define B_101_0111_0001 (0x571U)
#define B_101_0111_0010 (0x572U)
#define B_101_0111_0011 (0x573U)
#define B_101_0111_0100 (0x574U)
#define B_101_0111_0101 (0x575U)
#define B_101_0111_0110 (0x576U)
#define B_101_0111_0111 (0x577U)
#define B_101_0111_1000 (0x578U)
#define B_101_0111_1001 (0x579U)
#define B_101_0111_1010 (0x57AU)
#define B_101_0111_1011 (0x57BU)
#define B_101_0111_1100 (0x57CU)
#define B_101_0111_1101 (0x57DU)
#define B_101_0111_1110 (0x57EU)
#define B_101_0111_1111 (0x57FU)

#define B_101_1000_0000 (0x580U)
#define B_101_1000_0001 (0x581U)
#define B_101_1000_0010 (0x582U)
#define B_101_1000_0011 (0x583U)
#define B_101_1000_0100 (0x584U)
#define B_101_1000_0101 (0x585U)
#define B_101_1000_0110 (0x586U)
#define B_101_1000_0111 (0x587U)
#define B_101_1000_1000 (0x588U)
#define B_101_1000_1001 (0x589U)
#define B_101_1000_1010 (0x58AU)
#define B_101_1000_1011 (0x58BU)
#define B_101_1000_1100 (0x58CU)
#define B_101_1000_1101 (0x58DU)
#define B_101_1000_1110 (0x58EU)
#define B_101_1000_1111 (0x58FU)

#define B_101_1001_0000 (0x590U)
#define B_101_1001_0001 (0x591U)
#define B_101_1001_0010 (0x592U)
#define B_101_1001_0011 (0x593U)
#define B_101_1001_0100 (0x594U)
#define B_101_1001_0101 (0x595U)
#define B_101_1001_0110 (0x596U)
#define B_101_1001_0111 (0x597U)
#define B_101_1001_1000 (0x598U)
#define B_101_1001_1001 (0x599U)
#define B_101_1001_1010 (0x59AU)
#define B_101_1001_1011 (0x59BU)
#define B_101_1001_1100 (0x59CU)
#define B_101_1001_1101 (0x59DU)
#define B_101_1001_1110 (0x59EU)
#define B_101_1001_1111 (0x59FU)

#define B_101_1010_0000 (0x5A0U)
#define B_101_1010_0001 (0x5A1U)
#define B_101_1010_0010 (0x5A2U)
#define B_101_1010_0011 (0x5A3U)
#define B_101_1010_0100 (0x5A4U)
#define B_101_1010_0101 (0x5A5U)
#define B_101_1010_0110 (0x5A6U)
#define B_101_1010_0111 (0x5A7U)
#define B_101_1010_1000 (0x5A8U)
#define B_101_1010_1001 (0x5A9U)
#define B_101_1010_1010 (0x5AAU)
#define B_101_1010_1011 (0x5ABU)
#define B_101_1010_1100 (0x5ACU)
#define B_101_1010_1101 (0x5ADU)
#define B_101_1010_1110 (0x5AEU)
#define B_101_1010_1111 (0x5AFU)

#define B_101_1011_0000 (0x5B0U)
#define B_101_1011_0001 (0x5B1U)
#define B_101_1011_0010 (0x5B2U)
#define B_101_1011_0011 (0x5B3U)
#define B_101_1011_0100 (0x5B4U)
#define B_101_1011_0101 (0x5B5U)
#define B_101_1011_0110 (0x5B6U)
#define B_101_1011_0111 (0x5B7U)
#define B_101_1011_1000 (0x5B8U)
#define B_101_1011_1001 (0x5B9U)
#define B_101_1011_1010 (0x5BAU)
#define B_101_1011_1011 (0x5BBU)
#define B_101_1011_1100 (0x5BCU)
#define B_101_1011_1101 (0x5BDU)
#define B_101_1011_1110 (0x5BEU)
#define B_101_1011_1111 (0x5BFU)

#define B_101_1100_0000 (0x5C0U)
#define B_101_1100_0001 (0x5C1U)
#define B_101_1100_0010 (0x5C2U)
#define B_101_1100_0011 (0x5C3U)
#define B_101_1100_0100 (0x5C4U)
#define B_101_1100_0101 (0x5C5U)
#define B_101_1100_0110 (0x5C6U)
#define B_101_1100_0111 (0x5C7U)
#define B_101_1100_1000 (0x5C8U)
#define B_101_1100_1001 (0x5C9U)
#define B_101_1100_1010 (0x5CAU)
#define B_101_1100_1011 (0x5CBU)
#define B_101_1100_1100 (0x5CCU)
#define B_101_1100_1101 (0x5CDU)
#define B_101_1100_1110 (0x5CEU)
#define B_101_1100_1111 (0x5CFU)

#define B_101_1101_0000 (0x5D0U)
#define B_101_1101_0001 (0x5D1U)
#define B_101_1101_0010 (0x5D2U)
#define B_101_1101_0011 (0x5D3U)
#define B_101_1101_0100 (0x5D4U)
#define B_101_1101_0101 (0x5D5U)
#define B_101_1101_0110 (0x5D6U)
#define B_101_1101_0111 (0x5D7U)
#define B_101_1101_1000 (0x5D8U)
#define B_101_1101_1001 (0x5D9U)
#define B_101_1101_1010 (0x5DAU)
#define B_101_1101_1011 (0x5DBU)
#define B_101_1101_1100 (0x5DCU)
#define B_101_1101_1101 (0x5DDU)
#define B_101_1101_1110 (0x5DEU)
#define B_101_1101_1111 (0x5DFU)

#define B_101_1110_0000 (0x5E0U)
#define B_101_1110_0001 (0x5E1U)
#define B_101_1110_0010 (0x5E2U)
#define B_101_1110_0011 (0x5E3U)
#define B_101_1110_0100 (0x5E4U)
#define B_101_1110_0101 (0x5E5U)
#define B_101_1110_0110 (0x5E6U)
#define B_101_1110_0111 (0x5E7U)
#define B_101_1110_1000 (0x5E8U)
#define B_101_1110_1001 (0x5E9U)
#define B_101_1110_1010 (0x5EAU)
#define B_101_1110_1011 (0x5EBU)
#define B_101_1110_1100 (0x5ECU)
#define B_101_1110_1101 (0x5EDU)
#define B_101_1110_1110 (0x5EEU)
#define B_101_1110_1111 (0x5EFU)

#define B_101_1111_0000 (0x5F0U)
#define B_101_1111_0001 (0x5F1U)
#define B_101_1111_0010 (0x5F2U)
#define B_101_1111_0011 (0x5F3U)
#define B_101_1111_0100 (0x5F4U)
#define B_101_1111_0101 (0x5F5U)
#define B_101_1111_0110 (0x5F6U)
#define B_101_1111_0111 (0x5F7U)
#define B_101_1111_1000 (0x5F8U)
#define B_101_1111_1001 (0x5F9U)
#define B_101_1111_1010 (0x5FAU)
#define B_101_1111_1011 (0x5FBU)
#define B_101_1111_1100 (0x5FCU)
#define B_101_1111_1101 (0x5FDU)
#define B_101_1111_1110 (0x5FEU)
#define B_101_1111_1111 (0x5FFU)

#define B_110_0000_0000 (0x600U)
#define B_110_0000_0001 (0x601U)
#define B_110_0000_0010 (0x602U)
#define B_110_0000_0011 (0x603U)
#define B_110_0000_0100 (0x604U)
#define B_110_0000_0101 (0x605U)
#define B_110_0000_0110 (0x606U)
#define B_110_0000_0111 (0x607U)
#define B_110_0000_1000 (0x608U)
#define B_110_0000_1001 (0x609U)
#define B_110_0000_1010 (0x60AU)
#define B_110_0000_1011 (0x60BU)
#define B_110_0000_1100 (0x60CU)
#define B_110_0000_1101 (0x60DU)
#define B_110_0000_1110 (0x60EU)
#define B_110_0000_1111 (0x60FU)

#define B_110_0001_0000 (0x610U)
#define B_110_0001_0001 (0x611U)
#define B_110_0001_0010 (0x612U)
#define B_110_0001_0011 (0x613U)
#define B_110_0001_0100 (0x614U)
#define B_110_0001_0101 (0x615U)
#define B_110_0001_0110 (0x616U)
#define B_110_0001_0111 (0x617U)
#define B_110_0001_1000 (0x618U)
#define B_110_0001_1001 (0x619U)
#define B_110_0001_1010 (0x61AU)
#define B_110_0001_1011 (0x61BU)
#define B_110_0001_1100 (0x61CU)
#define B_110_0001_1101 (0x61DU)
#define B_110_0001_1110 (0x61EU)
#define B_110_0001_1111 (0x61FU)

#define B_110_0010_0000 (0x620U)
#define B_110_0010_0001 (0x621U)
#define B_110_0010_0010 (0x622U)
#define B_110_0010_0011 (0x623U)
#define B_110_0010_0100 (0x624U)
#define B_110_0010_0101 (0x625U)
#define B_110_0010_0110 (0x626U)
#define B_110_0010_0111 (0x627U)
#define B_110_0010_1000 (0x628U)
#define B_110_0010_1001 (0x629U)
#define B_110_0010_1010 (0x62AU)
#define B_110_0010_1011 (0x62BU)
#define B_110_0010_1100 (0x62CU)
#define B_110_0010_1101 (0x62DU)
#define B_110_0010_1110 (0x62EU)
#define B_110_0010_1111 (0x62FU)

#define B_110_0011_0000 (0x630U)
#define B_110_0011_0001 (0x631U)
#define B_110_0011_0010 (0x632U)
#define B_110_0011_0011 (0x633U)
#define B_110_0011_0100 (0x634U)
#define B_110_0011_0101 (0x635U)
#define B_110_0011_0110 (0x636U)
#define B_110_0011_0111 (0x637U)
#define B_110_0011_1000 (0x638U)
#define B_110_0011_1001 (0x639U)
#define B_110_0011_1010 (0x63AU)
#define B_110_0011_1011 (0x63BU)
#define B_110_0011_1100 (0x63CU)
#define B_110_0011_1101 (0x63DU)
#define B_110_0011_1110 (0x63EU)
#define B_110_0011_1111 (0x63FU)

#define B_110_0100_0000 (0x640U)
#define B_110_0100_0001 (0x641U)
#define B_110_0100_0010 (0x642U)
#define B_110_0100_0011 (0x643U)
#define B_110_0100_0100 (0x644U)
#define B_110_0100_0101 (0x645U)
#define B_110_0100_0110 (0x646U)
#define B_110_0100_0111 (0x647U)
#define B_110_0100_1000 (0x648U)
#define B_110_0100_1001 (0x649U)
#define B_110_0100_1010 (0x64AU)
#define B_110_0100_1011 (0x64BU)
#define B_110_0100_1100 (0x64CU)
#define B_110_0100_1101 (0x64DU)
#define B_110_0100_1110 (0x64EU)
#define B_110_0100_1111 (0x64FU)

#define B_110_0101_0000 (0x650U)
#define B_110_0101_0001 (0x651U)
#define B_110_0101_0010 (0x652U)
#define B_110_0101_0011 (0x653U)
#define B_110_0101_0100 (0x654U)
#define B_110_0101_0101 (0x655U)
#define B_110_0101_0110 (0x656U)
#define B_110_0101_0111 (0x657U)
#define B_110_0101_1000 (0x658U)
#define B_110_0101_1001 (0x659U)
#define B_110_0101_1010 (0x65AU)
#define B_110_0101_1011 (0x65BU)
#define B_110_0101_1100 (0x65CU)
#define B_110_0101_1101 (0x65DU)
#define B_110_0101_1110 (0x65EU)
#define B_110_0101_1111 (0x65FU)

#define B_110_0110_0000 (0x660U)
#define B_110_0110_0001 (0x661U)
#define B_110_0110_0010 (0x662U)
#define B_110_0110_0011 (0x663U)
#define B_110_0110_0100 (0x664U)
#define B_110_0110_0101 (0x665U)
#define B_110_0110_0110 (0x666U)
#define B_110_0110_0111 (0x667U)
#define B_110_0110_1000 (0x668U)
#define B_110_0110_1001 (0x669U)
#define B_110_0110_1010 (0x66AU)
#define B_110_0110_1011 (0x66BU)
#define B_110_0110_1100 (0x66CU)
#define B_110_0110_1101 (0x66DU)
#define B_110_0110_1110 (0x66EU)
#define B_110_0110_1111 (0x66FU)

#define B_110_0111_0000 (0x670U)
#define B_110_0111_0001 (0x671U)
#define B_110_0111_0010 (0x672U)
#define B_110_0111_0011 (0x673U)
#define B_110_0111_0100 (0x674U)
#define B_110_0111_0101 (0x675U)
#define B_110_0111_0110 (0x676U)
#define B_110_0111_0111 (0x677U)
#define B_110_0111_1000 (0x678U)
#define B_110_0111_1001 (0x679U)
#define B_110_0111_1010 (0x67AU)
#define B_110_0111_1011 (0x67BU)
#define B_110_0111_1100 (0x67CU)
#define B_110_0111_1101 (0x67DU)
#define B_110_0111_1110 (0x67EU)
#define B_110_0111_1111 (0x67FU)

#define B_110_1000_0000 (0x680U)
#define B_110_1000_0001 (0x681U)
#define B_110_1000_0010 (0x682U)
#define B_110_1000_0011 (0x683U)
#define B_110_1000_0100 (0x684U)
#define B_110_1000_0101 (0x685U)
#define B_110_1000_0110 (0x686U)
#define B_110_1000_0111 (0x687U)
#define B_110_1000_1000 (0x688U)
#define B_110_1000_1001 (0x689U)
#define B_110_1000_1010 (0x68AU)
#define B_110_1000_1011 (0x68BU)
#define B_110_1000_1100 (0x68CU)
#define B_110_1000_1101 (0x68DU)
#define B_110_1000_1110 (0x68EU)
#define B_110_1000_1111 (0x68FU)

#define B_110_1001_0000 (0x690U)
#define B_110_1001_0001 (0x691U)
#define B_110_1001_0010 (0x692U)
#define B_110_1001_0011 (0x693U)
#define B_110_1001_0100 (0x694U)
#define B_110_1001_0101 (0x695U)
#define B_110_1001_0110 (0x696U)
#define B_110_1001_0111 (0x697U)
#define B_110_1001_1000 (0x698U)
#define B_110_1001_1001 (0x699U)
#define B_110_1001_1010 (0x69AU)
#define B_110_1001_1011 (0x69BU)
#define B_110_1001_1100 (0x69CU)
#define B_110_1001_1101 (0x69DU)
#define B_110_1001_1110 (0x69EU)
#define B_110_1001_1111 (0x69FU)

#define B_110_1010_0000 (0x6A0U)
#define B_110_1010_0001 (0x6A1U)
#define B_110_1010_0010 (0x6A2U)
#define B_110_1010_0011 (0x6A3U)
#define B_110_1010_0100 (0x6A4U)
#define B_110_1010_0101 (0x6A5U)
#define B_110_1010_0110 (0x6A6U)
#define B_110_1010_0111 (0x6A7U)
#define B_110_1010_1000 (0x6A8U)
#define B_110_1010_1001 (0x6A9U)
#define B_110_1010_1010 (0x6AAU)
#define B_110_1010_1011 (0x6ABU)
#define B_110_1010_1100 (0x6ACU)
#define B_110_1010_1101 (0x6ADU)
#define B_110_1010_1110 (0x6AEU)
#define B_110_1010_1111 (0x6AFU)

#define B_110_1011_0000 (0x6B0U)
#define B_110_1011_0001 (0x6B1U)
#define B_110_1011_0010 (0x6B2U)
#define B_110_1011_0011 (0x6B3U)
#define B_110_1011_0100 (0x6B4U)
#define B_110_1011_0101 (0x6B5U)
#define B_110_1011_0110 (0x6B6U)
#define B_110_1011_0111 (0x6B7U)
#define B_110_1011_1000 (0x6B8U)
#define B_110_1011_1001 (0x6B9U)
#define B_110_1011_1010 (0x6BAU)
#define B_110_1011_1011 (0x6BBU)
#define B_110_1011_1100 (0x6BCU)
#define B_110_1011_1101 (0x6BDU)
#define B_110_1011_1110 (0x6BEU)
#define B_110_1011_1111 (0x6BFU)

#define B_110_1100_0000 (0x6C0U)
#define B_110_1100_0001 (0x6C1U)
#define B_110_1100_0010 (0x6C2U)
#define B_110_1100_0011 (0x6C3U)
#define B_110_1100_0100 (0x6C4U)
#define B_110_1100_0101 (0x6C5U)
#define B_110_1100_0110 (0x6C6U)
#define B_110_1100_0111 (0x6C7U)
#define B_110_1100_1000 (0x6C8U)
#define B_110_1100_1001 (0x6C9U)
#define B_110_1100_1010 (0x6CAU)
#define B_110_1100_1011 (0x6CBU)
#define B_110_1100_1100 (0x6CCU)
#define B_110_1100_1101 (0x6CDU)
#define B_110_1100_1110 (0x6CEU)
#define B_110_1100_1111 (0x6CFU)

#define B_110_1101_0000 (0x6D0U)
#define B_110_1101_0001 (0x6D1U)
#define B_110_1101_0010 (0x6D2U)
#define B_110_1101_0011 (0x6D3U)
#define B_110_1101_0100 (0x6D4U)
#define B_110_1101_0101 (0x6D5U)
#define B_110_1101_0110 (0x6D6U)
#define B_110_1101_0111 (0x6D7U)
#define B_110_1101_1000 (0x6D8U)
#define B_110_1101_1001 (0x6D9U)
#define B_110_1101_1010 (0x6DAU)
#define B_110_1101_1011 (0x6DBU)
#define B_110_1101_1100 (0x6DCU)
#define B_110_1101_1101 (0x6DDU)
#define B_110_1101_1110 (0x6DEU)
#define B_110_1101_1111 (0x6DFU)

#define B_110_1110_0000 (0x6E0U)
#define B_110_1110_0001 (0x6E1U)
#define B_110_1110_0010 (0x6E2U)
#define B_110_1110_0011 (0x6E3U)
#define B_110_1110_0100 (0x6E4U)
#define B_110_1110_0101 (0x6E5U)
#define B_110_1110_0110 (0x6E6U)
#define B_110_1110_0111 (0x6E7U)
#define B_110_1110_1000 (0x6E8U)
#define B_110_1110_1001 (0x6E9U)
#define B_110_1110_1010 (0x6EAU)
#define B_110_1110_1011 (0x6EBU)
#define B_110_1110_1100 (0x6ECU)
#define B_110_1110_1101 (0x6EDU)
#define B_110_1110_1110 (0x6EEU)
#define B_110_1110_1111 (0x6EFU)

#define B_110_1111_0000 (0x6F0U)
#define B_110_1111_0001 (0x6F1U)
#define B_110_1111_0010 (0x6F2U)
#define B_110_1111_0011 (0x6F3U)
#define B_110_1111_0100 (0x6F4U)
#define B_110_1111_0101 (0x6F5U)
#define B_110_1111_0110 (0x6F6U)
#define B_110_1111_0111 (0x6F7U)
#define B_110_1111_1000 (0x6F8U)
#define B_110_1111_1001 (0x6F9U)
#define B_110_1111_1010 (0x6FAU)
#define B_110_1111_1011 (0x6FBU)
#define B_110_1111_1100 (0x6FCU)
#define B_110_1111_1101 (0x6FDU)
#define B_110_1111_1110 (0x6FEU)
#define B_110_1111_1111 (0x6FFU)

#define B_111_0000_0000 (0x700U)
#define B_111_0000_0001 (0x701U)
#define B_111_0000_0010 (0x702U)
#define B_111_0000_0011 (0x703U)
#define B_111_0000_0100 (0x704U)
#define B_111_0000_0101 (0x705U)
#define B_111_0000_0110 (0x706U)
#define B_111_0000_0111 (0x707U)
#define B_111_0000_1000 (0x708U)
#define B_111_0000_1001 (0x709U)
#define B_111_0000_1010 (0x70AU)
#define B_111_0000_1011 (0x70BU)
#define B_111_0000_1100 (0x70CU)
#define B_111_0000_1101 (0x70DU)
#define B_111_0000_1110 (0x70EU)
#define B_111_0000_1111 (0x70FU)

#define B_111_0001_0000 (0x710U)
#define B_111_0001_0001 (0x711U)
#define B_111_0001_0010 (0x712U)
#define B_111_0001_0011 (0x713U)
#define B_111_0001_0100 (0x714U)
#define B_111_0001_0101 (0x715U)
#define B_111_0001_0110 (0x716U)
#define B_111_0001_0111 (0x717U)
#define B_111_0001_1000 (0x718U)
#define B_111_0001_1001 (0x719U)
#define B_111_0001_1010 (0x71AU)
#define B_111_0001_1011 (0x71BU)
#define B_111_0001_1100 (0x71CU)
#define B_111_0001_1101 (0x71DU)
#define B_111_0001_1110 (0x71EU)
#define B_111_0001_1111 (0x71FU)

#define B_111_0010_0000 (0x720U)
#define B_111_0010_0001 (0x721U)
#define B_111_0010_0010 (0x722U)
#define B_111_0010_0011 (0x723U)
#define B_111_0010_0100 (0x724U)
#define B_111_0010_0101 (0x725U)
#define B_111_0010_0110 (0x726U)
#define B_111_0010_0111 (0x727U)
#define B_111_0010_1000 (0x728U)
#define B_111_0010_1001 (0x729U)
#define B_111_0010_1010 (0x72AU)
#define B_111_0010_1011 (0x72BU)
#define B_111_0010_1100 (0x72CU)
#define B_111_0010_1101 (0x72DU)
#define B_111_0010_1110 (0x72EU)
#define B_111_0010_1111 (0x72FU)

#define B_111_0011_0000 (0x730U)
#define B_111_0011_0001 (0x731U)
#define B_111_0011_0010 (0x732U)
#define B_111_0011_0011 (0x733U)
#define B_111_0011_0100 (0x734U)
#define B_111_0011_0101 (0x735U)
#define B_111_0011_0110 (0x736U)
#define B_111_0011_0111 (0x737U)
#define B_111_0011_1000 (0x738U)
#define B_111_0011_1001 (0x739U)
#define B_111_0011_1010 (0x73AU)
#define B_111_0011_1011 (0x73BU)
#define B_111_0011_1100 (0x73CU)
#define B_111_0011_1101 (0x73DU)
#define B_111_0011_1110 (0x73EU)
#define B_111_0011_1111 (0x73FU)

#define B_111_0100_0000 (0x740U)
#define B_111_0100_0001 (0x741U)
#define B_111_0100_0010 (0x742U)
#define B_111_0100_0011 (0x743U)
#define B_111_0100_0100 (0x744U)
#define B_111_0100_0101 (0x745U)
#define B_111_0100_0110 (0x746U)
#define B_111_0100_0111 (0x747U)
#define B_111_0100_1000 (0x748U)
#define B_111_0100_1001 (0x749U)
#define B_111_0100_1010 (0x74AU)
#define B_111_0100_1011 (0x74BU)
#define B_111_0100_1100 (0x74CU)
#define B_111_0100_1101 (0x74DU)
#define B_111_0100_1110 (0x74EU)
#define B_111_0100_1111 (0x74FU)

#define B_111_0101_0000 (0x750U)
#define B_111_0101_0001 (0x751U)
#define B_111_0101_0010 (0x752U)
#define B_111_0101_0011 (0x753U)
#define B_111_0101_0100 (0x754U)
#define B_111_0101_0101 (0x755U)
#define B_111_0101_0110 (0x756U)
#define B_111_0101_0111 (0x757U)
#define B_111_0101_1000 (0x758U)
#define B_111_0101_1001 (0x759U)
#define B_111_0101_1010 (0x75AU)
#define B_111_0101_1011 (0x75BU)
#define B_111_0101_1100 (0x75CU)
#define B_111_0101_1101 (0x75DU)
#define B_111_0101_1110 (0x75EU)
#define B_111_0101_1111 (0x75FU)

#define B_111_0110_0000 (0x760U)
#define B_111_0110_0001 (0x761U)
#define B_111_0110_0010 (0x762U)
#define B_111_0110_0011 (0x763U)
#define B_111_0110_0100 (0x764U)
#define B_111_0110_0101 (0x765U)
#define B_111_0110_0110 (0x766U)
#define B_111_0110_0111 (0x767U)
#define B_111_0110_1000 (0x768U)
#define B_111_0110_1001 (0x769U)
#define B_111_0110_1010 (0x76AU)
#define B_111_0110_1011 (0x76BU)
#define B_111_0110_1100 (0x76CU)
#define B_111_0110_1101 (0x76DU)
#define B_111_0110_1110 (0x76EU)
#define B_111_0110_1111 (0x76FU)

#define B_111_0111_0000 (0x770U)
#define B_111_0111_0001 (0x771U)
#define B_111_0111_0010 (0x772U)
#define B_111_0111_0011 (0x773U)
#define B_111_0111_0100 (0x774U)
#define B_111_0111_0101 (0x775U)
#define B_111_0111_0110 (0x776U)
#define B_111_0111_0111 (0x777U)
#define B_111_0111_1000 (0x778U)
#define B_111_0111_1001 (0x779U)
#define B_111_0111_1010 (0x77AU)
#define B_111_0111_1011 (0x77BU)
#define B_111_0111_1100 (0x77CU)
#define B_111_0111_1101 (0x77DU)
#define B_111_0111_1110 (0x77EU)
#define B_111_0111_1111 (0x77FU)

#define B_111_1000_0000 (0x780U)
#define B_111_1000_0001 (0x781U)
#define B_111_1000_0010 (0x782U)
#define B_111_1000_0011 (0x783U)
#define B_111_1000_0100 (0x784U)
#define B_111_1000_0101 (0x785U)
#define B_111_1000_0110 (0x786U)
#define B_111_1000_0111 (0x787U)
#define B_111_1000_1000 (0x788U)
#define B_111_1000_1001 (0x789U)
#define B_111_1000_1010 (0x78AU)
#define B_111_1000_1011 (0x78BU)
#define B_111_1000_1100 (0x78CU)
#define B_111_1000_1101 (0x78DU)
#define B_111_1000_1110 (0x78EU)
#define B_111_1000_1111 (0x78FU)

#define B_111_1001_0000 (0x790U)
#define B_111_1001_0001 (0x791U)
#define B_111_1001_0010 (0x792U)
#define B_111_1001_0011 (0x793U)
#define B_111_1001_0100 (0x794U)
#define B_111_1001_0101 (0x795U)
#define B_111_1001_0110 (0x796U)
#define B_111_1001_0111 (0x797U)
#define B_111_1001_1000 (0x798U)
#define B_111_1001_1001 (0x799U)
#define B_111_1001_1010 (0x79AU)
#define B_111_1001_1011 (0x79BU)
#define B_111_1001_1100 (0x79CU)
#define B_111_1001_1101 (0x79DU)
#define B_111_1001_1110 (0x79EU)
#define B_111_1001_1111 (0x79FU)

#define B_111_1010_0000 (0x7A0U)
#define B_111_1010_0001 (0x7A1U)
#define B_111_1010_0010 (0x7A2U)
#define B_111_1010_0011 (0x7A3U)
#define B_111_1010_0100 (0x7A4U)
#define B_111_1010_0101 (0x7A5U)
#define B_111_1010_0110 (0x7A6U)
#define B_111_1010_0111 (0x7A7U)
#define B_111_1010_1000 (0x7A8U)
#define B_111_1010_1001 (0x7A9U)
#define B_111_1010_1010 (0x7AAU)
#define B_111_1010_1011 (0x7ABU)
#define B_111_1010_1100 (0x7ACU)
#define B_111_1010_1101 (0x7ADU)
#define B_111_1010_1110 (0x7AEU)
#define B_111_1010_1111 (0x7AFU)

#define B_111_1011_0000 (0x7B0U)
#define B_111_1011_0001 (0x7B1U)
#define B_111_1011_0010 (0x7B2U)
#define B_111_1011_0011 (0x7B3U)
#define B_111_1011_0100 (0x7B4U)
#define B_111_1011_0101 (0x7B5U)
#define B_111_1011_0110 (0x7B6U)
#define B_111_1011_0111 (0x7B7U)
#define B_111_1011_1000 (0x7B8U)
#define B_111_1011_1001 (0x7B9U)
#define B_111_1011_1010 (0x7BAU)
#define B_111_1011_1011 (0x7BBU)
#define B_111_1011_1100 (0x7BCU)
#define B_111_1011_1101 (0x7BDU)
#define B_111_1011_1110 (0x7BEU)
#define B_111_1011_1111 (0x7BFU)

#define B_111_1100_0000 (0x7C0U)
#define B_111_1100_0001 (0x7C1U)
#define B_111_1100_0010 (0x7C2U)
#define B_111_1100_0011 (0x7C3U)
#define B_111_1100_0100 (0x7C4U)
#define B_111_1100_0101 (0x7C5U)
#define B_111_1100_0110 (0x7C6U)
#define B_111_1100_0111 (0x7C7U)
#define B_111_1100_1000 (0x7C8U)
#define B_111_1100_1001 (0x7C9U)
#define B_111_1100_1010 (0x7CAU)
#define B_111_1100_1011 (0x7CBU)
#define B_111_1100_1100 (0x7CCU)
#define B_111_1100_1101 (0x7CDU)
#define B_111_1100_1110 (0x7CEU)
#define B_111_1100_1111 (0x7CFU)

#define B_111_1101_0000 (0x7D0U)
#define B_111_1101_0001 (0x7D1U)
#define B_111_1101_0010 (0x7D2U)
#define B_111_1101_0011 (0x7D3U)
#define B_111_1101_0100 (0x7D4U)
#define B_111_1101_0101 (0x7D5U)
#define B_111_1101_0110 (0x7D6U)
#define B_111_1101_0111 (0x7D7U)
#define B_111_1101_1000 (0x7D8U)
#define B_111_1101_1001 (0x7D9U)
#define B_111_1101_1010 (0x7DAU)
#define B_111_1101_1011 (0x7DBU)
#define B_111_1101_1100 (0x7DCU)
#define B_111_1101_1101 (0x7DDU)
#define B_111_1101_1110 (0x7DEU)
#define B_111_1101_1111 (0x7DFU)

#define B_111_1110_0000 (0x7E0U)
#define B_111_1110_0001 (0x7E1U)
#define B_111_1110_0010 (0x7E2U)
#define B_111_1110_0011 (0x7E3U)
#define B_111_1110_0100 (0x7E4U)
#define B_111_1110_0101 (0x7E5U)
#define B_111_1110_0110 (0x7E6U)
#define B_111_1110_0111 (0x7E7U)
#define B_111_1110_1000 (0x7E8U)
#define B_111_1110_1001 (0x7E9U)
#define B_111_1110_1010 (0x7EAU)
#define B_111_1110_1011 (0x7EBU)
#define B_111_1110_1100 (0x7ECU)
#define B_111_1110_1101 (0x7EDU)
#define B_111_1110_1110 (0x7EEU)
#define B_111_1110_1111 (0x7EFU)

#define B_111_1111_0000 (0x7F0U)
#define B_111_1111_0001 (0x7F1U)
#define B_111_1111_0010 (0x7F2U)
#define B_111_1111_0011 (0x7F3U)
#define B_111_1111_0100 (0x7F4U)
#define B_111_1111_0101 (0x7F5U)
#define B_111_1111_0110 (0x7F6U)
#define B_111_1111_0111 (0x7F7U)
#define B_111_1111_1000 (0x7F8U)
#define B_111_1111_1001 (0x7F9U)
#define B_111_1111_1010 (0x7FAU)
#define B_111_1111_1011 (0x7FBU)
#define B_111_1111_1100 (0x7FCU)
#define B_111_1111_1101 (0x7FDU)
#define B_111_1111_1110 (0x7FEU)
#define B_111_1111_1111 (0x7FFU)


/* Generated with the following python snippet
try:
    if do_print:
        pass
except NameError:
    def do_print(x):
        print (x[:-1])
count = 0
for b10 in range(2):
    for b9 in range(2):
        for b8 in range(2):
            for b7 in range(2):
                for b6 in range(2):
                    for b5 in range(2):
                        for b4 in range(2):
                            do_print("\n")
                            for b3 in range(2):
                                for b2 in range(2):
                                    for b1 in range(2):
                                        for b0 in range(2):
  do_print("#define B_%d%d%d_%d%d%d%d_%d%d%d%d (0x%03XU)\n"%(b10,b9,b8,b7,b6,b5,b4,b3,b2,b1,b0,count))
                                            count += 1

*/

#endif /* PH_BINARYNUMBERS_H */
