@echo off

@REM
@REM
@REM                      Copyright (c), NXP Semiconductors
@REM
@REM                         (C) NXP Semiconductors 2014,2015
@REM
@REM           All rights are reserved. Reproduction in whole or in part is
@REM          prohibited without the written consent of the copyright owner.
@REM      NXP reserves the right to make changes without notice at any time.
@REM     NXP makes no warranty, expressed, implied or statutory, including but
@REM     not limited to any implied warranty of merchantability or fitness for any
@REM    particular purpose, or that the use will not infringe any third party patent,
@REM     copyright or trademark. NXP must not be liable for any loss or damage
@REM                              arising from its use.
@REM
@REM
@REM  $Date: 2016-06-29 16:13:03 +0530 (Wed, 29 Jun 2016) $
@REM  $Author: Purnank G (ing05193) $
@REM  $Revision: 18514 $
@REM

cd /d %~dp0

IF DEFINED PYTHON_EXE GOTO :GOT_PY_EXE
IF EXIST C:\Python27\python.exe (
    SET PYTHON_EXE=C:\Python27\python.exe
    GOTO :GOT_PY_EXE
)

IF EXIST C:\Python27.32\python.exe (
    SET PYTHON_EXE=C:\Python27.32\python.exe
    GOTO :GOT_PY_EXE
)

IF EXIST C:\Python26\python.exe (
    SET PYTHON_EXE=C:\Python26\python.exe
    GOTO :GOT_PY_EXE
)

set PYTHON_EXE=python.exe
:GOT_PY_EXE

IF NOT EXIST user_ee.dir MKDIR user_ee.dir


IF EXIST user_ee.bin del /q user_ee.bin
IF EXIST _user_ee_flat.xml del /q _user_ee_flat.xml

IF EXIST _copy_output_xml_size_html.bat call _copy_output_xml_size_html.bat

@REM
@REM First, flatten the XML
@REM       Most parsers, including XML Mindom of python can not
@REM       use XML Entities. msxsl.exe will flatten it.
@REM
msxsl.exe -xw user_ee.xml        flat.xslt       -o _user_ee_flat.xml

@REM
@REM Process this flattened XML, and generate output files in user_ee.dir

%PYTHON_EXE% user_ee.py _user_ee_flat.xml     user_ee.dir

@REM
@REM _output_xml_sizes.xml, would be generated by user_ee.py
@REM convert into a pretty HTML file so that the same can be
@REM easily shared as a standard reference document
msxsl.exe -v -xw _output_xml_sizes.xml user_ee.xslt -o _output_xml_sizes.html

IF EXIST ..\inc\phCfg_EE.h                   del /q ..\inc\phCfg_EE.h
IF EXIST ..\..\..\..\phCommon\inc\phCfg_EE.h del /q ..\..\..\phCommon\inc\phCfg_EE.h
IF EXIST ..\src\phCfg_EE.c    del /q ..\src\phCfg_EE.c
IF EXIST ..\src\phCfg_PF.c    del /q ..\src\phCfg_PF.c
IF EXIST ..\src\phCfg_Build.c del /q ..\src\phCfg_EE_Build.c

IF     EXIST ..\inc MOVE /y user_ee.dir\phCfg_EE.h                    ..\inc\phCfg_EE.h
IF NOT EXIST ..\inc MOVE /y user_ee.dir\phCfg_EE.h     ..\..\..\phCommon\inc\phCfg_EE.h

IF EXIST _copy_output_xml_size_html.bat call _copy_output_xml_size_html.bat
IF EXIST _copy_output_xml_size_html.bat del  _copy_output_xml_size_html.bat


MOVE /y user_ee.dir\phCfg_EE.c         ..\src\phCfg_EE.c
MOVE /y user_ee.dir\phCfg_PF.c         ..\src\phCfg_PF.c
MOVE /y user_ee.dir\phCfg_EE_Build.c   ..\src\phCfg_EE_Build.c
COPY /y user_ee.dir\output_xml.bin     user_ee.bin

cd /d %~dp0

IF EXIST ..\..\..\..\tools\EEPROM_MRA3 (
     cd /d ..\..\..\..\tools\EEPROM_MRA3
     call ..\binUtils\merge_fullee_with_useree.exe pn640-ee-rom.bin %~dp0user_ee.dir\output_xml.bin pn640-ee-user.bin pn640-ee.bin
     %PYTHON_EXE% eebin_to_rtldat.py   pn640-ee.bin  pn640-ee.dat
     %PYTHON_EXE% eebin_to_fpgabin.py  pn640-ee.bin  pn640-ee-fpga.bin
     copy /y %~dp0_output_xml_sizes.html pn640-ee-user.html
)

copy /y %~dp0_output_xml_sizes.xml PN7462AU_EE_Mapping.xml

cd /d %~dp0
