/*
 * licenseMgr.h
 *
 *  Created on: 16.03.2010
 *      Author: stefan.detter
 */

#ifndef LICENSEMGR_H_
#define LICENSEMGR_H_

#include <hal/types.h>

#define ID_NEEDED			0xE4		// standard
#define ID_AVAILABLE		0xB3		// send magic ID

typedef enum
{
	READERID_AVAILABLE 	= ID_AVAILABLE,
	READERID_NEEDED 	= ID_NEEDED
} LICENSE_MODE;

void  licmgr_init ();

bool  			licmgr_setLicenseMode ( uchar m );
LICENSE_MODE  	licmgr_licenseMode ( );

bool  licmgr_isLicenseAvailable ( );
bool  licmgr_getNextReaderId ( ulong* readerId );

void  licmgr_storeData ( );

void  licmgr_getLicenseInfo ( ulong* startReaderId, ulong* startLicenseCount, ulong* nextReaderId, ulong* remainingLicenseCount );


#endif /* LICENSEMGR_H_ */
