/*
 * licenseProtocol.h
 *
 *  Created on: 16.03.2010
 *      Author: stefan.detter
 */

#ifndef LICENSEPROTOCOL_H_
#define LICENSEPROTOCOL_H_

//------------------------------------------------------------------------------
//		Encrypt / Decrypt
//------------------------------------------------------------------------------
// comment to disable encryption
#define ENCRYPTION_ON 	1
// comment to send other bytes then only 0x00
#define RANDVALS_ON 	1


//------------------------------------------------------------------------------
//  	Defines
//------------------------------------------------------------------------------

/************ Reader Decrypt ***********************/
#define XOR_CRYPT_READERID_VALUE_1				0x1A
#define XOR_CRYPT_READERID_VALUE_2				0x78
#define XOR_CRYPT_READERID_VALUE_3				0x3C
#define XOR_CRYPT_READERID_VALUE_4				0x8E
#define READER_ID_START_INDEX					4
/***************************************************/


/************ Magic numbers ***********************/
#define CONNECTING_START_BYTE_1 				0x33
#define CONNECTING_START_BYTE_2					0x66
#define CONNECTING_START_BYTE_3					0x99
#define CONNECTING_START_BYTE_4					0xBB
#define CONNECTING_START_BYTE_5					0xEE

#define CONNECTING_VALIDATION_BYTE_1			0x94
#define CONNECTING_VALIDATION_BYTE_2			0x39

#define SWITCH_KEY_VALIDATION_BYTE_1			0x98
#define SWITCH_KEY_VALIDATION_BYTE_2			0x34

#define EXCHANGE_BLK_NR_VALIDATION_BYTE_1		0x80
#define EXCHANGE_BLK_NR_VALIDATION_BYTE_2		0x44

#define SWITCH_TO_LOCAL_VALIDATION_BYTE_1		0xBA
#define SWITCH_TO_LOCAL_VALIDATION_BYTE_2		0x84

#define EXCHANGE_ID_VALIDATION_BYTE_1			0x66
#define EXCHANGE_ID_VALIDATION_BYTE_2			0x96
/***************************************************/


/******************** Block Number ****************/
#define BLOCK_NUMBER_XOR_CRYPT_INDEX			15
#define BLOCK_NUMBER_XOR_CRYPT_VALUE			0xA7

#define BLOCK_NUMBER_OFFSET						0x23
#define BLOCK_NUMBER_MAX						40
/**************************************************/


/******************** AES *************************/
#define AES_KEY_LENGTH							32
#define AES_KEY_LENGTH_HALF						(AES_KEY_LENGTH / 2)
/**************************************************/


/******************** Index ***********************/
#define RANDOM_INDEX_1							3
#define RANDOM_INDEX_2							15

#define RANDOM_INDEX_3							11
#define RANDOM_INDEX_4							4

/*! @brief index of reader typ byte 0 */
#define READER_TYPE_INDEX_0						1

/*! @brief index of flow control */
#define PACKET_COUNTER_INDEX					2
/**************************************************/


/******************** Buffer & Length *************/
#define LICENSE_PACKET_SIZE						20
#define LICENSE_PAYLOAD_SIZE					16
#define LICENSE_EX_ID_PACKAGE_COUNT				50
/**************************************************/


/******************** MISC*************************/
#define RANDVAL_SHIFT_VALUE						3
#define RANDOM_OFFSET							0xAA

#define ID_MAGIC_READERID						0xE13478AF  // magic id
/**************************************************/

//------------------------------------------------------------------------------
//  	Typedefs & Enums
//------------------------------------------------------------------------------

/*! @brief Typedef for current state */
typedef enum {
	CONNECTING 					= 0x01,		/*! @brief state: connecting to reader */
	SWITCH_TO_BOOTLOADER_KEY 	= 0x02,		/*! @brief state: receiving random AES Key from reader bootloader */
	EXCHANGE_BLOCK_NR 			= 0x03,		/*! @brief state: exchange the important packet number of the transmitted reader ID */
	SWITCH_TO_LOCALRANDOM_KEY 	= 0x04,		/*! @brief state: transmitted a new random AES key to the bootloader */
	EXCHANGE_ADDITIONAL_INFORMATION 		= 0x05,		/*! @brief state: exchange the transmission channel, different channel (RS-232, Debug) can transfer later the readerID */
	EXCHANGE_ID 				= 0x06,		/*! @brief state: exchange the readerID */
	RANDOM_START 				= 0x07,		/*! @brief state: prepare sending of several random packets */
	RANDOM 						= 0x08,		/*! @brief state: sending several random packets */
} eSTATE;

/*! @brief Typedef for current result */
typedef enum {
	RES_START1 = 0x01,					/*! @brief result: start transaction */
	RES_START2 = 0x02,					/*! @brief result: transaction success */
	RES_START3 = 0x03,					/*! @brief result: failure at flash write ID -> important */
	RES_PAYLOAD = 0x04,					/*! @brief result: failure at flash write ID -> important */
} ePROTOCOL;

//------------------------------------------------------------------------------
//  	Global Functions
//------------------------------------------------------------------------------

void licProtocol_init ( );

bool licProtocol_atReset ( );

void licProtocol_resetState ( );

void licProtocol_startLiceneseProcess ( );

void licProtocol_handleLicensePackage ( uchar* payloadIn, uint payloadIn_length );

#endif /* LICENSEPROTOCOL_H_ */
