/*!
 * @file	readerHostProtocolComm.h
 * @brief	The platform independent implementation of the communication module
 */

#ifndef READERHOSTCOMM_H_
#define READERHOSTCOMM_H_

#include <def.h>
#include <hal/types.h>

/*! @brief Bit mask for serial interface */
#define READER_HOST_SERIAL_COMM_INTERFACE 		0x0001
/*! @brief Bit mask for cdc interface */
#define READER_HOST_CDC_COMM_INTERFACE 	 		0x0002
/*! @brief Bit mask for hid interface */
#define READER_HOST_HID_COMM_INTERFACE 	 		0x0004
/*! @brief Bit mask for ethernet interface */
#define READER_HOST_ETHERNET_COM_INTERFACE		0x0008

void 	protocolComm_configureCommunication (void);
void 	protocolComm_processCommunication (void);

uint 	protocolComm_sendBytes (uchar* buffer, uint size);
uint 	protocolComm_bytesAvailable (void);
uchar 	protocolComm_readByte (void);
uint 	protocolComm_readBytesIntoBuffer (uchar* buffer, uint size);

#endif /* READERHOSTCOMM_H_ */
