/*
 * rand.c
 *
 *  Created on: 16.03.2010
 *      Author: stefan.detter
 */

#include "random.h"
#include <utility/rand.h>
#include <utility/trace.h>

/*! @brief contains srand seed, increased every main while(1) cycle  */
ulong g_rand_seed;

void rand_initialize ( )
{
	TRACE_INFO("Random:\t seed init = %u \n\r", (uint)g_rand_seed);
	srand(g_rand_seed);
}

ulong rand_getNextRandomValue ( )
{
	return rand();
}

/*! @brief generates random numbers between min and max */
uint rand_getSpecificRandom(uchar min, uchar max)
{
	return (rand_getNextRandomValue() % (max + 1 - min)) + min;
}
