/*
 * report.h
 *
 *  Created on: 16.03.2010
 *      Author: stefan.detter
 */

#ifndef REPORT_H_
#define REPORT_H_

#include <hal/types.h>

//------------------------------------------------------------------------------
//  	Defines
//------------------------------------------------------------------------------

typedef enum {
	FLAG_NEW_ID_ASSIGNED		= 0x00000001,
} SUCCES_FLAGS;

typedef enum {
	MagicRandValError		= 0x00,
	TimeOutError			= 0x01,
} ERROR_TYPE;

//------------------------------------------------------------------------------
//  	Global Functions
//------------------------------------------------------------------------------
void report_init( );


void report_writeSuccessReport( ulong readerType, ulong readerID, ulong flags );

void report_incrementErrorCount(ERROR_TYPE type);


ulong report_getReportCount();

void  report_getReport(ulong index, ulong* readerId, ulong* readerType, ulong* flags );

#endif /* REPORT_H_ */
