/*
 * def.h
 *
 *  Created on: 16.03.2010
 *      Author: stefan.detter
 */

#ifndef DEF_H_
#define DEF_H_


/*! @brief Specifies if the debug output of the usb cdc should be used. */
#define DBG_USBCDC		0

#define DBG_RHPROT		0

#define DBG_LICENSE		1

#define DBG_STORE		1

#define DBG_LICMGR		0

#define DBG_REPORT		0



//------------------------------------------------------------------------------
//  	Global Define
//------------------------------------------------------------------------------

#define FLASH_START_ADDRESS 	(0x100000)
#define FLASH_OFFSET			(FLASH_START_ADDRESS + 0x10000) // Flash + 64 KB

#define EEPROM_OFFSET			0x00000000


#define LICENSE_DATA_ADDRESS	0x00000000

#define REPORT_INFO_ADDRESS		0x00000020
#define REPORT_DATA_ADDRESS		0x00000050


typedef enum {
	STORE_ACCESS_PROBLEM		= 0xA1,
	STORE_INCONSISTANT_PROBLEM	= 0xA2,
} UNDEFINED_STATE_INFO;


/*! @brief Watchdog rest */
#define WDR()  AT91C_BASE_WDTC->WDTC_WDCR = (0xA5 << 24) | AT91C_WDTC_WDRSTT;


/*! @brief Telling the compiler to run the function out of ram an not out of flash */
#define __ramfunc __attribute__((section (".ramfunc")))

#endif /* DEF_H_ */
