/*
 * boardLed.h
 *
 *  Created on: 13.07.2009
 *      Author: stefan.detter
 */

#ifndef BOARDLED_H_
#define BOARDLED_H_

#include <hal/pins.h>
#include <hal/types.h>
#include <pio/pio.h>

#if (defined PINS_READ_LED_MASK) && (defined PINS_READ_LED_PIO) && (defined PINS_READ_LED_PIO_ID)

	#if (defined PINS_POWER_LED_MASK) && (defined PINS_POWER_LED_PIO) && (defined PINS_POWER_LED_PIO_ID)
		#define PINS_POWER_LED 	{PINS_POWER_LED_MASK, 	PINS_POWER_LED_PIO,  	PINS_POWER_LED_PIO_ID, 	PIO_OUTPUT_1, 	PIO_DEFAULT}
	#endif

	#define PINS_READ_LED 	{PINS_READ_LED_MASK, 	PINS_READ_LED_PIO,  	PINS_READ_LED_PIO_ID, 	PIO_OUTPUT_0, 	PIO_DEFAULT}

	#ifdef PINS_POWER_LED
		#define	INIT_INFO_LED() \
		{ \
			Pin info = PINS_READ_LED; \
			PIO_Configure(&info, 1); \
			Pin power = PINS_POWER_LED; \
			PIO_Configure(&power, 1); \
		}
	#else
		#define INIT_INFO_LED()	\
		{ \
			Pin info = PINS_READ_LED; \
			PIO_Configure(&info, 1); \
		}
	#endif

	extern bool g_ledOn;

	/*! Macro that sets the READ LED to on */
	#define SET_INFO_LED() 			PINS_READ_LED_PIO->PIO_SODR = PINS_READ_LED_MASK;
	/*! Macro that sets the READ LED to off */
	#define CLEAR_INFO_LED() 		PINS_READ_LED_PIO->PIO_CODR = PINS_READ_LED_MASK;

	/*! Macro that toggles the READ LED */
	#define TOGGLE_INFO_LED() \
	{ \
		if(g_ledOn == true){ \
			CLEAR_INFO_LED(); \
			g_ledOn = false; \
		} \
		else { \
			SET_INFO_LED(); \
			g_ledOn = true; \
		} \
	}

#endif

#if !defined(INIT_INFO_LED)
	#define INIT_INFO_LED() 	{}
#endif
#if !defined(SET_INFO_LED)
	#define SET_INFO_LED() 		{}
#endif
#if !defined(CLEAR_INFO_LED)
	#define CLEAR_INFO_LED() 	{}
#endif
#if !defined(TOGGLE_INFO_LED)
	#define TOGGLE_INFO_LED() 	{}
#endif


#endif /* BOARDLED_H_ */
