/*!
 * @file	flags.h
 * @brief	Helper functions to read and write the flash
 */


#ifndef FLAGS_H_
#define FLAGS_H_

#include <def.h>
#include <hal/types.h>

void 	flash_initDriver ( );
ulong 	flash_read( ulong address, uchar* buffer, ulong size );
ulong 	flash_write( ulong address, uchar* buffer, ulong size );

bool 	flags_setFlashValue ( ulong address, ulong value );
ulong 	flags_getFlashValue ( ulong address );

#endif /* FLAGS_H_ */
