/*
 * Copyright (c) 2008-2016, RF-Embedded GmbH
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright notice,
 *     this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "CPPrfeMessageQueue.h"

using namespace CPPrfeReaderInterface;

CPPrfeMessageQueue::CPPrfeMessageQueue()
{

}

void CPPrfeMessageQueue::enqueueMessage(ushort id, std::vector<byte> message)
{
    m_mutex.lock();
    m_messageQueue[id].push_back(message);
    m_mutex.unlock();
}

std::vector<byte> CPPrfeMessageQueue::waitForMessage(ushort id, int msecs, bool& ok)
{
    int i = 0;
    int cycles = msecs / 10;

    ok = false;

    std::vector<byte> ret;

    // check for the flag for the given time
    while(i++ < cycles)
    {
        m_mutex.lock();
        if (m_messageQueue[id].size() > 0)
        {
            std::list< std::vector<byte> >& list = m_messageQueue[id];
            ret = list.front();
            list.pop_front();
            ok = true;
        }
        m_mutex.unlock();

        if (ok == true)
            break;

        Sleeper::msleep(10);
    }

    return ret;
}

void CPPrfeMessageQueue::clearMessage(ushort id)
{
    m_mutex.lock();
    m_messageQueue.erase(id);
    m_mutex.unlock();
}
