#ifndef TIMER_H
#define TIMER_H

#ifdef WINDOWS
#   include <Windows.h>
#endif
#ifdef POSIX
#   include <iostream>
#   include <ctime>
#endif

class Timer
{
public:
    Timer();

    double elapsed();

    void reset();

private:
#ifdef WINDOWS
    DWORD beg_;
    DWORD end_;
#endif

#ifdef POSIX
    timespec beg_, end_;
#endif
};

#endif // TIMER_H
