/*
 * Copyright (c) 2008-2018, RF-Embedded GmbH
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright notice,
 *     this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef QRFEREADERINTERFACE_H
#define QRFEREADERINTERFACE_H

#include <QMetaType>

#include "trace/QrfeTraceInterface.h"
#include "protocol/QrfeTagEvent.h"

namespace QrfeReaderInterface
{
/**
     * @brief The Global class
     */
    class Global
    {
    public:
        /**
         * @brief Global Constructor registers meta types
         */
        Global()
        {
            qRegisterMetaType<QrfeReaderInterface::QrfeTagEvent>("QrfeTagEvent");
        }

        /**
         * @brief m_tracer Instance of the used tracer
         */
        static QrfeTraceInterface* m_tracer;

        /**
         * @brief trc Global static function to trace a message to the used tracer
         * @param level     Level of the trace message
         * @param text      Trace message
         */
        static void trc(int level, QString text)
        {
            if(m_tracer != 0)
                m_tracer->trc(level, text);
        }
    };


    /**
     * @brief ___init Static instance of the Global class forces to call the constructor on start up.
     */
    static Global ___init;
}

#endif // QRFEREADERINTERFACE_H
