/*
 * Copyright (c) 2008-2018, RF-Embedded GmbH
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright notice,
 *     this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "QrfeProtocolConstants.h"

/**
 * @brief QrfeReaderInterface::toString converts enum to string
 * @param ret   Enum
 * @return String
 */
QString QrfeReaderInterface::toString(eRFE_RET_VALUE ret)
{

    switch(ret)
    {
    case RFE_RET_SUCCESS               : return "RFE_RET_SUCCESS";
    case RFE_RET_RESULT_PENDING        : return "RFE_RET_RESULT_PENDING";
    case RFE_RET_ERR_OP_NOT_SUPPORTED  : return "RFE_RET_ERR_OP_NOT_SUPPORTED";
    case RFE_RET_ERR_UNKOWN_ERR        : return "RFE_RET_ERR_UNKOWN_ERR";
    case RFE_RET_ERR_ON_EXEC_OP        : return "RFE_RET_ERR_ON_EXEC_OP";
    case RFE_RET_ERR_COULD_NOT_WRITE   : return "RFE_RET_ERR_COULD_NOT_WRITE";
    case RFE_RET_ERR_WRONG_PARAM_COUNT : return "RFE_RET_ERR_WRONG_PARAM_COUNT";
    case RFE_RET_ERR_WRONG_PARAM       : return "RFE_RET_ERR_WRONG_PARAM";
    case RFE_RET_TMI_TAG_UNREACHABLE   : return "RFE_RET_TMI_TAG_UNREACHABLE";
    case RFE_RET_TMI_MEM_OVERRUN       : return "RFE_RET_TMI_MEM_OVERRUN";
    case RFE_RET_TMI_MEM_LOCKED        : return "RFE_RET_TMI_MEM_LOCKED";
    case RFE_RET_TMI_INSUFFICIENT_POWER: return "RFE_RET_TMI_INSUFFICIENT_POWER";
    case RFE_RET_TMI_WRONG_PASSWORD    : return "RFE_RET_TMI_WRONG_PASSWORD";
    default                            : return "UNKNWON";
    }
}

/**
 * @brief QrfeReaderInterface::toString converts enum to string
 * @param state Enum
 * @return String
 */
QString QrfeReaderInterface::toString(eRFE_CURRENT_READER_STATE state)
{
    switch(state)
    {
    case RFE_STATE_IDLE     : return "RFE_STATE_IDLE";
    case RFE_STATE_REBOOTING: return "RFE_STATE_REBOOTING";
    case RFE_STATE_SCANNING : return "RFE_STATE_SCANNING";
    case RFE_STATE_WRITING  : return "RFE_STATE_WRITING";
    case RFE_STATE_READING  : return "RFE_STATE_READING";
    default                 : return "UNKNWON";
    }
}


