/*
 * Copyright (c) 2008-2018, RF-Embedded GmbH
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright notice,
 *     this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef TESTWIDGET_H
#define TESTWIDGET_H

#include <QWidget>
#include <QTime>

#include <protocol/QrfeTagEvent.h>

namespace Ui {
    class TestWidget;
}

namespace QrfeReaderInterface
{
    class QrfeProtocolHandler;
    class QrfeTagEvent;
    class QrfeTraceInterface;
}

class TestWidget : public QWidget
{
    Q_OBJECT

    typedef enum
    {
        IDLE,
        RUNNING,
        FINISHED
    } TEST_STATE;
    
public:
    explicit TestWidget(QWidget *parent = 0);
    ~TestWidget();

    void init(QString serialPort);
    void init(QString ip, ushort port);

private:
    void init(QIODevice* dev);

private slots:
    void startStopExit();

private:
    void test(int id, bool start, int &states);
    void test_ReaderInfo(bool start, int &states);
    void test_Attenuation(bool start, int &states);
    void test_Frequency(bool start, int &states);
    void test_Sensitivity(bool start, int &states);
    void test_Heartbeat(bool start, int &states);
    void test_GPIO_Output(bool start, int &states);
    void test_GPIO_Input(bool start, int &states);
    void test_Inventory(bool start, int &states);
    void test_SingleInventory(bool start, int &states);

    void test_InventoryRSSI(bool start, int &states);
    void test_InventoryPostDetectREAD(bool start, int &states);
    void test_ReadTID(bool start, int &states);
    void test_ReadWriteUser(bool start, int &states);
    void test_ReadBlockWriteUser(bool start, int &states);

    void test_AN001_ReadTIDFirstTag_Slow(bool start, int &states);
    void test_AN001_ReadTIDFirstTag_Fast(bool start, int &states);
    void test_AN001_ReadTIDFirstTag_Handle(bool start, int &states);

private slots:
    void heartBeat ();
    void cyclicInventory (const QrfeReaderInterface::QrfeTagEvent &tagInfo);
    void stateChanged (const int newState);
    void statusRegisterChanged (const qulonglong statusRegister);
    void gpioValuesChanged ( const ulong gpioValues );

private slots:
    void printMenu();
    void print(const QString& str = QString());
    void clear();

private:
    bool waitForSignal(QObject *sender, const char *signal, int timeout = 5000);
    
private:
    Ui::TestWidget *ui;

    QrfeReaderInterface::QrfeProtocolHandler* m_ph;
    QrfeReaderInterface::QrfeTraceInterface*  m_trc;

    int         m_currentTestRoutine;
    TEST_STATE  m_currentTestState;

    QTime       m_heartBeatTime;

    QTime       m_cyclicInvTime;
    ulong       m_cyclicInvCount;

    bool                                m_lastTagEventValid;
    QrfeReaderInterface::QrfeTagEvent   m_lastTagEvent;
};

#endif // TESTWIDGET_H
